/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import java.util.OptionalDouble;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.DoubleStringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class OptionalDoubleStringConverter
implements StringConverter<OptionalDouble> {
    private static DoubleStringConverter DOUBLE_CONVERTER = DoubleStringConverter.create();

    private OptionalDoubleStringConverter() {
    }

    public static OptionalDoubleStringConverter create() {
        return new OptionalDoubleStringConverter();
    }

    @Override
    public TypeToken<OptionalDouble> type() {
        return TypeToken.of(OptionalDouble.class);
    }

    @Override
    public String toString(OptionalDouble object) {
        if (!object.isPresent()) {
            return null;
        }
        return DOUBLE_CONVERTER.toString(object.getAsDouble());
    }

    @Override
    public OptionalDouble fromString(String string) {
        if (string == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(DOUBLE_CONVERTER.fromString(string));
    }
}

