/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.Optional;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public class OptionalAttributeConverter<T>
implements AttributeConverter<Optional<T>> {
    private final AttributeConverter delegate;

    private OptionalAttributeConverter(AttributeConverter delegate) {
        this.delegate = delegate;
    }

    public static OptionalAttributeConverter create(AttributeConverter delegate) {
        return new OptionalAttributeConverter(delegate);
    }

    @Override
    public TypeToken<Optional<T>> type() {
        return TypeToken.optionalOf(this.delegate.type().rawClass());
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(Optional<T> input) {
        if (!input.isPresent()) {
            return EnhancedAttributeValue.nullValue().toAttributeValue();
        }
        return this.delegate.transformFrom(input.get());
    }

    @Override
    public Optional<T> transformTo(AttributeValue input) {
        Optional result = input.nul() != false ? Optional.empty() : Optional.ofNullable(this.delegate.transformTo(input));
        return result;
    }
}

