/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.CharacterStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class CharacterAttributeConverter
implements AttributeConverter<Character>,
PrimitiveConverter<Character> {
    private static final Visitor VISITOR = new Visitor();
    private static final CharacterStringConverter STRING_CONVERTER = CharacterStringConverter.create();

    private CharacterAttributeConverter() {
    }

    public static CharacterAttributeConverter create() {
        return new CharacterAttributeConverter();
    }

    @Override
    public TypeToken<Character> type() {
        return TypeToken.of(Character.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(Character input) {
        return EnhancedAttributeValue.fromString(STRING_CONVERTER.toString(input)).toAttributeValue();
    }

    @Override
    public Character transformTo(AttributeValue input) {
        if (input.s() != null) {
            return EnhancedAttributeValue.fromString(input.s()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    @Override
    public TypeToken<Character> primitiveType() {
        return TypeToken.of(Character.TYPE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Character> {
        private Visitor() {
            super(Character.class, CharacterAttributeConverter.class);
        }

        @Override
        public Character convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

