/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public abstract class TypeConvertingVisitor<T> {
    protected final Class<?> targetType;
    private final Class<?> converterClass;

    protected TypeConvertingVisitor(Class<?> targetType) {
        this(targetType, null);
    }

    protected TypeConvertingVisitor(Class<?> targetType, Class<?> converterClass) {
        Validate.paramNotNull(targetType, (String)"targetType");
        this.targetType = targetType;
        this.converterClass = converterClass;
    }

    public final T convert(EnhancedAttributeValue value) {
        switch (value.type()) {
            case NULL: {
                return this.convertNull();
            }
            case M: {
                return this.convertMap(value.asMap());
            }
            case S: {
                return this.convertString(value.asString());
            }
            case N: {
                return this.convertNumber(value.asNumber());
            }
            case B: {
                return this.convertBytes(value.asBytes());
            }
            case BOOL: {
                return this.convertBoolean(value.asBoolean());
            }
            case SS: {
                return this.convertSetOfStrings(value.asSetOfStrings());
            }
            case NS: {
                return this.convertSetOfNumbers(value.asSetOfNumbers());
            }
            case BS: {
                return this.convertSetOfBytes(value.asSetOfBytes());
            }
            case L: {
                return this.convertListOfAttributeValues(value.asListOfAttributeValues());
            }
        }
        throw new IllegalStateException("Unsupported type: " + (Object)((Object)value.type()));
    }

    public T convertNull() {
        return null;
    }

    public T convertMap(Map<String, EnhancedAttributeValue> value) {
        return this.defaultConvert(AttributeValueType.M, value);
    }

    public T convertString(String value) {
        return this.defaultConvert(AttributeValueType.S, value);
    }

    public T convertNumber(String value) {
        return this.defaultConvert(AttributeValueType.N, value);
    }

    public T convertBytes(SdkBytes value) {
        return this.defaultConvert(AttributeValueType.B, value);
    }

    public T convertBoolean(Boolean value) {
        return this.defaultConvert(AttributeValueType.BOOL, value);
    }

    public T convertSetOfStrings(List<String> value) {
        return this.defaultConvert(AttributeValueType.SS, value);
    }

    public T convertSetOfNumbers(List<String> value) {
        return this.defaultConvert(AttributeValueType.NS, value);
    }

    public T convertSetOfBytes(List<SdkBytes> value) {
        return this.defaultConvert(AttributeValueType.BS, value);
    }

    public T convertListOfAttributeValues(List<EnhancedAttributeValue> value) {
        return this.defaultConvert(AttributeValueType.L, value);
    }

    public T defaultConvert(AttributeValueType type, Object value) {
        if (this.converterClass != null) {
            throw new IllegalStateException(this.converterClass.getTypeName() + " cannot convert an attribute of type " + (Object)((Object)type) + " into the requested type " + this.targetType);
        }
        throw new IllegalStateException("Cannot convert attribute of type " + (Object)((Object)type) + " into a " + this.targetType);
    }
}

