/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticAttributeType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.Attribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeType;

@SdkPublicApi
public final class Attributes {
    private static final AttributeConverterProvider DEFAULT_CONVERTER_PROVIDER = AttributeConverterProvider.defaultProvider();

    private Attributes() {
    }

    public static <T, R> Attribute.AttributeSupplier<T> attribute(String attributeName, TypeToken<R> attributeType, Function<T, R> getAttributeMethod, BiConsumer<T, R> updateItemMethod) {
        return Attributes.attribute(attributeName, attributeType, getAttributeMethod, updateItemMethod, DEFAULT_CONVERTER_PROVIDER);
    }

    public static <T, R> Attribute.AttributeSupplier<T> attribute(String attributeName, TypeToken<R> attributeType, Function<T, R> getAttributeMethod, BiConsumer<T, R> updateItemMethod, AttributeConverterProvider converterProvider) {
        AttributeConverter<R> attributeConverter = converterProvider.converterFor(attributeType);
        AttributeType<R> attribute = StaticAttributeType.create(attributeConverter);
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, attribute);
    }
}

