/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.Period;
import java.time.format.DateTimeParseException;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.PeriodStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class PeriodAttributeConverter
implements AttributeConverter<Period> {
    private static final Visitor VISITOR = new Visitor();
    private static final PeriodStringConverter STRING_CONVERTER = PeriodStringConverter.create();

    private PeriodAttributeConverter() {
    }

    public static PeriodAttributeConverter create() {
        return new PeriodAttributeConverter();
    }

    @Override
    public TypeToken<Period> type() {
        return TypeToken.of(Period.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(Period input) {
        return EnhancedAttributeValue.fromString(STRING_CONVERTER.toString(input)).toAttributeValue();
    }

    @Override
    public Period transformTo(AttributeValue input) {
        try {
            return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Period> {
        private Visitor() {
            super(Period.class, PeriodAttributeConverter.class);
        }

        @Override
        public Period convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

