/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.DefaultParameterizedType;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
@Immutable
public class TypeToken<T> {
    private final boolean isWildcard;
    private final Class<T> rawClass;
    private final List<TypeToken<?>> rawClassParameters;

    protected TypeToken() {
        this(null);
    }

    private TypeToken(Type type) {
        if (type == null) {
            type = this.captureGenericTypeArguments();
        }
        if (type instanceof WildcardType) {
            this.isWildcard = true;
            this.rawClass = null;
            this.rawClassParameters = null;
        } else {
            this.isWildcard = false;
            this.rawClass = this.validateAndConvert(type);
            this.rawClassParameters = this.loadTypeParameters(type);
        }
    }

    private TypeToken(Class<?> rawClass, List<TypeToken<?>> rawClassParameters) {
        this.rawClass = rawClass;
        this.rawClassParameters = rawClassParameters;
        this.isWildcard = false;
    }

    public static <T> TypeToken<T> of(Class<T> type) {
        return new TypeToken<T>(type);
    }

    public static TypeToken<?> of(Type type) {
        return new TypeToken(type);
    }

    public static <T> TypeToken<Optional<T>> optionalOf(Class<T> valueType) {
        return new TypeToken<Optional<T>>(DefaultParameterizedType.parameterizedType(Optional.class, valueType));
    }

    public static <T> TypeToken<List<T>> listOf(Class<T> valueType) {
        return new TypeToken<List<T>>(DefaultParameterizedType.parameterizedType(List.class, valueType));
    }

    public static <T> TypeToken<List<T>> listOf(TypeToken<T> valueType) {
        return new TypeToken<List<T>>(List.class, Arrays.asList(valueType));
    }

    public static <T> TypeToken<Set<T>> setOf(Class<T> valueType) {
        return new TypeToken<Set<T>>(DefaultParameterizedType.parameterizedType(Set.class, valueType));
    }

    public static <T> TypeToken<Set<T>> setOf(TypeToken<T> valueType) {
        return new TypeToken<Set<T>>(Set.class, Arrays.asList(valueType));
    }

    public static <T> TypeToken<SortedSet<T>> sortedSetOf(Class<T> valueType) {
        return new TypeToken<SortedSet<T>>(DefaultParameterizedType.parameterizedType(SortedSet.class, valueType));
    }

    public static <T> TypeToken<SortedSet<T>> sortedSetOf(TypeToken<T> valueType) {
        return new TypeToken<SortedSet<T>>(SortedSet.class, Arrays.asList(valueType));
    }

    public static <T> TypeToken<Queue<T>> queueOf(Class<T> valueType) {
        return new TypeToken<Queue<T>>(DefaultParameterizedType.parameterizedType(Queue.class, valueType));
    }

    public static <T> TypeToken<Queue<T>> queueOf(TypeToken<T> valueType) {
        return new TypeToken<Queue<T>>(Queue.class, Arrays.asList(valueType));
    }

    public static <T> TypeToken<Deque<T>> dequeOf(Class<T> valueType) {
        return new TypeToken<Deque<T>>(DefaultParameterizedType.parameterizedType(Deque.class, valueType));
    }

    public static <T> TypeToken<Deque<T>> dequeOf(TypeToken<T> valueType) {
        return new TypeToken<Deque<T>>(Deque.class, Arrays.asList(valueType));
    }

    public static <T> TypeToken<NavigableSet<T>> navigableSetOf(Class<T> valueType) {
        return new TypeToken<NavigableSet<T>>(DefaultParameterizedType.parameterizedType(NavigableSet.class, valueType));
    }

    public static <T> TypeToken<NavigableSet<T>> navigableSetOf(TypeToken<T> valueType) {
        return new TypeToken<NavigableSet<T>>(NavigableSet.class, Arrays.asList(valueType));
    }

    public static <T> TypeToken<Collection<T>> collectionOf(Class<T> valueType) {
        return new TypeToken<Collection<T>>(DefaultParameterizedType.parameterizedType(Collection.class, valueType));
    }

    public static <T> TypeToken<Collection<T>> collectionOf(TypeToken<T> valueType) {
        return new TypeToken<Collection<T>>(Collection.class, Arrays.asList(valueType));
    }

    public static <T, U> TypeToken<Map<T, U>> mapOf(Class<T> keyType, Class<U> valueType) {
        return new TypeToken<Map<T, U>>(DefaultParameterizedType.parameterizedType(Map.class, keyType, valueType));
    }

    public static <T, U> TypeToken<Map<T, U>> mapOf(TypeToken<T> keyType, TypeToken<U> valueType) {
        return new TypeToken<Map<T, U>>(Map.class, Arrays.asList(keyType, valueType));
    }

    public static <T, U> TypeToken<SortedMap<T, U>> sortedMapOf(Class<T> keyType, Class<U> valueType) {
        return new TypeToken<SortedMap<T, U>>(DefaultParameterizedType.parameterizedType(SortedMap.class, keyType, valueType));
    }

    public static <T, U> TypeToken<SortedMap<T, U>> sortedMapOf(TypeToken<T> keyType, TypeToken<U> valueType) {
        return new TypeToken<SortedMap<T, U>>(SortedMap.class, Arrays.asList(keyType, valueType));
    }

    public static <T, U> TypeToken<ConcurrentMap<T, U>> concurrentMapOf(Class<T> keyType, Class<U> valueType) {
        return new TypeToken<ConcurrentMap<T, U>>(DefaultParameterizedType.parameterizedType(ConcurrentMap.class, keyType, valueType));
    }

    public static <T, U> TypeToken<ConcurrentMap<T, U>> concurrentMapOf(TypeToken<T> keyType, TypeToken<U> valueType) {
        return new TypeToken<ConcurrentMap<T, U>>(ConcurrentMap.class, Arrays.asList(keyType, valueType));
    }

    public static <T, U> TypeToken<NavigableMap<T, U>> navigableMapOf(Class<T> keyType, Class<U> valueType) {
        return new TypeToken<NavigableMap<T, U>>(DefaultParameterizedType.parameterizedType(NavigableMap.class, keyType, valueType));
    }

    public static <T, U> TypeToken<NavigableMap<T, U>> navigableMapOf(TypeToken<T> keyType, TypeToken<U> valueType) {
        return new TypeToken<NavigableMap<T, U>>(NavigableMap.class, Arrays.asList(keyType, valueType));
    }

    private static Type validateIsSupportedType(Type type) {
        Validate.validState((type != null ? 1 : 0) != 0, (String)"Type must not be null.", (Object[])new Object[0]);
        Validate.validState((!(type instanceof GenericArrayType) ? 1 : 0) != 0, (String)"Array type %s is not supported. Use java.util.List instead of arrays.", (Object[])new Object[]{type});
        Validate.validState((!(type instanceof TypeVariable) ? 1 : 0) != 0, (String)"Type variable type %s is not supported.", (Object[])new Object[]{type});
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Validate.validState((wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0] == Object.class ? 1 : 0) != 0, (String)"Non-Object wildcard type upper bounds are not supported.", (Object[])new Object[0]);
            Validate.validState((wildcardType.getLowerBounds().length == 0 ? 1 : 0) != 0, (String)"Wildcard type lower bounds are not supported.", (Object[])new Object[0]);
        }
        return type;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public Class<T> rawClass() {
        Validate.isTrue((!this.isWildcard ? 1 : 0) != 0, (String)"A wildcard type is not expected here.", (Object[])new Object[0]);
        return this.rawClass;
    }

    public List<TypeToken<?>> rawClassParameters() {
        Validate.isTrue((!this.isWildcard ? 1 : 0) != 0, (String)"A wildcard type is not expected here.", (Object[])new Object[0]);
        return this.rawClassParameters;
    }

    public boolean isSuperTypeOf(TypeToken<?> rhs) {
        if (this.isWildcard) {
            return true;
        }
        if (!this.rawClass.isAssignableFrom(rhs.rawClass)) {
            return false;
        }
        if (this.rawClass.equals(rhs.rawClass)) {
            if (this.rawClassParameters.size() != rhs.rawClassParameters.size()) {
                return false;
            }
            for (int i = 0; i < this.rawClassParameters.size(); ++i) {
                if (this.rawClassParameters.get(i).isSuperTypeOf(rhs.rawClassParameters.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    private Type captureGenericTypeArguments() {
        Type superclass = this.getClass().getGenericSuperclass();
        ParameterizedType parameterizedSuperclass = (ParameterizedType)Validate.isInstanceOf(ParameterizedType.class, (Object)superclass, (String)"%s isn't parameterized", (Object[])new Object[]{superclass});
        return parameterizedSuperclass.getActualTypeArguments()[0];
    }

    private Class<T> validateAndConvert(Type type) {
        TypeToken.validateIsSupportedType(type);
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.validateAndConvert(parameterizedType.getRawType());
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    private List<TypeToken<?>> loadTypeParameters(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return Collections.emptyList();
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return Collections.unmodifiableList(Arrays.stream(parameterizedType.getActualTypeArguments()).peek(t -> Validate.validState((t != null ? 1 : 0) != 0, (String)"Invalid type argument.", (Object[])new Object[0])).map(TypeToken::new).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeToken)) {
            return false;
        }
        TypeToken typeToken = (TypeToken)o;
        return this.rawClass.equals(typeToken.rawClass) && this.rawClassParameters.equals(typeToken.rawClassParameters);
    }

    public int hashCode() {
        int result = this.rawClass.hashCode();
        result = 31 * result + this.rawClassParameters.hashCode();
        return result;
    }

    public String toString() {
        return "TypeToken(" + this.innerToString() + ")";
    }

    private StringBuilder innerToString() {
        StringBuilder result = new StringBuilder();
        result.append(this.rawClass.getTypeName());
        if (!this.rawClassParameters.isEmpty()) {
            result.append("<");
            result.append(this.rawClassParameters.stream().map(TypeToken::innerToString).collect(Collectors.joining(", ")));
            result.append(">");
        }
        return result;
    }
}

