/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DynamoDbEnhancedAsyncClient;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.DefaultDynamoDbAsyncTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchGetItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchGetResultPage;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchWriteItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchWriteResult;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.TransactGetItemsEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.TransactGetResultPage;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.TransactWriteItemsEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.BatchGetItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.BatchWriteItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.TransactGetItemsOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.TransactWriteItemsOperation;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;

@SdkInternalApi
public final class DefaultDynamoDbEnhancedAsyncClient
implements DynamoDbEnhancedAsyncClient {
    private final DynamoDbAsyncClient dynamoDbClient;
    private final MapperExtension mapperExtension;

    private DefaultDynamoDbEnhancedAsyncClient(DynamoDbAsyncClient dynamoDbClient, MapperExtension mapperExtension) {
        this.dynamoDbClient = dynamoDbClient;
        this.mapperExtension = mapperExtension;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> DefaultDynamoDbAsyncTable<T> table(String tableName, TableSchema<T> tableSchema) {
        return new DefaultDynamoDbAsyncTable<T>(this.dynamoDbClient, this.mapperExtension, tableSchema, tableName);
    }

    @Override
    public SdkPublisher<BatchGetResultPage> batchGetItem(BatchGetItemEnhancedRequest request) {
        BatchGetItemOperation operation = BatchGetItemOperation.create(request);
        return operation.executeAsync(this.dynamoDbClient, this.mapperExtension);
    }

    @Override
    public SdkPublisher<BatchGetResultPage> batchGetItem(Consumer<BatchGetItemEnhancedRequest.Builder> requestConsumer) {
        BatchGetItemEnhancedRequest.Builder builder = BatchGetItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.batchGetItem(builder.build());
    }

    @Override
    public CompletableFuture<BatchWriteResult> batchWriteItem(BatchWriteItemEnhancedRequest request) {
        BatchWriteItemOperation operation = BatchWriteItemOperation.create(request);
        return operation.executeAsync(this.dynamoDbClient, this.mapperExtension);
    }

    @Override
    public CompletableFuture<BatchWriteResult> batchWriteItem(Consumer<BatchWriteItemEnhancedRequest.Builder> requestConsumer) {
        BatchWriteItemEnhancedRequest.Builder builder = BatchWriteItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.batchWriteItem(builder.build());
    }

    @Override
    public CompletableFuture<List<TransactGetResultPage>> transactGetItems(TransactGetItemsEnhancedRequest request) {
        TransactGetItemsOperation operation = TransactGetItemsOperation.create(request);
        return operation.executeAsync(this.dynamoDbClient, this.mapperExtension);
    }

    @Override
    public CompletableFuture<List<TransactGetResultPage>> transactGetItems(Consumer<TransactGetItemsEnhancedRequest.Builder> requestConsumer) {
        TransactGetItemsEnhancedRequest.Builder builder = TransactGetItemsEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.transactGetItems(builder.build());
    }

    @Override
    public CompletableFuture<Void> transactWriteItems(TransactWriteItemsEnhancedRequest request) {
        TransactWriteItemsOperation operation = TransactWriteItemsOperation.create(request);
        return operation.executeAsync(this.dynamoDbClient, this.mapperExtension);
    }

    @Override
    public CompletableFuture<Void> transactWriteItems(Consumer<TransactWriteItemsEnhancedRequest.Builder> requestConsumer) {
        TransactWriteItemsEnhancedRequest.Builder builder = TransactWriteItemsEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.transactWriteItems(builder.build());
    }

    public DynamoDbAsyncClient dynamoDbAsyncClient() {
        return this.dynamoDbClient;
    }

    public MapperExtension mapperExtension() {
        return this.mapperExtension;
    }

    public Builder toBuilder() {
        return DefaultDynamoDbEnhancedAsyncClient.builder().dynamoDbClient(this.dynamoDbClient).extendWith(this.mapperExtension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamoDbEnhancedAsyncClient that = (DefaultDynamoDbEnhancedAsyncClient)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        return this.mapperExtension != null ? this.mapperExtension.equals(that.mapperExtension) : that.mapperExtension == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.mapperExtension != null ? this.mapperExtension.hashCode() : 0);
        return result;
    }

    public static final class Builder
    implements DynamoDbEnhancedAsyncClient.Builder {
        private DynamoDbAsyncClient dynamoDbClient;
        private MapperExtension mapperExtension;

        private Builder() {
        }

        @Override
        public DefaultDynamoDbEnhancedAsyncClient build() {
            if (this.dynamoDbClient == null) {
                throw new IllegalArgumentException("You must provide a DynamoDbClient to build a DefaultDynamoDbEnhancedClient.");
            }
            return new DefaultDynamoDbEnhancedAsyncClient(this.dynamoDbClient, this.mapperExtension);
        }

        @Override
        public Builder dynamoDbClient(DynamoDbAsyncClient dynamoDbAsyncClient) {
            this.dynamoDbClient = dynamoDbAsyncClient;
            return this;
        }

        @Override
        public Builder extendWith(MapperExtension mapperExtension) {
            if (mapperExtension != null && this.mapperExtension != null) {
                throw new IllegalArgumentException("You may only extend a DefaultDynamoDbEnhancedClient with a single extension. To combine multiple extensions, use the ChainMapperExtension.");
            }
            this.mapperExtension = mapperExtension;
            return this;
        }
    }
}

