/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DynamoDbAsyncTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Key;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Page;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.DefaultDynamoDbAsyncIndex;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.CreateTableEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.GetItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.PutItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.QueryEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.ScanEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.UpdateItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.CreateTableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.DeleteItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.GetItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.PutItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.QueryOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.ScanOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.UpdateItemOperation;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;

@SdkInternalApi
public final class DefaultDynamoDbAsyncTable<T>
implements DynamoDbAsyncTable<T> {
    private final DynamoDbAsyncClient dynamoDbClient;
    private final MapperExtension mapperExtension;
    private final TableSchema<T> tableSchema;
    private final String tableName;

    DefaultDynamoDbAsyncTable(DynamoDbAsyncClient dynamoDbClient, MapperExtension mapperExtension, TableSchema<T> tableSchema, String tableName) {
        this.dynamoDbClient = dynamoDbClient;
        this.mapperExtension = mapperExtension;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
    }

    @Override
    public MapperExtension mapperExtension() {
        return this.mapperExtension;
    }

    @Override
    public TableSchema<T> tableSchema() {
        return this.tableSchema;
    }

    public DynamoDbAsyncClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public DefaultDynamoDbAsyncIndex<T> index(String indexName) {
        this.tableSchema.tableMetadata().indexPartitionKey(indexName);
        return new DefaultDynamoDbAsyncIndex<T>(this.dynamoDbClient, this.mapperExtension, this.tableSchema, this.tableName, indexName);
    }

    @Override
    public CompletableFuture<Void> createTable(CreateTableEnhancedRequest request) {
        CreateTableOperation operation = CreateTableOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public CompletableFuture<T> deleteItem(DeleteItemEnhancedRequest request) {
        DeleteItemOperation operation = DeleteItemOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public CompletableFuture<T> getItem(GetItemEnhancedRequest request) {
        GetItemOperation operation = GetItemOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public SdkPublisher<Page<T>> query(QueryEnhancedRequest request) {
        QueryOperation operation = QueryOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public CompletableFuture<Void> putItem(PutItemEnhancedRequest<T> request) {
        PutItemOperation<T> operation = PutItemOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public SdkPublisher<Page<T>> scan(ScanEnhancedRequest request) {
        ScanOperation operation = ScanOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public CompletableFuture<T> updateItem(UpdateItemEnhancedRequest<T> request) {
        UpdateItemOperation<T> operation = UpdateItemOperation.create(request);
        return operation.executeOnPrimaryIndexAsync(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public Key keyFrom(T item) {
        return Utils.createKeyFromItem(item, this.tableSchema, TableMetadata.primaryIndexName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamoDbAsyncTable that = (DefaultDynamoDbAsyncTable)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        if (this.mapperExtension != null ? !this.mapperExtension.equals(that.mapperExtension) : that.mapperExtension != null) {
            return false;
        }
        if (this.tableSchema != null ? !this.tableSchema.equals(that.tableSchema) : that.tableSchema != null) {
            return false;
        }
        return this.tableName != null ? this.tableName.equals(that.tableName) : that.tableName == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.mapperExtension != null ? this.mapperExtension.hashCode() : 0);
        result = 31 * result + (this.tableSchema != null ? this.tableSchema.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        return result;
    }
}

