/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.Arrays;
import java.util.Collection;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.GlobalSecondaryIndex;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;

@SdkPublicApi
public class CreateTableEnhancedRequest {
    private final ProvisionedThroughput provisionedThroughput;
    private final Collection<LocalSecondaryIndex> localSecondaryIndices;
    private final Collection<GlobalSecondaryIndex> globalSecondaryIndices;

    private CreateTableEnhancedRequest(Builder builder) {
        this.provisionedThroughput = builder.provisionedThroughput;
        this.localSecondaryIndices = builder.localSecondaryIndices;
        this.globalSecondaryIndices = builder.globalSecondaryIndices;
    }

    public static CreateTableEnhancedRequest create(ProvisionedThroughput provisionedThroughput) {
        return CreateTableEnhancedRequest.builder().provisionedThroughput(provisionedThroughput).build();
    }

    public static CreateTableEnhancedRequest create() {
        return CreateTableEnhancedRequest.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return CreateTableEnhancedRequest.builder().provisionedThroughput(this.provisionedThroughput).localSecondaryIndices(this.localSecondaryIndices).globalSecondaryIndices(this.globalSecondaryIndices);
    }

    public ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Collection<LocalSecondaryIndex> localSecondaryIndices() {
        return this.localSecondaryIndices;
    }

    public Collection<GlobalSecondaryIndex> globalSecondaryIndices() {
        return this.globalSecondaryIndices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTableEnhancedRequest that = (CreateTableEnhancedRequest)o;
        if (this.provisionedThroughput != null ? !this.provisionedThroughput.equals((Object)that.provisionedThroughput) : that.provisionedThroughput != null) {
            return false;
        }
        if (this.localSecondaryIndices != null ? !this.localSecondaryIndices.equals(that.localSecondaryIndices) : that.localSecondaryIndices != null) {
            return false;
        }
        return this.globalSecondaryIndices != null ? this.globalSecondaryIndices.equals(that.globalSecondaryIndices) : that.globalSecondaryIndices == null;
    }

    public int hashCode() {
        int result = this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0;
        result = 31 * result + (this.localSecondaryIndices != null ? this.localSecondaryIndices.hashCode() : 0);
        result = 31 * result + (this.globalSecondaryIndices != null ? this.globalSecondaryIndices.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private ProvisionedThroughput provisionedThroughput;
        private Collection<LocalSecondaryIndex> localSecondaryIndices;
        private Collection<GlobalSecondaryIndex> globalSecondaryIndices;

        private Builder() {
        }

        public Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public Builder localSecondaryIndices(Collection<LocalSecondaryIndex> localSecondaryIndices) {
            this.localSecondaryIndices = localSecondaryIndices;
            return this;
        }

        public Builder localSecondaryIndices(LocalSecondaryIndex ... localSecondaryIndices) {
            this.localSecondaryIndices = Arrays.asList(localSecondaryIndices);
            return this;
        }

        public Builder globalSecondaryIndices(Collection<GlobalSecondaryIndex> globalSecondaryIndices) {
            this.globalSecondaryIndices = globalSecondaryIndices;
            return this;
        }

        public Builder globalSecondaryIndices(GlobalSecondaryIndex ... globalSecondaryIndices) {
            this.globalSecondaryIndices = Arrays.asList(globalSecondaryIndices);
            return this;
        }

        public CreateTableEnhancedRequest build() {
            return new CreateTableEnhancedRequest(this);
        }
    }
}

