/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public class UnmappedItem {
    private final Map<String, AttributeValue> itemMap;

    private UnmappedItem(Map<String, AttributeValue> itemMap) {
        this.itemMap = itemMap;
    }

    public static UnmappedItem of(Map<String, AttributeValue> itemMap) {
        return new UnmappedItem(itemMap);
    }

    public <T> T getItem(MappedTableResource<T> mappedTableResource) {
        return Utils.readAndTransformSingleItem(this.itemMap, mappedTableResource.tableSchema(), OperationContext.of(mappedTableResource.tableName()), mappedTableResource.mapperExtension());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnmappedItem that = (UnmappedItem)o;
        return this.itemMap != null ? this.itemMap.equals(that.itemMap) : that.itemMap == null;
    }

    public int hashCode() {
        return this.itemMap != null ? this.itemMap.hashCode() : 0;
    }
}

