/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.IndexOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Key;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedIndex;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.PaginatedIndexOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkPublicApi
@ThreadSafe
public class DynamoDbMappedIndex<T>
implements MappedIndex<T> {
    private final DynamoDbClient dynamoDbClient;
    private final MapperExtension mapperExtension;
    private final TableSchema<T> tableSchema;
    private final String tableName;
    private final String indexName;

    DynamoDbMappedIndex(DynamoDbClient dynamoDbClient, MapperExtension mapperExtension, TableSchema<T> tableSchema, String tableName, String indexName) {
        this.dynamoDbClient = dynamoDbClient;
        this.mapperExtension = mapperExtension;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
        this.indexName = indexName;
    }

    @Override
    public <R> R execute(IndexOperation<T, ?, ?, R> operationToPerform) {
        return operationToPerform.executeOnSecondaryIndex(this.tableSchema, this.tableName, this.indexName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public <R> SdkIterable<R> execute(PaginatedIndexOperation<T, ?, ?, R> operationToPerform) {
        return operationToPerform.executeOnSecondaryIndex(this.tableSchema, this.tableName, this.indexName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public MapperExtension mapperExtension() {
        return this.mapperExtension;
    }

    @Override
    public TableSchema<T> tableSchema() {
        return this.tableSchema;
    }

    public DynamoDbClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public String indexName() {
        return this.indexName;
    }

    @Override
    public Key keyFrom(T item) {
        return Utils.createKeyFromItem(item, this.tableSchema, this.indexName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamoDbMappedIndex that = (DynamoDbMappedIndex)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        if (this.mapperExtension != null ? !this.mapperExtension.equals(that.mapperExtension) : that.mapperExtension != null) {
            return false;
        }
        if (this.tableSchema != null ? !this.tableSchema.equals(that.tableSchema) : that.tableSchema != null) {
            return false;
        }
        if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
            return false;
        }
        return this.indexName != null ? this.indexName.equals(that.indexName) : that.indexName == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.mapperExtension != null ? this.mapperExtension.hashCode() : 0);
        result = 31 * result + (this.tableSchema != null ? this.tableSchema.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
        return result;
    }
}

