/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.BatchableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
public class WriteBatch<T> {
    private final MappedTable<T> mappedTable;
    private final Collection<BatchableWriteOperation<T>> writeOperations;

    private WriteBatch(MappedTable<T> mappedTable, Collection<BatchableWriteOperation<T>> writeOperations) {
        this.mappedTable = mappedTable;
        this.writeOperations = writeOperations;
    }

    public static <T> WriteBatch<T> of(MappedTable<T> mappedTable, Collection<BatchableWriteOperation<T>> writeOperations) {
        return new WriteBatch<T>(mappedTable, writeOperations);
    }

    @SafeVarargs
    public static <T> WriteBatch<T> of(MappedTable<T> mappedTable, BatchableWriteOperation<T> ... writeOperations) {
        return new WriteBatch<T>(mappedTable, Arrays.asList(writeOperations));
    }

    public MappedTable<T> mappedTable() {
        return this.mappedTable;
    }

    public Collection<BatchableWriteOperation<T>> writeOperations() {
        return this.writeOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteBatch that = (WriteBatch)o;
        if (this.mappedTable != null ? !this.mappedTable.equals(that.mappedTable) : that.mappedTable != null) {
            return false;
        }
        return this.writeOperations != null ? this.writeOperations.equals(that.writeOperations) : that.writeOperations == null;
    }

    public int hashCode() {
        int result = this.mappedTable != null ? this.mappedTable.hashCode() : 0;
        result = 31 * result + (this.writeOperations != null ? this.writeOperations.hashCode() : 0);
        return result;
    }

    void addWriteRequestsToMap(Map<String, Collection<WriteRequest>> writeRequestMap) {
        Collection writeRequestsForTable = writeRequestMap.computeIfAbsent(this.getTableName(), ignored -> new ArrayList());
        writeRequestsForTable.addAll(this.writeOperations.stream().map(writeOperation -> writeOperation.generateWriteRequest(this.mappedTable.tableSchema(), OperationContext.of(this.mappedTable.tableName()), this.mappedTable.mapperExtension())).collect(Collectors.toList()));
    }

    String getTableName() {
        return this.mappedTable.tableName();
    }
}

