/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.dsql.DsqlAsyncClient;
import software.amazon.awssdk.services.dsql.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.dsql.model.DsqlRequest;
import software.amazon.awssdk.services.dsql.model.GetClusterRequest;
import software.amazon.awssdk.services.dsql.model.GetClusterResponse;
import software.amazon.awssdk.services.dsql.waiters.DsqlAsyncWaiter;
import software.amazon.awssdk.services.dsql.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultDsqlAsyncWaiter
implements DsqlAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final DsqlAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetClusterResponse> clusterActiveWaiter;
    private final AsyncWaiter<GetClusterResponse> clusterNotExistsWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultDsqlAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (DsqlAsyncClient)DsqlAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.clusterActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetClusterResponse.class).acceptors(DefaultDsqlAsyncWaiter.clusterActiveWaiterAcceptors())).overrideConfiguration(DefaultDsqlAsyncWaiter.clusterActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.clusterNotExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetClusterResponse.class).acceptors(DefaultDsqlAsyncWaiter.clusterNotExistsWaiterAcceptors())).overrideConfiguration(DefaultDsqlAsyncWaiter.clusterNotExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterActive(GetClusterRequest getClusterRequest) {
        return this.clusterActiveWaiter.runAsync(() -> this.client.getCluster(this.applyWaitersUserAgent(getClusterRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterActive(GetClusterRequest getClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterActiveWaiter.runAsync(() -> this.client.getCluster(this.applyWaitersUserAgent(getClusterRequest)), DefaultDsqlAsyncWaiter.clusterActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterNotExists(GetClusterRequest getClusterRequest) {
        return this.clusterNotExistsWaiter.runAsync(() -> this.client.getCluster(this.applyWaitersUserAgent(getClusterRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetClusterResponse>> waitUntilClusterNotExists(GetClusterRequest getClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterNotExistsWaiter.runAsync(() -> this.client.getCluster(this.applyWaitersUserAgent(getClusterRequest)), DefaultDsqlAsyncWaiter.clusterNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetClusterResponse>> clusterActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetClusterResponse>> result = new ArrayList<WaiterAcceptor<? super GetClusterResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetClusterResponse>> clusterNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetClusterResponse>> result = new ArrayList<WaiterAcceptor<? super GetClusterResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultDsqlAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration clusterActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static DsqlAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends DsqlRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DsqlRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements DsqlAsyncWaiter.Builder {
        private DsqlAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public DsqlAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public DsqlAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public DsqlAsyncWaiter.Builder client(DsqlAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public DsqlAsyncWaiter build() {
            return new DefaultDsqlAsyncWaiter(this);
        }
    }
}

