/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.drs.model.DataReplicationInfo;
import software.amazon.awssdk.services.drs.model.DrsResponse;
import software.amazon.awssdk.services.drs.model.LastLaunchResult;
import software.amazon.awssdk.services.drs.model.LifeCycle;
import software.amazon.awssdk.services.drs.model.ReplicationDirection;
import software.amazon.awssdk.services.drs.model.SourceCloudProperties;
import software.amazon.awssdk.services.drs.model.SourceProperties;
import software.amazon.awssdk.services.drs.model.StagingArea;
import software.amazon.awssdk.services.drs.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisconnectSourceServerResponse
extends DrsResponse
implements ToCopyableBuilder<Builder, DisconnectSourceServerResponse> {
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentVersion").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::agentVersion)).setter(DisconnectSourceServerResponse.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::arn)).setter(DisconnectSourceServerResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<DataReplicationInfo> DATA_REPLICATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataReplicationInfo").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::dataReplicationInfo)).setter(DisconnectSourceServerResponse.setter(Builder::dataReplicationInfo)).constructor(DataReplicationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInfo").build()}).build();
    private static final SdkField<String> LAST_LAUNCH_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastLaunchResult").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::lastLaunchResultAsString)).setter(DisconnectSourceServerResponse.setter(Builder::lastLaunchResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastLaunchResult").build()}).build();
    private static final SdkField<LifeCycle> LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifeCycle").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::lifeCycle)).setter(DisconnectSourceServerResponse.setter(Builder::lifeCycle)).constructor(LifeCycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifeCycle").build()}).build();
    private static final SdkField<String> RECOVERY_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recoveryInstanceId").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::recoveryInstanceId)).setter(DisconnectSourceServerResponse.setter(Builder::recoveryInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceId").build()}).build();
    private static final SdkField<String> REPLICATION_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationDirection").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::replicationDirectionAsString)).setter(DisconnectSourceServerResponse.setter(Builder::replicationDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationDirection").build()}).build();
    private static final SdkField<String> REVERSED_DIRECTION_SOURCE_SERVER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reversedDirectionSourceServerArn").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::reversedDirectionSourceServerArn)).setter(DisconnectSourceServerResponse.setter(Builder::reversedDirectionSourceServerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reversedDirectionSourceServerArn").build()}).build();
    private static final SdkField<SourceCloudProperties> SOURCE_CLOUD_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceCloudProperties").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::sourceCloudProperties)).setter(DisconnectSourceServerResponse.setter(Builder::sourceCloudProperties)).constructor(SourceCloudProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCloudProperties").build()}).build();
    private static final SdkField<String> SOURCE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceNetworkID").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::sourceNetworkID)).setter(DisconnectSourceServerResponse.setter(Builder::sourceNetworkID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkID").build()}).build();
    private static final SdkField<SourceProperties> SOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceProperties").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::sourceProperties)).setter(DisconnectSourceServerResponse.setter(Builder::sourceProperties)).constructor(SourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::sourceServerID)).setter(DisconnectSourceServerResponse.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<StagingArea> STAGING_AREA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stagingArea").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::stagingArea)).setter(DisconnectSourceServerResponse.setter(Builder::stagingArea)).constructor(StagingArea::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingArea").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DisconnectSourceServerResponse.getter(DisconnectSourceServerResponse::tags)).setter(DisconnectSourceServerResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSION_FIELD, ARN_FIELD, DATA_REPLICATION_INFO_FIELD, LAST_LAUNCH_RESULT_FIELD, LIFE_CYCLE_FIELD, RECOVERY_INSTANCE_ID_FIELD, REPLICATION_DIRECTION_FIELD, REVERSED_DIRECTION_SOURCE_SERVER_ARN_FIELD, SOURCE_CLOUD_PROPERTIES_FIELD, SOURCE_NETWORK_ID_FIELD, SOURCE_PROPERTIES_FIELD, SOURCE_SERVER_ID_FIELD, STAGING_AREA_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("agentVersion", AGENT_VERSION_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("dataReplicationInfo", DATA_REPLICATION_INFO_FIELD);
            this.put("lastLaunchResult", LAST_LAUNCH_RESULT_FIELD);
            this.put("lifeCycle", LIFE_CYCLE_FIELD);
            this.put("recoveryInstanceId", RECOVERY_INSTANCE_ID_FIELD);
            this.put("replicationDirection", REPLICATION_DIRECTION_FIELD);
            this.put("reversedDirectionSourceServerArn", REVERSED_DIRECTION_SOURCE_SERVER_ARN_FIELD);
            this.put("sourceCloudProperties", SOURCE_CLOUD_PROPERTIES_FIELD);
            this.put("sourceNetworkID", SOURCE_NETWORK_ID_FIELD);
            this.put("sourceProperties", SOURCE_PROPERTIES_FIELD);
            this.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
            this.put("stagingArea", STAGING_AREA_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String agentVersion;
    private final String arn;
    private final DataReplicationInfo dataReplicationInfo;
    private final String lastLaunchResult;
    private final LifeCycle lifeCycle;
    private final String recoveryInstanceId;
    private final String replicationDirection;
    private final String reversedDirectionSourceServerArn;
    private final SourceCloudProperties sourceCloudProperties;
    private final String sourceNetworkID;
    private final SourceProperties sourceProperties;
    private final String sourceServerID;
    private final StagingArea stagingArea;
    private final Map<String, String> tags;

    private DisconnectSourceServerResponse(BuilderImpl builder) {
        super(builder);
        this.agentVersion = builder.agentVersion;
        this.arn = builder.arn;
        this.dataReplicationInfo = builder.dataReplicationInfo;
        this.lastLaunchResult = builder.lastLaunchResult;
        this.lifeCycle = builder.lifeCycle;
        this.recoveryInstanceId = builder.recoveryInstanceId;
        this.replicationDirection = builder.replicationDirection;
        this.reversedDirectionSourceServerArn = builder.reversedDirectionSourceServerArn;
        this.sourceCloudProperties = builder.sourceCloudProperties;
        this.sourceNetworkID = builder.sourceNetworkID;
        this.sourceProperties = builder.sourceProperties;
        this.sourceServerID = builder.sourceServerID;
        this.stagingArea = builder.stagingArea;
        this.tags = builder.tags;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public final String arn() {
        return this.arn;
    }

    public final DataReplicationInfo dataReplicationInfo() {
        return this.dataReplicationInfo;
    }

    public final LastLaunchResult lastLaunchResult() {
        return LastLaunchResult.fromValue(this.lastLaunchResult);
    }

    public final String lastLaunchResultAsString() {
        return this.lastLaunchResult;
    }

    public final LifeCycle lifeCycle() {
        return this.lifeCycle;
    }

    public final String recoveryInstanceId() {
        return this.recoveryInstanceId;
    }

    public final ReplicationDirection replicationDirection() {
        return ReplicationDirection.fromValue(this.replicationDirection);
    }

    public final String replicationDirectionAsString() {
        return this.replicationDirection;
    }

    public final String reversedDirectionSourceServerArn() {
        return this.reversedDirectionSourceServerArn;
    }

    public final SourceCloudProperties sourceCloudProperties() {
        return this.sourceCloudProperties;
    }

    public final String sourceNetworkID() {
        return this.sourceNetworkID;
    }

    public final SourceProperties sourceProperties() {
        return this.sourceProperties;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final StagingArea stagingArea() {
        return this.stagingArea;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastLaunchResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reversedDirectionSourceServerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCloudProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceNetworkID());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.stagingArea());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisconnectSourceServerResponse)) {
            return false;
        }
        DisconnectSourceServerResponse other = (DisconnectSourceServerResponse)((Object)obj);
        return Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataReplicationInfo(), other.dataReplicationInfo()) && Objects.equals(this.lastLaunchResultAsString(), other.lastLaunchResultAsString()) && Objects.equals(this.lifeCycle(), other.lifeCycle()) && Objects.equals(this.recoveryInstanceId(), other.recoveryInstanceId()) && Objects.equals(this.replicationDirectionAsString(), other.replicationDirectionAsString()) && Objects.equals(this.reversedDirectionSourceServerArn(), other.reversedDirectionSourceServerArn()) && Objects.equals(this.sourceCloudProperties(), other.sourceCloudProperties()) && Objects.equals(this.sourceNetworkID(), other.sourceNetworkID()) && Objects.equals(this.sourceProperties(), other.sourceProperties()) && Objects.equals(this.sourceServerID(), other.sourceServerID()) && Objects.equals(this.stagingArea(), other.stagingArea()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DisconnectSourceServerResponse").add("AgentVersion", (Object)this.agentVersion()).add("Arn", (Object)this.arn()).add("DataReplicationInfo", (Object)this.dataReplicationInfo()).add("LastLaunchResult", (Object)this.lastLaunchResultAsString()).add("LifeCycle", (Object)this.lifeCycle()).add("RecoveryInstanceId", (Object)this.recoveryInstanceId()).add("ReplicationDirection", (Object)this.replicationDirectionAsString()).add("ReversedDirectionSourceServerArn", (Object)this.reversedDirectionSourceServerArn()).add("SourceCloudProperties", (Object)this.sourceCloudProperties()).add("SourceNetworkID", (Object)this.sourceNetworkID()).add("SourceProperties", (Object)this.sourceProperties()).add("SourceServerID", (Object)this.sourceServerID()).add("StagingArea", (Object)this.stagingArea()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "dataReplicationInfo": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationInfo()));
            }
            case "lastLaunchResult": {
                return Optional.ofNullable(clazz.cast(this.lastLaunchResultAsString()));
            }
            case "lifeCycle": {
                return Optional.ofNullable(clazz.cast(this.lifeCycle()));
            }
            case "recoveryInstanceId": {
                return Optional.ofNullable(clazz.cast(this.recoveryInstanceId()));
            }
            case "replicationDirection": {
                return Optional.ofNullable(clazz.cast(this.replicationDirectionAsString()));
            }
            case "reversedDirectionSourceServerArn": {
                return Optional.ofNullable(clazz.cast(this.reversedDirectionSourceServerArn()));
            }
            case "sourceCloudProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceCloudProperties()));
            }
            case "sourceNetworkID": {
                return Optional.ofNullable(clazz.cast(this.sourceNetworkID()));
            }
            case "sourceProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceProperties()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "stagingArea": {
                return Optional.ofNullable(clazz.cast(this.stagingArea()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisconnectSourceServerResponse, T> g) {
        return obj -> g.apply((DisconnectSourceServerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DrsResponse.BuilderImpl
    implements Builder {
        private String agentVersion;
        private String arn;
        private DataReplicationInfo dataReplicationInfo;
        private String lastLaunchResult;
        private LifeCycle lifeCycle;
        private String recoveryInstanceId;
        private String replicationDirection;
        private String reversedDirectionSourceServerArn;
        private SourceCloudProperties sourceCloudProperties;
        private String sourceNetworkID;
        private SourceProperties sourceProperties;
        private String sourceServerID;
        private StagingArea stagingArea;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisconnectSourceServerResponse model) {
            super(model);
            this.agentVersion(model.agentVersion);
            this.arn(model.arn);
            this.dataReplicationInfo(model.dataReplicationInfo);
            this.lastLaunchResult(model.lastLaunchResult);
            this.lifeCycle(model.lifeCycle);
            this.recoveryInstanceId(model.recoveryInstanceId);
            this.replicationDirection(model.replicationDirection);
            this.reversedDirectionSourceServerArn(model.reversedDirectionSourceServerArn);
            this.sourceCloudProperties(model.sourceCloudProperties);
            this.sourceNetworkID(model.sourceNetworkID);
            this.sourceProperties(model.sourceProperties);
            this.sourceServerID(model.sourceServerID);
            this.stagingArea(model.stagingArea);
            this.tags(model.tags);
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DataReplicationInfo.Builder getDataReplicationInfo() {
            return this.dataReplicationInfo != null ? this.dataReplicationInfo.toBuilder() : null;
        }

        public final void setDataReplicationInfo(DataReplicationInfo.BuilderImpl dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo != null ? dataReplicationInfo.build() : null;
        }

        @Override
        public final Builder dataReplicationInfo(DataReplicationInfo dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo;
            return this;
        }

        public final String getLastLaunchResult() {
            return this.lastLaunchResult;
        }

        public final void setLastLaunchResult(String lastLaunchResult) {
            this.lastLaunchResult = lastLaunchResult;
        }

        @Override
        public final Builder lastLaunchResult(String lastLaunchResult) {
            this.lastLaunchResult = lastLaunchResult;
            return this;
        }

        @Override
        public final Builder lastLaunchResult(LastLaunchResult lastLaunchResult) {
            this.lastLaunchResult(lastLaunchResult == null ? null : lastLaunchResult.toString());
            return this;
        }

        public final LifeCycle.Builder getLifeCycle() {
            return this.lifeCycle != null ? this.lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getRecoveryInstanceId() {
            return this.recoveryInstanceId;
        }

        public final void setRecoveryInstanceId(String recoveryInstanceId) {
            this.recoveryInstanceId = recoveryInstanceId;
        }

        @Override
        public final Builder recoveryInstanceId(String recoveryInstanceId) {
            this.recoveryInstanceId = recoveryInstanceId;
            return this;
        }

        public final String getReplicationDirection() {
            return this.replicationDirection;
        }

        public final void setReplicationDirection(String replicationDirection) {
            this.replicationDirection = replicationDirection;
        }

        @Override
        public final Builder replicationDirection(String replicationDirection) {
            this.replicationDirection = replicationDirection;
            return this;
        }

        @Override
        public final Builder replicationDirection(ReplicationDirection replicationDirection) {
            this.replicationDirection(replicationDirection == null ? null : replicationDirection.toString());
            return this;
        }

        public final String getReversedDirectionSourceServerArn() {
            return this.reversedDirectionSourceServerArn;
        }

        public final void setReversedDirectionSourceServerArn(String reversedDirectionSourceServerArn) {
            this.reversedDirectionSourceServerArn = reversedDirectionSourceServerArn;
        }

        @Override
        public final Builder reversedDirectionSourceServerArn(String reversedDirectionSourceServerArn) {
            this.reversedDirectionSourceServerArn = reversedDirectionSourceServerArn;
            return this;
        }

        public final SourceCloudProperties.Builder getSourceCloudProperties() {
            return this.sourceCloudProperties != null ? this.sourceCloudProperties.toBuilder() : null;
        }

        public final void setSourceCloudProperties(SourceCloudProperties.BuilderImpl sourceCloudProperties) {
            this.sourceCloudProperties = sourceCloudProperties != null ? sourceCloudProperties.build() : null;
        }

        @Override
        public final Builder sourceCloudProperties(SourceCloudProperties sourceCloudProperties) {
            this.sourceCloudProperties = sourceCloudProperties;
            return this;
        }

        public final String getSourceNetworkID() {
            return this.sourceNetworkID;
        }

        public final void setSourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
        }

        @Override
        public final Builder sourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
            return this;
        }

        public final SourceProperties.Builder getSourceProperties() {
            return this.sourceProperties != null ? this.sourceProperties.toBuilder() : null;
        }

        public final void setSourceProperties(SourceProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        @Override
        public final Builder sourceProperties(SourceProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final StagingArea.Builder getStagingArea() {
            return this.stagingArea != null ? this.stagingArea.toBuilder() : null;
        }

        public final void setStagingArea(StagingArea.BuilderImpl stagingArea) {
            this.stagingArea = stagingArea != null ? stagingArea.build() : null;
        }

        @Override
        public final Builder stagingArea(StagingArea stagingArea) {
            this.stagingArea = stagingArea;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public DisconnectSourceServerResponse build() {
            return new DisconnectSourceServerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DrsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisconnectSourceServerResponse> {
        public Builder agentVersion(String var1);

        public Builder arn(String var1);

        public Builder dataReplicationInfo(DataReplicationInfo var1);

        default public Builder dataReplicationInfo(Consumer<DataReplicationInfo.Builder> dataReplicationInfo) {
            return this.dataReplicationInfo((DataReplicationInfo)((DataReplicationInfo.Builder)DataReplicationInfo.builder().applyMutation(dataReplicationInfo)).build());
        }

        public Builder lastLaunchResult(String var1);

        public Builder lastLaunchResult(LastLaunchResult var1);

        public Builder lifeCycle(LifeCycle var1);

        default public Builder lifeCycle(Consumer<LifeCycle.Builder> lifeCycle) {
            return this.lifeCycle((LifeCycle)((LifeCycle.Builder)LifeCycle.builder().applyMutation(lifeCycle)).build());
        }

        public Builder recoveryInstanceId(String var1);

        public Builder replicationDirection(String var1);

        public Builder replicationDirection(ReplicationDirection var1);

        public Builder reversedDirectionSourceServerArn(String var1);

        public Builder sourceCloudProperties(SourceCloudProperties var1);

        default public Builder sourceCloudProperties(Consumer<SourceCloudProperties.Builder> sourceCloudProperties) {
            return this.sourceCloudProperties((SourceCloudProperties)((SourceCloudProperties.Builder)SourceCloudProperties.builder().applyMutation(sourceCloudProperties)).build());
        }

        public Builder sourceNetworkID(String var1);

        public Builder sourceProperties(SourceProperties var1);

        default public Builder sourceProperties(Consumer<SourceProperties.Builder> sourceProperties) {
            return this.sourceProperties((SourceProperties)((SourceProperties.Builder)SourceProperties.builder().applyMutation(sourceProperties)).build());
        }

        public Builder sourceServerID(String var1);

        public Builder stagingArea(StagingArea var1);

        default public Builder stagingArea(Consumer<StagingArea.Builder> stagingArea) {
            return this.stagingArea((StagingArea)((StagingArea.Builder)StagingArea.builder().applyMutation(stagingArea)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

