/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsClient;
import software.amazon.awssdk.services.drs.internal.UserAgentUtils;
import software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsRequest;
import software.amazon.awssdk.services.drs.model.DescribeRecoverySnapshotsResponse;
import software.amazon.awssdk.services.drs.model.RecoverySnapshot;

public class DescribeRecoverySnapshotsIterable
implements SdkIterable<DescribeRecoverySnapshotsResponse> {
    private final DrsClient client;
    private final DescribeRecoverySnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRecoverySnapshotsIterable(DrsClient client, DescribeRecoverySnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRecoverySnapshotsResponseFetcher();
    }

    public Iterator<DescribeRecoverySnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecoverySnapshot> items() {
        Function<DescribeRecoverySnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRecoverySnapshotsResponseFetcher
    implements SyncPageFetcher<DescribeRecoverySnapshotsResponse> {
        private DescribeRecoverySnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRecoverySnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRecoverySnapshotsResponse nextPage(DescribeRecoverySnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRecoverySnapshotsIterable.this.client.describeRecoverySnapshots(DescribeRecoverySnapshotsIterable.this.firstRequest);
            }
            return DescribeRecoverySnapshotsIterable.this.client.describeRecoverySnapshots((DescribeRecoverySnapshotsRequest)((Object)DescribeRecoverySnapshotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

