/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceCloudProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceCloudProperties> {
    private static final SdkField<String> ORIGIN_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originAccountID").getter(SourceCloudProperties.getter(SourceCloudProperties::originAccountID)).setter(SourceCloudProperties.setter(Builder::originAccountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originAccountID").build()}).build();
    private static final SdkField<String> ORIGIN_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originAvailabilityZone").getter(SourceCloudProperties.getter(SourceCloudProperties::originAvailabilityZone)).setter(SourceCloudProperties.setter(Builder::originAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originAvailabilityZone").build()}).build();
    private static final SdkField<String> ORIGIN_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originRegion").getter(SourceCloudProperties.getter(SourceCloudProperties::originRegion)).setter(SourceCloudProperties.setter(Builder::originRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originRegion").build()}).build();
    private static final SdkField<String> SOURCE_OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceOutpostArn").getter(SourceCloudProperties.getter(SourceCloudProperties::sourceOutpostArn)).setter(SourceCloudProperties.setter(Builder::sourceOutpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceOutpostArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCOUNT_ID_FIELD, ORIGIN_AVAILABILITY_ZONE_FIELD, ORIGIN_REGION_FIELD, SOURCE_OUTPOST_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String originAccountID;
    private final String originAvailabilityZone;
    private final String originRegion;
    private final String sourceOutpostArn;

    private SourceCloudProperties(BuilderImpl builder) {
        this.originAccountID = builder.originAccountID;
        this.originAvailabilityZone = builder.originAvailabilityZone;
        this.originRegion = builder.originRegion;
        this.sourceOutpostArn = builder.sourceOutpostArn;
    }

    public final String originAccountID() {
        return this.originAccountID;
    }

    public final String originAvailabilityZone() {
        return this.originAvailabilityZone;
    }

    public final String originRegion() {
        return this.originRegion;
    }

    public final String sourceOutpostArn() {
        return this.sourceOutpostArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.originAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.originRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceOutpostArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCloudProperties)) {
            return false;
        }
        SourceCloudProperties other = (SourceCloudProperties)obj;
        return Objects.equals(this.originAccountID(), other.originAccountID()) && Objects.equals(this.originAvailabilityZone(), other.originAvailabilityZone()) && Objects.equals(this.originRegion(), other.originRegion()) && Objects.equals(this.sourceOutpostArn(), other.sourceOutpostArn());
    }

    public final String toString() {
        return ToString.builder((String)"SourceCloudProperties").add("OriginAccountID", (Object)this.originAccountID()).add("OriginAvailabilityZone", (Object)this.originAvailabilityZone()).add("OriginRegion", (Object)this.originRegion()).add("SourceOutpostArn", (Object)this.sourceOutpostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "originAccountID": {
                return Optional.ofNullable(clazz.cast(this.originAccountID()));
            }
            case "originAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.originAvailabilityZone()));
            }
            case "originRegion": {
                return Optional.ofNullable(clazz.cast(this.originRegion()));
            }
            case "sourceOutpostArn": {
                return Optional.ofNullable(clazz.cast(this.sourceOutpostArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceCloudProperties, T> g) {
        return obj -> g.apply((SourceCloudProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String originAccountID;
        private String originAvailabilityZone;
        private String originRegion;
        private String sourceOutpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCloudProperties model) {
            this.originAccountID(model.originAccountID);
            this.originAvailabilityZone(model.originAvailabilityZone);
            this.originRegion(model.originRegion);
            this.sourceOutpostArn(model.sourceOutpostArn);
        }

        public final String getOriginAccountID() {
            return this.originAccountID;
        }

        public final void setOriginAccountID(String originAccountID) {
            this.originAccountID = originAccountID;
        }

        @Override
        public final Builder originAccountID(String originAccountID) {
            this.originAccountID = originAccountID;
            return this;
        }

        public final String getOriginAvailabilityZone() {
            return this.originAvailabilityZone;
        }

        public final void setOriginAvailabilityZone(String originAvailabilityZone) {
            this.originAvailabilityZone = originAvailabilityZone;
        }

        @Override
        public final Builder originAvailabilityZone(String originAvailabilityZone) {
            this.originAvailabilityZone = originAvailabilityZone;
            return this;
        }

        public final String getOriginRegion() {
            return this.originRegion;
        }

        public final void setOriginRegion(String originRegion) {
            this.originRegion = originRegion;
        }

        @Override
        public final Builder originRegion(String originRegion) {
            this.originRegion = originRegion;
            return this;
        }

        public final String getSourceOutpostArn() {
            return this.sourceOutpostArn;
        }

        public final void setSourceOutpostArn(String sourceOutpostArn) {
            this.sourceOutpostArn = sourceOutpostArn;
        }

        @Override
        public final Builder sourceOutpostArn(String sourceOutpostArn) {
            this.sourceOutpostArn = sourceOutpostArn;
            return this;
        }

        public SourceCloudProperties build() {
            return new SourceCloudProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceCloudProperties> {
        public Builder originAccountID(String var1);

        public Builder originAvailabilityZone(String var1);

        public Builder originRegion(String var1);

        public Builder sourceOutpostArn(String var1);
    }
}

