/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailbackState {
    FAILBACK_NOT_STARTED("FAILBACK_NOT_STARTED"),
    FAILBACK_IN_PROGRESS("FAILBACK_IN_PROGRESS"),
    FAILBACK_READY_FOR_LAUNCH("FAILBACK_READY_FOR_LAUNCH"),
    FAILBACK_COMPLETED("FAILBACK_COMPLETED"),
    FAILBACK_ERROR("FAILBACK_ERROR"),
    FAILBACK_NOT_READY_FOR_LAUNCH("FAILBACK_NOT_READY_FOR_LAUNCH"),
    FAILBACK_LAUNCH_STATE_NOT_AVAILABLE("FAILBACK_LAUNCH_STATE_NOT_AVAILABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailbackState> VALUE_MAP;
    private final String value;

    private FailbackState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailbackState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailbackState> knownValues() {
        EnumSet<FailbackState> knownValues = EnumSet.allOf(FailbackState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailbackState.class, FailbackState::toString);
    }
}

