/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.ConversionProperties;
import software.amazon.awssdk.services.drs.model.EventResourceData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobLogEventData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobLogEventData> {
    private static final SdkField<ConversionProperties> CONVERSION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conversionProperties").getter(JobLogEventData.getter(JobLogEventData::conversionProperties)).setter(JobLogEventData.setter(Builder::conversionProperties)).constructor(ConversionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversionProperties").build()}).build();
    private static final SdkField<String> CONVERSION_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("conversionServerID").getter(JobLogEventData.getter(JobLogEventData::conversionServerID)).setter(JobLogEventData.setter(Builder::conversionServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversionServerID").build()}).build();
    private static final SdkField<EventResourceData> EVENT_RESOURCE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventResourceData").getter(JobLogEventData.getter(JobLogEventData::eventResourceData)).setter(JobLogEventData.setter(Builder::eventResourceData)).constructor(EventResourceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventResourceData").build()}).build();
    private static final SdkField<String> RAW_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rawError").getter(JobLogEventData.getter(JobLogEventData::rawError)).setter(JobLogEventData.setter(Builder::rawError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawError").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(JobLogEventData.getter(JobLogEventData::sourceServerID)).setter(JobLogEventData.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<String> TARGET_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetInstanceID").getter(JobLogEventData.getter(JobLogEventData::targetInstanceID)).setter(JobLogEventData.setter(Builder::targetInstanceID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstanceID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSION_PROPERTIES_FIELD, CONVERSION_SERVER_ID_FIELD, EVENT_RESOURCE_DATA_FIELD, RAW_ERROR_FIELD, SOURCE_SERVER_ID_FIELD, TARGET_INSTANCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final ConversionProperties conversionProperties;
    private final String conversionServerID;
    private final EventResourceData eventResourceData;
    private final String rawError;
    private final String sourceServerID;
    private final String targetInstanceID;

    private JobLogEventData(BuilderImpl builder) {
        this.conversionProperties = builder.conversionProperties;
        this.conversionServerID = builder.conversionServerID;
        this.eventResourceData = builder.eventResourceData;
        this.rawError = builder.rawError;
        this.sourceServerID = builder.sourceServerID;
        this.targetInstanceID = builder.targetInstanceID;
    }

    public final ConversionProperties conversionProperties() {
        return this.conversionProperties;
    }

    public final String conversionServerID() {
        return this.conversionServerID;
    }

    public final EventResourceData eventResourceData() {
        return this.eventResourceData;
    }

    public final String rawError() {
        return this.rawError;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final String targetInstanceID() {
        return this.targetInstanceID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversionServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawError());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstanceID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobLogEventData)) {
            return false;
        }
        JobLogEventData other = (JobLogEventData)obj;
        return Objects.equals(this.conversionProperties(), other.conversionProperties()) && Objects.equals(this.conversionServerID(), other.conversionServerID()) && Objects.equals(this.eventResourceData(), other.eventResourceData()) && Objects.equals(this.rawError(), other.rawError()) && Objects.equals(this.sourceServerID(), other.sourceServerID()) && Objects.equals(this.targetInstanceID(), other.targetInstanceID());
    }

    public final String toString() {
        return ToString.builder((String)"JobLogEventData").add("ConversionProperties", (Object)this.conversionProperties()).add("ConversionServerID", (Object)this.conversionServerID()).add("EventResourceData", (Object)this.eventResourceData()).add("RawError", (Object)this.rawError()).add("SourceServerID", (Object)this.sourceServerID()).add("TargetInstanceID", (Object)this.targetInstanceID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversionProperties": {
                return Optional.ofNullable(clazz.cast(this.conversionProperties()));
            }
            case "conversionServerID": {
                return Optional.ofNullable(clazz.cast(this.conversionServerID()));
            }
            case "eventResourceData": {
                return Optional.ofNullable(clazz.cast(this.eventResourceData()));
            }
            case "rawError": {
                return Optional.ofNullable(clazz.cast(this.rawError()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "targetInstanceID": {
                return Optional.ofNullable(clazz.cast(this.targetInstanceID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobLogEventData, T> g) {
        return obj -> g.apply((JobLogEventData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConversionProperties conversionProperties;
        private String conversionServerID;
        private EventResourceData eventResourceData;
        private String rawError;
        private String sourceServerID;
        private String targetInstanceID;

        private BuilderImpl() {
        }

        private BuilderImpl(JobLogEventData model) {
            this.conversionProperties(model.conversionProperties);
            this.conversionServerID(model.conversionServerID);
            this.eventResourceData(model.eventResourceData);
            this.rawError(model.rawError);
            this.sourceServerID(model.sourceServerID);
            this.targetInstanceID(model.targetInstanceID);
        }

        public final ConversionProperties.Builder getConversionProperties() {
            return this.conversionProperties != null ? this.conversionProperties.toBuilder() : null;
        }

        public final void setConversionProperties(ConversionProperties.BuilderImpl conversionProperties) {
            this.conversionProperties = conversionProperties != null ? conversionProperties.build() : null;
        }

        @Override
        public final Builder conversionProperties(ConversionProperties conversionProperties) {
            this.conversionProperties = conversionProperties;
            return this;
        }

        public final String getConversionServerID() {
            return this.conversionServerID;
        }

        public final void setConversionServerID(String conversionServerID) {
            this.conversionServerID = conversionServerID;
        }

        @Override
        public final Builder conversionServerID(String conversionServerID) {
            this.conversionServerID = conversionServerID;
            return this;
        }

        public final EventResourceData.Builder getEventResourceData() {
            return this.eventResourceData != null ? this.eventResourceData.toBuilder() : null;
        }

        public final void setEventResourceData(EventResourceData.BuilderImpl eventResourceData) {
            this.eventResourceData = eventResourceData != null ? eventResourceData.build() : null;
        }

        @Override
        public final Builder eventResourceData(EventResourceData eventResourceData) {
            this.eventResourceData = eventResourceData;
            return this;
        }

        public final String getRawError() {
            return this.rawError;
        }

        public final void setRawError(String rawError) {
            this.rawError = rawError;
        }

        @Override
        public final Builder rawError(String rawError) {
            this.rawError = rawError;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getTargetInstanceID() {
            return this.targetInstanceID;
        }

        public final void setTargetInstanceID(String targetInstanceID) {
            this.targetInstanceID = targetInstanceID;
        }

        @Override
        public final Builder targetInstanceID(String targetInstanceID) {
            this.targetInstanceID = targetInstanceID;
            return this;
        }

        public JobLogEventData build() {
            return new JobLogEventData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobLogEventData> {
        public Builder conversionProperties(ConversionProperties var1);

        default public Builder conversionProperties(Consumer<ConversionProperties.Builder> conversionProperties) {
            return this.conversionProperties((ConversionProperties)((ConversionProperties.Builder)ConversionProperties.builder().applyMutation(conversionProperties)).build());
        }

        public Builder conversionServerID(String var1);

        public Builder eventResourceData(EventResourceData var1);

        default public Builder eventResourceData(Consumer<EventResourceData.Builder> eventResourceData) {
            return this.eventResourceData((EventResourceData)((EventResourceData.Builder)EventResourceData.builder().applyMutation(eventResourceData)).build());
        }

        public Builder rawError(String var1);

        public Builder sourceServerID(String var1);

        public Builder targetInstanceID(String var1);
    }
}

