/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsClient;
import software.amazon.awssdk.services.drs.model.DescribeJobsRequest;
import software.amazon.awssdk.services.drs.model.DescribeJobsResponse;
import software.amazon.awssdk.services.drs.model.Job;

public class DescribeJobsIterable
implements SdkIterable<DescribeJobsResponse> {
    private final DrsClient client;
    private final DescribeJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeJobsIterable(DrsClient client, DescribeJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeJobsResponseFetcher();
    }

    public Iterator<DescribeJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Job> items() {
        Function<DescribeJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeJobsResponseFetcher
    implements SyncPageFetcher<DescribeJobsResponse> {
        private DescribeJobsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeJobsResponse nextPage(DescribeJobsResponse previousPage) {
            if (previousPage == null) {
                return DescribeJobsIterable.this.client.describeJobs(DescribeJobsIterable.this.firstRequest);
            }
            return DescribeJobsIterable.this.client.describeJobs((DescribeJobsRequest)((Object)DescribeJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

