/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.CPU;
import software.amazon.awssdk.services.drs.model.CpusCopier;
import software.amazon.awssdk.services.drs.model.IdentificationHints;
import software.amazon.awssdk.services.drs.model.NetworkInterface;
import software.amazon.awssdk.services.drs.model.NetworkInterfacesCopier;
import software.amazon.awssdk.services.drs.model.OS;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceDisk;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceDisksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecoveryInstanceProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecoveryInstanceProperties> {
    private static final SdkField<List<CPU>> CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cpus").getter(RecoveryInstanceProperties.getter(RecoveryInstanceProperties::cpus)).setter(RecoveryInstanceProperties.setter(Builder::cpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CPU::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RecoveryInstanceDisk>> DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("disks").getter(RecoveryInstanceProperties.getter(RecoveryInstanceProperties::disks)).setter(RecoveryInstanceProperties.setter(Builder::disks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecoveryInstanceDisk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IdentificationHints> IDENTIFICATION_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("identificationHints").getter(RecoveryInstanceProperties.getter(RecoveryInstanceProperties::identificationHints)).setter(RecoveryInstanceProperties.setter(Builder::identificationHints)).constructor(IdentificationHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identificationHints").build()}).build();
    private static final SdkField<String> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedDateTime").getter(RecoveryInstanceProperties.getter(RecoveryInstanceProperties::lastUpdatedDateTime)).setter(RecoveryInstanceProperties.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkInterfaces").getter(RecoveryInstanceProperties.getter(RecoveryInstanceProperties::networkInterfaces)).setter(RecoveryInstanceProperties.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OS> OS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("os").getter(RecoveryInstanceProperties.getter(RecoveryInstanceProperties::os)).setter(RecoveryInstanceProperties.setter(Builder::os)).constructor(OS::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("os").build()}).build();
    private static final SdkField<Long> RAM_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ramBytes").getter(RecoveryInstanceProperties.getter(RecoveryInstanceProperties::ramBytes)).setter(RecoveryInstanceProperties.setter(Builder::ramBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPUS_FIELD, DISKS_FIELD, IDENTIFICATION_HINTS_FIELD, LAST_UPDATED_DATE_TIME_FIELD, NETWORK_INTERFACES_FIELD, OS_FIELD, RAM_BYTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CPU> cpus;
    private final List<RecoveryInstanceDisk> disks;
    private final IdentificationHints identificationHints;
    private final String lastUpdatedDateTime;
    private final List<NetworkInterface> networkInterfaces;
    private final OS os;
    private final Long ramBytes;

    private RecoveryInstanceProperties(BuilderImpl builder) {
        this.cpus = builder.cpus;
        this.disks = builder.disks;
        this.identificationHints = builder.identificationHints;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.networkInterfaces = builder.networkInterfaces;
        this.os = builder.os;
        this.ramBytes = builder.ramBytes;
    }

    public final boolean hasCpus() {
        return this.cpus != null && !(this.cpus instanceof SdkAutoConstructList);
    }

    public final List<CPU> cpus() {
        return this.cpus;
    }

    public final boolean hasDisks() {
        return this.disks != null && !(this.disks instanceof SdkAutoConstructList);
    }

    public final List<RecoveryInstanceDisk> disks() {
        return this.disks;
    }

    public final IdentificationHints identificationHints() {
        return this.identificationHints;
    }

    public final String lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final OS os() {
        return this.os;
    }

    public final Long ramBytes() {
        return this.ramBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCpus() ? this.cpus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisks() ? this.disks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identificationHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.os());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryInstanceProperties)) {
            return false;
        }
        RecoveryInstanceProperties other = (RecoveryInstanceProperties)obj;
        return this.hasCpus() == other.hasCpus() && Objects.equals(this.cpus(), other.cpus()) && this.hasDisks() == other.hasDisks() && Objects.equals(this.disks(), other.disks()) && Objects.equals(this.identificationHints(), other.identificationHints()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.os(), other.os()) && Objects.equals(this.ramBytes(), other.ramBytes());
    }

    public final String toString() {
        return ToString.builder((String)"RecoveryInstanceProperties").add("Cpus", this.hasCpus() ? this.cpus() : null).add("Disks", this.hasDisks() ? this.disks() : null).add("IdentificationHints", (Object)this.identificationHints()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("Os", (Object)this.os()).add("RamBytes", (Object)this.ramBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cpus": {
                return Optional.ofNullable(clazz.cast(this.cpus()));
            }
            case "disks": {
                return Optional.ofNullable(clazz.cast(this.disks()));
            }
            case "identificationHints": {
                return Optional.ofNullable(clazz.cast(this.identificationHints()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "networkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "os": {
                return Optional.ofNullable(clazz.cast(this.os()));
            }
            case "ramBytes": {
                return Optional.ofNullable(clazz.cast(this.ramBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryInstanceProperties, T> g) {
        return obj -> g.apply((RecoveryInstanceProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CPU> cpus = DefaultSdkAutoConstructList.getInstance();
        private List<RecoveryInstanceDisk> disks = DefaultSdkAutoConstructList.getInstance();
        private IdentificationHints identificationHints;
        private String lastUpdatedDateTime;
        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private OS os;
        private Long ramBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryInstanceProperties model) {
            this.cpus(model.cpus);
            this.disks(model.disks);
            this.identificationHints(model.identificationHints);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.networkInterfaces(model.networkInterfaces);
            this.os(model.os);
            this.ramBytes(model.ramBytes);
        }

        public final List<CPU.Builder> getCpus() {
            List<CPU.Builder> result = CpusCopier.copyToBuilder(this.cpus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCpus(Collection<CPU.BuilderImpl> cpus) {
            this.cpus = CpusCopier.copyFromBuilder(cpus);
        }

        @Override
        @Transient
        public final Builder cpus(Collection<CPU> cpus) {
            this.cpus = CpusCopier.copy(cpus);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cpus(CPU ... cpus) {
            this.cpus(Arrays.asList(cpus));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cpus(Consumer<CPU.Builder> ... cpus) {
            this.cpus(Stream.of(cpus).map(c -> (CPU)((CPU.Builder)CPU.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RecoveryInstanceDisk.Builder> getDisks() {
            List<RecoveryInstanceDisk.Builder> result = RecoveryInstanceDisksCopier.copyToBuilder(this.disks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDisks(Collection<RecoveryInstanceDisk.BuilderImpl> disks) {
            this.disks = RecoveryInstanceDisksCopier.copyFromBuilder(disks);
        }

        @Override
        @Transient
        public final Builder disks(Collection<RecoveryInstanceDisk> disks) {
            this.disks = RecoveryInstanceDisksCopier.copy(disks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder disks(RecoveryInstanceDisk ... disks) {
            this.disks(Arrays.asList(disks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder disks(Consumer<RecoveryInstanceDisk.Builder> ... disks) {
            this.disks(Stream.of(disks).map(c -> (RecoveryInstanceDisk)((RecoveryInstanceDisk.Builder)RecoveryInstanceDisk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IdentificationHints.Builder getIdentificationHints() {
            return this.identificationHints != null ? this.identificationHints.toBuilder() : null;
        }

        public final void setIdentificationHints(IdentificationHints.BuilderImpl identificationHints) {
            this.identificationHints = identificationHints != null ? identificationHints.build() : null;
        }

        @Override
        @Transient
        public final Builder identificationHints(IdentificationHints identificationHints) {
            this.identificationHints = identificationHints;
            return this;
        }

        public final String getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(String lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(String lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfaces() {
            List<NetworkInterface.Builder> result = NetworkInterfacesCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        @Transient
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfacesCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OS.Builder getOs() {
            return this.os != null ? this.os.toBuilder() : null;
        }

        public final void setOs(OS.BuilderImpl os) {
            this.os = os != null ? os.build() : null;
        }

        @Override
        @Transient
        public final Builder os(OS os) {
            this.os = os;
            return this;
        }

        public final Long getRamBytes() {
            return this.ramBytes;
        }

        public final void setRamBytes(Long ramBytes) {
            this.ramBytes = ramBytes;
        }

        @Override
        @Transient
        public final Builder ramBytes(Long ramBytes) {
            this.ramBytes = ramBytes;
            return this;
        }

        public RecoveryInstanceProperties build() {
            return new RecoveryInstanceProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecoveryInstanceProperties> {
        public Builder cpus(Collection<CPU> var1);

        public Builder cpus(CPU ... var1);

        public Builder cpus(Consumer<CPU.Builder> ... var1);

        public Builder disks(Collection<RecoveryInstanceDisk> var1);

        public Builder disks(RecoveryInstanceDisk ... var1);

        public Builder disks(Consumer<RecoveryInstanceDisk.Builder> ... var1);

        public Builder identificationHints(IdentificationHints var1);

        default public Builder identificationHints(Consumer<IdentificationHints.Builder> identificationHints) {
            return this.identificationHints((IdentificationHints)((IdentificationHints.Builder)IdentificationHints.builder().applyMutation(identificationHints)).build());
        }

        public Builder lastUpdatedDateTime(String var1);

        public Builder networkInterfaces(Collection<NetworkInterface> var1);

        public Builder networkInterfaces(NetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... var1);

        public Builder os(OS var1);

        default public Builder os(Consumer<OS.Builder> os) {
            return this.os((OS)((OS.Builder)OS.builder().applyMutation(os)).build());
        }

        public Builder ramBytes(Long var1);
    }
}

