/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailbackReplicationError {
    AGENT_NOT_SEEN("AGENT_NOT_SEEN"),
    FAILBACK_CLIENT_NOT_SEEN("FAILBACK_CLIENT_NOT_SEEN"),
    NOT_CONVERGING("NOT_CONVERGING"),
    UNSTABLE_NETWORK("UNSTABLE_NETWORK"),
    FAILED_TO_ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION("FAILED_TO_ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION"),
    FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT("FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT"),
    FAILED_TO_CONFIGURE_REPLICATION_SOFTWARE("FAILED_TO_CONFIGURE_REPLICATION_SOFTWARE"),
    FAILED_TO_PAIR_AGENT_WITH_REPLICATION_SOFTWARE("FAILED_TO_PAIR_AGENT_WITH_REPLICATION_SOFTWARE"),
    FAILED_TO_ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION("FAILED_TO_ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailbackReplicationError> VALUE_MAP;
    private final String value;

    private FailbackReplicationError(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailbackReplicationError fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailbackReplicationError> knownValues() {
        EnumSet<FailbackReplicationError> knownValues = EnumSet.allOf(FailbackReplicationError.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailbackReplicationError.class, FailbackReplicationError::toString);
    }
}

