/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.docdbelastic.DefaultDocDbElasticBaseClientBuilder;
import software.amazon.awssdk.services.docdbelastic.DefaultDocDbElasticClient;
import software.amazon.awssdk.services.docdbelastic.DocDbElasticClient;
import software.amazon.awssdk.services.docdbelastic.DocDbElasticClientBuilder;
import software.amazon.awssdk.services.docdbelastic.DocDbElasticServiceClientConfiguration;
import software.amazon.awssdk.services.docdbelastic.endpoints.DocDbElasticEndpointProvider;

@SdkInternalApi
final class DefaultDocDbElasticClientBuilder
extends DefaultDocDbElasticBaseClientBuilder<DocDbElasticClientBuilder, DocDbElasticClient>
implements DocDbElasticClientBuilder {
    DefaultDocDbElasticClientBuilder() {
    }

    @Override
    public DefaultDocDbElasticClientBuilder endpointProvider(DocDbElasticEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DocDbElasticClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDocDbElasticClientBuilder.validateClientOptions(clientConfiguration);
        DocDbElasticServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDocDbElasticClient client = new DefaultDocDbElasticClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DocDbElasticServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DocDbElasticServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

