/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbAsyncClient;
import software.amazon.awssdk.services.docdb.internal.UserAgentUtils;
import software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersResponse;
import software.amazon.awssdk.services.docdb.model.GlobalCluster;

public class DescribeGlobalClustersPublisher
implements SdkPublisher<DescribeGlobalClustersResponse> {
    private final DocDbAsyncClient client;
    private final DescribeGlobalClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeGlobalClustersPublisher(DocDbAsyncClient client, DescribeGlobalClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeGlobalClustersPublisher(DocDbAsyncClient client, DescribeGlobalClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeGlobalClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeGlobalClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GlobalCluster> globalClusters() {
        Function<DescribeGlobalClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.globalClusters() != null) {
                return response.globalClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeGlobalClustersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeGlobalClustersResponseFetcher
    implements AsyncPageFetcher<DescribeGlobalClustersResponse> {
        private DescribeGlobalClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGlobalClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeGlobalClustersResponse> nextPage(DescribeGlobalClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeGlobalClustersPublisher.this.client.describeGlobalClusters(DescribeGlobalClustersPublisher.this.firstRequest);
            }
            return DescribeGlobalClustersPublisher.this.client.describeGlobalClusters((DescribeGlobalClustersRequest)((Object)DescribeGlobalClustersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

