/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.DBEngineVersion;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse;

public class DescribeDBEngineVersionsIterable
implements SdkIterable<DescribeDbEngineVersionsResponse> {
    private final DocDbClient client;
    private final DescribeDbEngineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBEngineVersionsIterable(DocDbClient client, DescribeDbEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbEngineVersionsResponseFetcher();
    }

    public Iterator<DescribeDbEngineVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBEngineVersion> dbEngineVersions() {
        Function<DescribeDbEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbEngineVersions() != null) {
                return response.dbEngineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeDBEngineVersionsIterable resume(DescribeDbEngineVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBEngineVersionsIterable(this.client, (DescribeDbEngineVersionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBEngineVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDbEngineVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDbEngineVersionsResponseFetcher
    implements SyncPageFetcher<DescribeDbEngineVersionsResponse> {
        private DescribeDbEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbEngineVersionsResponse nextPage(DescribeDbEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBEngineVersionsIterable.this.client.describeDBEngineVersions(DescribeDBEngineVersionsIterable.this.firstRequest);
            }
            return DescribeDBEngineVersionsIterable.this.client.describeDBEngineVersions((DescribeDbEngineVersionsRequest)((Object)DescribeDBEngineVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

