/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.docdb.DefaultDocDbBaseClientBuilder;
import software.amazon.awssdk.services.docdb.DefaultDocDbClient;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.DocDbClientBuilder;
import software.amazon.awssdk.services.docdb.DocDbServiceClientConfiguration;
import software.amazon.awssdk.services.docdb.endpoints.DocDbEndpointProvider;

@SdkInternalApi
final class DefaultDocDbClientBuilder
extends DefaultDocDbBaseClientBuilder<DocDbClientBuilder, DocDbClient>
implements DocDbClientBuilder {
    DefaultDocDbClientBuilder() {
    }

    @Override
    public DefaultDocDbClientBuilder endpointProvider(DocDbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DocDbClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDocDbClientBuilder.validateClientOptions(clientConfiguration);
        DocDbServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDocDbClient client = new DefaultDocDbClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DocDbServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DocDbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

