/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.docdb.DefaultDocDbAsyncClient;
import software.amazon.awssdk.services.docdb.DefaultDocDbBaseClientBuilder;
import software.amazon.awssdk.services.docdb.DocDbAsyncClient;
import software.amazon.awssdk.services.docdb.DocDbAsyncClientBuilder;
import software.amazon.awssdk.services.docdb.DocDbServiceClientConfiguration;
import software.amazon.awssdk.services.docdb.endpoints.DocDbEndpointProvider;

@SdkInternalApi
final class DefaultDocDbAsyncClientBuilder
extends DefaultDocDbBaseClientBuilder<DocDbAsyncClientBuilder, DocDbAsyncClient>
implements DocDbAsyncClientBuilder {
    DefaultDocDbAsyncClientBuilder() {
    }

    @Override
    public DefaultDocDbAsyncClientBuilder endpointProvider(DocDbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DocDbAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDocDbAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DocDbServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDocDbAsyncClient client = new DefaultDocDbAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DocDbServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DocDbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

