/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.docdb.DefaultDocDbAsyncClient;
import software.amazon.awssdk.services.docdb.DefaultDocDbBaseClientBuilder;
import software.amazon.awssdk.services.docdb.DocDbAsyncClient;
import software.amazon.awssdk.services.docdb.DocDbAsyncClientBuilder;
import software.amazon.awssdk.services.docdb.DocDbServiceClientConfiguration;
import software.amazon.awssdk.services.docdb.endpoints.DocDbEndpointProvider;

@SdkInternalApi
final class DefaultDocDbAsyncClientBuilder
extends DefaultDocDbBaseClientBuilder<DocDbAsyncClientBuilder, DocDbAsyncClient>
implements DocDbAsyncClientBuilder {
    DefaultDocDbAsyncClientBuilder() {
    }

    @Override
    public DefaultDocDbAsyncClientBuilder endpointProvider(DocDbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DocDbAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDocDbAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        DocDbServiceClientConfiguration serviceClientConfiguration = DocDbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultDocDbAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

