/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.docdb.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.docdb.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.docdb.model.CertificateNotFoundException;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEventsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEventsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.docdb.model.DocDbException;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.docdb.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.docdb.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.docdb.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.docdb.model.InvalidRestoreException;
import software.amazon.awssdk.services.docdb.model.InvalidSubnetException;
import software.amazon.awssdk.services.docdb.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.docdb.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.docdb.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.StartDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.StartDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.StopDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.StopDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.docdb.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.docdb.paginators.DescribeCertificatesIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBClusterParameterGroupsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBClusterParametersIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBClusterSnapshotsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribePendingMaintenanceActionsIterable;
import software.amazon.awssdk.services.docdb.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CopyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CopyDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeCertificatesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClustersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEngineDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeOrderableDbInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.FailoverDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RebootDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ResetDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RestoreDbClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RestoreDbClusterToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.StartDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.StopDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.waiters.DocDbWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDocDbClient
implements DocDbClient {
    private static final Logger log = Logger.loggerFor(DefaultDocDbClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDocDbClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "rds";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsToResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, addTagsToResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTagsToResource");
            AddTagsToResourceResponse addTagsToResourceResponse = (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller(this.protocolFactory)));
            return addTagsToResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$addTagsToResource$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplyPendingMaintenanceActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplyPendingMaintenanceAction");
            ApplyPendingMaintenanceActionResponse applyPendingMaintenanceActionResponse = (ApplyPendingMaintenanceActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyPendingMaintenanceAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)applyPendingMaintenanceActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ApplyPendingMaintenanceActionRequestMarshaller(this.protocolFactory)));
            return applyPendingMaintenanceActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$applyPendingMaintenanceAction$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyDbClusterParameterGroupResponse copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException, DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, copyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDBClusterParameterGroup");
            CopyDbClusterParameterGroupResponse copyDbClusterParameterGroupResponse = (CopyDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyDbClusterParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
            return copyDbClusterParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$copyDBClusterParameterGroup$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyDbClusterSnapshotResponse copyDBClusterSnapshot(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) throws DbClusterSnapshotAlreadyExistsException, DbClusterSnapshotNotFoundException, InvalidDbClusterStateException, InvalidDbClusterSnapshotStateException, SnapshotQuotaExceededException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, copyDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopyDBClusterSnapshot");
            CopyDbClusterSnapshotResponse copyDbClusterSnapshotResponse = (CopyDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyDbClusterSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CopyDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
            return copyDbClusterSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$copyDBClusterSnapshot$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbClusterResponse createDBCluster(CreateDbClusterRequest createDbClusterRequest) throws DbClusterAlreadyExistsException, InsufficientStorageClusterCapacityException, DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbClusterStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException, InvalidDbInstanceStateException, DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException, DbClusterNotFoundException, DbInstanceNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBCluster");
            CreateDbClusterResponse createDbClusterResponse = (CreateDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbClusterRequestMarshaller(this.protocolFactory)));
            return createDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$createDBCluster$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbClusterParameterGroupResponse createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBClusterParameterGroup");
            CreateDbClusterParameterGroupResponse createDbClusterParameterGroupResponse = (CreateDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
            return createDbClusterParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$createDBClusterParameterGroup$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbClusterSnapshotResponse createDBClusterSnapshot(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) throws DbClusterSnapshotAlreadyExistsException, InvalidDbClusterStateException, DbClusterNotFoundException, SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, createDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBClusterSnapshot");
            CreateDbClusterSnapshotResponse createDbClusterSnapshotResponse = (CreateDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
            return createDbClusterSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$createDBClusterSnapshot$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbInstanceResponse createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException, DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException, InvalidSubnetException, InvalidVpcNetworkStateException, DbClusterNotFoundException, StorageTypeNotSupportedException, AuthorizationNotFoundException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, createDbInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBInstance");
            CreateDbInstanceResponse createDbInstanceResponse = (CreateDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbInstanceRequestMarshaller(this.protocolFactory)));
            return createDbInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$createDBInstance$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDbSubnetGroupResponse createDBSubnetGroup(CreateDbSubnetGroupRequest createDbSubnetGroupRequest) throws DbSubnetGroupAlreadyExistsException, DbSubnetGroupQuotaExceededException, DbSubnetQuotaExceededException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, createDbSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDBSubnetGroup");
            CreateDbSubnetGroupResponse createDbSubnetGroupResponse = (CreateDbSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDbSubnetGroupRequestMarshaller(this.protocolFactory)));
            return createDbSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$createDBSubnetGroup$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbClusterResponse deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, DbClusterSnapshotAlreadyExistsException, SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBCluster");
            DeleteDbClusterResponse deleteDbClusterResponse = (DeleteDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbClusterRequestMarshaller(this.protocolFactory)));
            return deleteDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$deleteDBCluster$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbClusterParameterGroupResponse deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBClusterParameterGroup");
            DeleteDbClusterParameterGroupResponse deleteDbClusterParameterGroupResponse = (DeleteDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
            return deleteDbClusterParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$deleteDBClusterParameterGroup$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbClusterSnapshotResponse deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) throws InvalidDbClusterSnapshotStateException, DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, deleteDbClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBClusterSnapshot");
            DeleteDbClusterSnapshotResponse deleteDbClusterSnapshotResponse = (DeleteDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
            return deleteDbClusterSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$deleteDBClusterSnapshot$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbInstanceResponse deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) throws DbInstanceNotFoundException, InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException, SnapshotQuotaExceededException, InvalidDbClusterStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, deleteDbInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBInstance");
            DeleteDbInstanceResponse deleteDbInstanceResponse = (DeleteDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbInstanceRequestMarshaller(this.protocolFactory)));
            return deleteDbInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$deleteDBInstance$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDbSubnetGroupResponse deleteDBSubnetGroup(DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) throws InvalidDbSubnetGroupStateException, InvalidDbSubnetStateException, DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, deleteDbSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDBSubnetGroup");
            DeleteDbSubnetGroupResponse deleteDbSubnetGroupResponse = (DeleteDbSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDbSubnetGroupRequestMarshaller(this.protocolFactory)));
            return deleteDbSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$deleteDBSubnetGroup$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCertificatesResponse describeCertificates(DescribeCertificatesRequest describeCertificatesRequest) throws CertificateNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCertificatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificates");
            DescribeCertificatesResponse describeCertificatesResponse = (DescribeCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCertificatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCertificatesRequestMarshaller(this.protocolFactory)));
            return describeCertificatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeCertificates$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeCertificatesIterable describeCertificatesPaginator(DescribeCertificatesRequest describeCertificatesRequest) throws CertificateNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribeCertificatesIterable(this, this.applyPaginatorUserAgent(describeCertificatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParameterGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterParameterGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterParameterGroups");
            DescribeDbClusterParameterGroupsResponse describeDbClusterParameterGroupsResponse = (DescribeDbClusterParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameterGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterParameterGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClusterParameterGroupsRequestMarshaller(this.protocolFactory)));
            return describeDbClusterParameterGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeDBClusterParameterGroups$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBClusterParameterGroupsIterable describeDBClusterParameterGroupsPaginator(DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBClusterParameterGroupsIterable(this, this.applyPaginatorUserAgent(describeDbClusterParameterGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClusterParametersResponse describeDBClusterParameters(DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterParameters");
            DescribeDbClusterParametersResponse describeDbClusterParametersResponse = (DescribeDbClusterParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClusterParametersRequestMarshaller(this.protocolFactory)));
            return describeDbClusterParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeDBClusterParameters$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBClusterParametersIterable describeDBClusterParametersPaginator(DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBClusterParametersIterable(this, this.applyPaginatorUserAgent(describeDbClusterParametersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClusterSnapshotAttributesResponse describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterSnapshotAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterSnapshotAttributes");
            DescribeDbClusterSnapshotAttributesResponse describeDbClusterSnapshotAttributesResponse = (DescribeDbClusterSnapshotAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshotAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterSnapshotAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClusterSnapshotAttributesRequestMarshaller(this.protocolFactory)));
            return describeDbClusterSnapshotAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeDBClusterSnapshotAttributes$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeDbClusterSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusterSnapshots");
            DescribeDbClusterSnapshotsResponse describeDbClusterSnapshotsResponse = (DescribeDbClusterSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClusterSnapshotsRequestMarshaller(this.protocolFactory)));
            return describeDbClusterSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeDBClusterSnapshots$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBClusterSnapshotsIterable describeDBClusterSnapshotsPaginator(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBClusterSnapshotsIterable(this, this.applyPaginatorUserAgent(describeDbClusterSnapshotsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbClustersResponse describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) throws DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClustersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeDbClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBClusters");
            DescribeDbClustersResponse describeDbClustersResponse = (DescribeDbClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbClustersRequestMarshaller(this.protocolFactory)));
            return describeDbClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeDBClusters$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBClustersIterable describeDBClustersPaginator(DescribeDbClustersRequest describeDbClustersRequest) throws DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBClustersIterable(this, this.applyPaginatorUserAgent(describeDbClustersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbEngineVersionsResponse describeDBEngineVersions(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbEngineVersionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeDbEngineVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBEngineVersions");
            DescribeDbEngineVersionsResponse describeDbEngineVersionsResponse = (DescribeDbEngineVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBEngineVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbEngineVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbEngineVersionsRequestMarshaller(this.protocolFactory)));
            return describeDbEngineVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeDBEngineVersions$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBEngineVersionsIterable describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBEngineVersionsIterable(this, this.applyPaginatorUserAgent(describeDbEngineVersionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbInstancesResponse describeDBInstances(DescribeDbInstancesRequest describeDbInstancesRequest) throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeDbInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBInstances");
            DescribeDbInstancesResponse describeDbInstancesResponse = (DescribeDbInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbInstancesRequestMarshaller(this.protocolFactory)));
            return describeDbInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeDBInstances$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBInstancesIterable describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest) throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBInstancesIterable(this, this.applyPaginatorUserAgent(describeDbInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDbSubnetGroupsResponse describeDBSubnetGroups(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbSubnetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeDbSubnetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDBSubnetGroups");
            DescribeDbSubnetGroupsResponse describeDbSubnetGroupsResponse = (DescribeDbSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBSubnetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbSubnetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDbSubnetGroupsRequestMarshaller(this.protocolFactory)));
            return describeDbSubnetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeDBSubnetGroups$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeDBSubnetGroupsIterable describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBSubnetGroupsIterable(this, this.applyPaginatorUserAgent(describeDbSubnetGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) throws AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultClusterParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeEngineDefaultClusterParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEngineDefaultClusterParameters");
            DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParametersResponse = (DescribeEngineDefaultClusterParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultClusterParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEngineDefaultClusterParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEngineDefaultClusterParametersRequestMarshaller(this.protocolFactory)));
            return describeEngineDefaultClusterParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeEngineDefaultClusterParameters$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) throws AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventCategoriesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeEventCategoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEventCategories");
            DescribeEventCategoriesResponse describeEventCategoriesResponse = (DescribeEventCategoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventCategoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller(this.protocolFactory)));
            return describeEventCategoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeEventCategories$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEvents");
            DescribeEventsResponse describeEventsResponse = (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)));
            return describeEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeEvents$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        return new DescribeEventsIterable(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOrderableDbInstanceOptionsResponse describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeOrderableDbInstanceOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describeOrderableDbInstanceOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOrderableDBInstanceOptions");
            DescribeOrderableDbInstanceOptionsResponse describeOrderableDbInstanceOptionsResponse = (DescribeOrderableDbInstanceOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableDBInstanceOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrderableDbInstanceOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOrderableDbInstanceOptionsRequestMarshaller(this.protocolFactory)));
            return describeOrderableDbInstanceOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describeOrderableDBInstanceOptions$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeOrderableDBInstanceOptionsIterable describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        return new DescribeOrderableDBInstanceOptionsIterable(this, this.applyPaginatorUserAgent(describeOrderableDbInstanceOptionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePendingMaintenanceActionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribePendingMaintenanceActions");
            DescribePendingMaintenanceActionsResponse describePendingMaintenanceActionsResponse = (DescribePendingMaintenanceActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingMaintenanceActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePendingMaintenanceActionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribePendingMaintenanceActionsRequestMarshaller(this.protocolFactory)));
            return describePendingMaintenanceActionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$describePendingMaintenanceActions$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribePendingMaintenanceActionsIterable(this, this.applyPaginatorUserAgent(describePendingMaintenanceActionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FailoverDbClusterResponse failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(FailoverDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, failoverDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FailoverDBCluster");
            FailoverDbClusterResponse failoverDbClusterResponse = (FailoverDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("FailoverDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)failoverDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new FailoverDbClusterRequestMarshaller(this.protocolFactory)));
            return failoverDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$failoverDBCluster$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$listTagsForResource$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbClusterResponse modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException, DbClusterParameterGroupNotFoundException, InvalidDbSecurityGroupStateException, InvalidDbInstanceStateException, DbClusterAlreadyExistsException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBCluster");
            ModifyDbClusterResponse modifyDbClusterResponse = (ModifyDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbClusterRequestMarshaller(this.protocolFactory)));
            return modifyDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$modifyDBCluster$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbClusterParameterGroupResponse modifyDBClusterParameterGroup(ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBClusterParameterGroup");
            ModifyDbClusterParameterGroupResponse modifyDbClusterParameterGroupResponse = (ModifyDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
            return modifyDbClusterParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$modifyDBClusterParameterGroup$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbClusterSnapshotAttributeResponse modifyDBClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) throws DbClusterSnapshotNotFoundException, InvalidDbClusterSnapshotStateException, SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterSnapshotAttributeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, modifyDbClusterSnapshotAttributeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBClusterSnapshotAttribute");
            ModifyDbClusterSnapshotAttributeResponse modifyDbClusterSnapshotAttributeResponse = (ModifyDbClusterSnapshotAttributeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterSnapshotAttribute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterSnapshotAttributeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbClusterSnapshotAttributeRequestMarshaller(this.protocolFactory)));
            return modifyDbClusterSnapshotAttributeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$modifyDBClusterSnapshotAttribute$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbInstanceResponse modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest) throws InvalidDbInstanceStateException, InvalidDbSecurityGroupStateException, DbInstanceAlreadyExistsException, DbInstanceNotFoundException, DbSecurityGroupNotFoundException, DbParameterGroupNotFoundException, InsufficientDbInstanceCapacityException, StorageQuotaExceededException, InvalidVpcNetworkStateException, DbUpgradeDependencyFailureException, StorageTypeNotSupportedException, AuthorizationNotFoundException, CertificateNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, modifyDbInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBInstance");
            ModifyDbInstanceResponse modifyDbInstanceResponse = (ModifyDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbInstanceRequestMarshaller(this.protocolFactory)));
            return modifyDbInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$modifyDBInstance$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyDbSubnetGroupResponse modifyDBSubnetGroup(ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest) throws DbSubnetGroupNotFoundException, DbSubnetQuotaExceededException, SubnetAlreadyInUseException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, modifyDbSubnetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyDBSubnetGroup");
            ModifyDbSubnetGroupResponse modifyDbSubnetGroupResponse = (ModifyDbSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbSubnetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyDbSubnetGroupRequestMarshaller(this.protocolFactory)));
            return modifyDbSubnetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$modifyDBSubnetGroup$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootDbInstanceResponse rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest) throws InvalidDbInstanceStateException, DbInstanceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, rebootDbInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootDBInstance");
            RebootDbInstanceResponse rebootDbInstanceResponse = (RebootDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootDbInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebootDbInstanceRequestMarshaller(this.protocolFactory)));
            return rebootDbInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$rebootDBInstance$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsFromResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, removeTagsFromResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTagsFromResource");
            RemoveTagsFromResourceResponse removeTagsFromResourceResponse = (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller(this.protocolFactory)));
            return removeTagsFromResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$removeTagsFromResource$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResetDbClusterParameterGroupResponse resetDBClusterParameterGroup(ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, resetDbClusterParameterGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetDBClusterParameterGroup");
            ResetDbClusterParameterGroupResponse resetDbClusterParameterGroupResponse = (ResetDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetDbClusterParameterGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResetDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
            return resetDbClusterParameterGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$resetDBClusterParameterGroup$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreDbClusterFromSnapshotResponse restoreDBClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) throws DbClusterAlreadyExistsException, DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, DbSnapshotNotFoundException, DbClusterSnapshotNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException, InvalidDbSnapshotStateException, InvalidDbClusterSnapshotStateException, InvalidVpcNetworkStateException, InvalidRestoreException, InvalidSubnetException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterFromSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, restoreDbClusterFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreDBClusterFromSnapshot");
            RestoreDbClusterFromSnapshotResponse restoreDbClusterFromSnapshotResponse = (RestoreDbClusterFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterFromSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreDbClusterFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreDbClusterFromSnapshotRequestMarshaller(this.protocolFactory)));
            return restoreDbClusterFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$restoreDBClusterFromSnapshot$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreDbClusterToPointInTimeResponse restoreDBClusterToPointInTime(RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) throws DbClusterAlreadyExistsException, DbClusterNotFoundException, DbClusterQuotaExceededException, DbClusterSnapshotNotFoundException, DbSubnetGroupNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException, InvalidDbClusterSnapshotStateException, InvalidDbClusterStateException, InvalidDbSnapshotStateException, InvalidRestoreException, InvalidSubnetException, InvalidVpcNetworkStateException, KmsKeyNotAccessibleException, StorageQuotaExceededException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterToPointInTimeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, restoreDbClusterToPointInTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreDBClusterToPointInTime");
            RestoreDbClusterToPointInTimeResponse restoreDbClusterToPointInTimeResponse = (RestoreDbClusterToPointInTimeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterToPointInTime").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreDbClusterToPointInTimeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreDbClusterToPointInTimeRequestMarshaller(this.protocolFactory)));
            return restoreDbClusterToPointInTimeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$restoreDBClusterToPointInTime$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDbClusterResponse startDBCluster(StartDbClusterRequest startDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StartDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, startDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDBCluster");
            StartDbClusterResponse startDbClusterResponse = (StartDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDbClusterRequestMarshaller(this.protocolFactory)));
            return startDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$startDBCluster$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopDbClusterResponse stopDBCluster(StopDbClusterRequest stopDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StopDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultDocDbClient.resolveMetricPublishers(this.clientConfiguration, stopDbClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDBCluster");
            StopDbClusterResponse stopDbClusterResponse = (StopDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopDbClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopDbClusterRequestMarshaller(this.protocolFactory)));
            return stopDbClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbClient.lambda$stopDBCluster$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupNotFound").exceptionBuilderSupplier(DbParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InstanceQuotaExceeded").exceptionBuilderSupplier(InstanceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterNotFoundFault").exceptionBuilderSupplier(DbClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceeded").exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterQuotaExceededFault").exceptionBuilderSupplier(DbClusterQuotaExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetStateFault").exceptionBuilderSupplier(InvalidDbSubnetStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestoreFault").exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBClusterCapacityFault").exceptionBuilderSupplier(InsufficientDbClusterCapacityException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceNotFound").exceptionBuilderSupplier(DbInstanceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SharedSnapshotQuotaExceeded").exceptionBuilderSupplier(SharedSnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupDoesNotCoverEnoughAZs").exceptionBuilderSupplier(DbSubnetGroupDoesNotCoverEnoughAZsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotAlreadyExists").exceptionBuilderSupplier(DbSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotAlreadyExistsFault").exceptionBuilderSupplier(DbClusterSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterStateFault").exceptionBuilderSupplier(InvalidDbClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupQuotaExceeded").exceptionBuilderSupplier(DbSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupStateFault").exceptionBuilderSupplier(InvalidDbSubnetGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterParameterGroupNotFound").exceptionBuilderSupplier(DbClusterParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetQuotaExceededFault").exceptionBuilderSupplier(DbSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupNotFoundFault").exceptionBuilderSupplier(DbSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBUpgradeDependencyFailure").exceptionBuilderSupplier(DbUpgradeDependencyFailureException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSecurityGroupState").exceptionBuilderSupplier(InvalidDbSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterSnapshotStateFault").exceptionBuilderSupplier(InvalidDbClusterSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSecurityGroupNotFound").exceptionBuilderSupplier(DbSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBInstanceCapacity").exceptionBuilderSupplier(InsufficientDbInstanceCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupAlreadyExists").exceptionBuilderSupplier(DbParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotNotFound").exceptionBuilderSupplier(DbSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupQuotaExceeded").exceptionBuilderSupplier(DbParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageTypeNotSupported").exceptionBuilderSupplier(StorageTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientStorageClusterCapacity").exceptionBuilderSupplier(InsufficientStorageClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceAlreadyExists").exceptionBuilderSupplier(DbInstanceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupAlreadyExists").exceptionBuilderSupplier(DbSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotNotFoundFault").exceptionBuilderSupplier(DbClusterSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterAlreadyExistsFault").exceptionBuilderSupplier(DbClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBInstanceState").exceptionBuilderSupplier(InvalidDbInstanceStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSnapshotState").exceptionBuilderSupplier(InvalidDbSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageQuotaExceeded").exceptionBuilderSupplier(StorageQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBParameterGroupState").exceptionBuilderSupplier(InvalidDbParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DocDbException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends DocDbRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.16.5").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DocDbRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public DocDbWaiter waiter() {
        return DocDbWaiter.builder().client(this).build();
    }

    private static /* synthetic */ void lambda$stopDBCluster$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDBCluster$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreDBClusterToPointInTime$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreDBClusterFromSnapshot$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetDBClusterParameterGroup$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTagsFromResource$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootDBInstance$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBSubnetGroup$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBInstance$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBClusterSnapshotAttribute$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBClusterParameterGroup$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyDBCluster$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$failoverDBCluster$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describePendingMaintenanceActions$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOrderableDBInstanceOptions$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEvents$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEventCategories$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEngineDefaultClusterParameters$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBSubnetGroups$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBInstances$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBEngineVersions$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusters$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusterSnapshots$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusterSnapshotAttributes$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusterParameters$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDBClusterParameterGroups$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCertificates$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBSubnetGroup$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBInstance$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBClusterSnapshot$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBClusterParameterGroup$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDBCluster$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBSubnetGroup$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBInstance$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBClusterSnapshot$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBClusterParameterGroup$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDBCluster$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyDBClusterSnapshot$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copyDBClusterParameterGroup$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$applyPendingMaintenanceAction$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTagsToResource$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

