/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.docdb.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.docdb.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.docdb.model.CertificateNotFoundException;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEventsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEventsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.docdb.model.DocDbException;
import software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.docdb.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.docdb.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.docdb.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.docdb.model.InvalidRestoreException;
import software.amazon.awssdk.services.docdb.model.InvalidSubnetException;
import software.amazon.awssdk.services.docdb.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.docdb.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.docdb.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.StartDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.StartDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.StopDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.StopDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.docdb.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsIterable;

/**
 * Service client for accessing Amazon DocDB. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon DocumentDB API documentation
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface DocDbClient extends SdkClient {
    String SERVICE_NAME = "rds";

    /**
     * Create a {@link DocDbClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DocDbClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DocDbClient}.
     */
    static DocDbClientBuilder builder() {
        return new DefaultDocDbClientBuilder();
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon DocumentDB resource. You can use these tags with cost allocation reporting to
     * track costs that are associated with Amazon DocumentDB resources. or in a <code>Condition</code> statement in an
     * AWS Identity and Access Management (IAM) policy for Amazon DocumentDB.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        Represents the input to <a>AddTagsToResource</a>.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.AddTagsToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon DocumentDB resource. You can use these tags with cost allocation reporting to
     * track costs that are associated with Amazon DocumentDB resources. or in a <code>Condition</code> statement in an
     * AWS Identity and Access Management (IAM) policy for Amazon DocumentDB.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToResourceMessage.Builder} to create a request.
     *        Represents the input to <a>AddTagsToResource</a>.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.AddTagsToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest)
            throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        Represents the input to <a>ApplyPendingMaintenanceAction</a>.
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ApplyPendingMaintenanceAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException,
            InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyPendingMaintenanceActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyPendingMaintenanceActionRequest#builder()}
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        A {@link Consumer} that will call methods on {@link ApplyPendingMaintenanceActionMessage.Builder} to
     *        create a request. Represents the input to <a>ApplyPendingMaintenanceAction</a>.
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ApplyPendingMaintenanceAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            Consumer<ApplyPendingMaintenanceActionRequest.Builder> applyPendingMaintenanceActionRequest)
            throws ResourceNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, DocDbException {
        return applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.builder()
                .applyMutation(applyPendingMaintenanceActionRequest).build());
    }

    /**
     * <p>
     * Copies the specified cluster parameter group.
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     *        Represents the input to <a>CopyDBClusterParameterGroup</a>.
     * @return Result of the CopyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws DbParameterGroupQuotaExceededException
     *         This request would cause you to exceed the allowed number of parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A parameter group with the same name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CopyDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CopyDbClusterParameterGroupResponse copyDBClusterParameterGroup(
            CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException,
            DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CopyDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CopyDBClusterParameterGroupMessage.Builder} to create
     *        a request. Represents the input to <a>CopyDBClusterParameterGroup</a>.
     * @return Result of the CopyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws DbParameterGroupQuotaExceededException
     *         This request would cause you to exceed the allowed number of parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A parameter group with the same name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CopyDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CopyDbClusterParameterGroupResponse copyDBClusterParameterGroup(
            Consumer<CopyDbClusterParameterGroupRequest.Builder> copyDbClusterParameterGroupRequest)
            throws DbParameterGroupNotFoundException, DbParameterGroupQuotaExceededException,
            DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, DocDbException {
        return copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest.builder()
                .applyMutation(copyDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Copies a snapshot of a cluster.
     * </p>
     * <p>
     * To copy a cluster snapshot from a shared manual cluster snapshot, <code>SourceDBClusterSnapshotIdentifier</code>
     * must be the Amazon Resource Name (ARN) of the shared cluster snapshot.
     * </p>
     * <p>
     * To cancel the copy operation after it is in progress, delete the target cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in the <i>copying</i> status.
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     *        Represents the input to <a>CopyDBClusterSnapshot</a>.
     * @return Result of the CopyDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         You already have a cluster snapshot with the given identifier.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws SnapshotQuotaExceededException
     *         The request would cause you to exceed the allowed number of snapshots.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred when accessing an AWS KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CopyDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyDbClusterSnapshotResponse copyDBClusterSnapshot(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, DbClusterSnapshotNotFoundException, InvalidDbClusterStateException,
            InvalidDbClusterSnapshotStateException, SnapshotQuotaExceededException, KmsKeyNotAccessibleException,
            AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a snapshot of a cluster.
     * </p>
     * <p>
     * To copy a cluster snapshot from a shared manual cluster snapshot, <code>SourceDBClusterSnapshotIdentifier</code>
     * must be the Amazon Resource Name (ARN) of the shared cluster snapshot.
     * </p>
     * <p>
     * To cancel the copy operation after it is in progress, delete the target cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in the <i>copying</i> status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CopyDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopyDBClusterSnapshotMessage.Builder} to create a
     *        request. Represents the input to <a>CopyDBClusterSnapshot</a>.
     * @return Result of the CopyDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         You already have a cluster snapshot with the given identifier.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws SnapshotQuotaExceededException
     *         The request would cause you to exceed the allowed number of snapshots.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred when accessing an AWS KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CopyDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyDbClusterSnapshotResponse copyDBClusterSnapshot(
            Consumer<CopyDbClusterSnapshotRequest.Builder> copyDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, DbClusterSnapshotNotFoundException, InvalidDbClusterStateException,
            InvalidDbClusterSnapshotStateException, SnapshotQuotaExceededException, KmsKeyNotAccessibleException,
            AwsServiceException, SdkClientException, DocDbException {
        return copyDBClusterSnapshot(CopyDbClusterSnapshotRequest.builder().applyMutation(copyDbClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon DocumentDB cluster.
     * </p>
     *
     * @param createDbClusterRequest
     *        Represents the input to <a>CreateDBCluster</a>.
     * @return Result of the CreateDBCluster operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         You already have a cluster with the given identifier.
     * @throws InsufficientStorageClusterCapacityException
     *         There is not enough storage available for the current action. You might be able to resolve this error by
     *         updating your subnet group to use different Availability Zones that have more storage available.
     * @throws DbClusterQuotaExceededException
     *         The cluster can't be created because you have reached the maximum allowed quota of clusters.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbSubnetGroupStateException
     *         The subnet group can't be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing cluster parameter group.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred when accessing an AWS KMS key.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CreateDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbClusterResponse createDBCluster(CreateDbClusterRequest createDbClusterRequest)
            throws DbClusterAlreadyExistsException, InsufficientStorageClusterCapacityException, DbClusterQuotaExceededException,
            StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException,
            InvalidDbClusterStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException,
            InvalidDbInstanceStateException, DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException,
            DbClusterNotFoundException, DbInstanceNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon DocumentDB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbClusterRequest#builder()}
     * </p>
     *
     * @param createDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBClusterMessage.Builder} to create a request.
     *        Represents the input to <a>CreateDBCluster</a>.
     * @return Result of the CreateDBCluster operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         You already have a cluster with the given identifier.
     * @throws InsufficientStorageClusterCapacityException
     *         There is not enough storage available for the current action. You might be able to resolve this error by
     *         updating your subnet group to use different Availability Zones that have more storage available.
     * @throws DbClusterQuotaExceededException
     *         The cluster can't be created because you have reached the maximum allowed quota of clusters.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbSubnetGroupStateException
     *         The subnet group can't be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing cluster parameter group.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred when accessing an AWS KMS key.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CreateDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbClusterResponse createDBCluster(Consumer<CreateDbClusterRequest.Builder> createDbClusterRequest)
            throws DbClusterAlreadyExistsException, InsufficientStorageClusterCapacityException, DbClusterQuotaExceededException,
            StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException,
            InvalidDbClusterStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException,
            InvalidDbInstanceStateException, DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException,
            DbClusterNotFoundException, DbInstanceNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            AwsServiceException, SdkClientException, DocDbException {
        return createDBCluster(CreateDbClusterRequest.builder().applyMutation(createDbClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new cluster parameter group.
     * </p>
     * <p>
     * Parameters in a cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the cluster. To provide custom values for any of the parameters, you must modify the group after you
     * create it. After you create a DB cluster parameter group, you must associate it with your cluster. For the new DB
     * cluster parameter group and associated settings to take effect, you must then reboot the instances in the cluster
     * without failover.
     * </p>
     * <important>
     * <p>
     * After you create a cluster parameter group, you should wait at least 5 minutes before creating your first cluster
     * that uses that cluster parameter group as the default parameter group. This allows Amazon DocumentDB to fully
     * complete the create action before the cluster parameter group is used as the default for a new cluster. This step
     * is especially important for parameters that are critical when creating the default database for a cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter.
     * </p>
     * </important>
     *
     * @param createDbClusterParameterGroupRequest
     *        Represents the input of <a>CreateDBClusterParameterGroup</a>.
     * @return Result of the CreateDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupQuotaExceededException
     *         This request would cause you to exceed the allowed number of parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A parameter group with the same name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CreateDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbClusterParameterGroupResponse createDBClusterParameterGroup(
            CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest)
            throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cluster parameter group.
     * </p>
     * <p>
     * Parameters in a cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the cluster. To provide custom values for any of the parameters, you must modify the group after you
     * create it. After you create a DB cluster parameter group, you must associate it with your cluster. For the new DB
     * cluster parameter group and associated settings to take effect, you must then reboot the instances in the cluster
     * without failover.
     * </p>
     * <important>
     * <p>
     * After you create a cluster parameter group, you should wait at least 5 minutes before creating your first cluster
     * that uses that cluster parameter group as the default parameter group. This allows Amazon DocumentDB to fully
     * complete the create action before the cluster parameter group is used as the default for a new cluster. This step
     * is especially important for parameters that are critical when creating the default database for a cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param createDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBClusterParameterGroupMessage.Builder} to
     *        create a request. Represents the input of <a>CreateDBClusterParameterGroup</a>.
     * @return Result of the CreateDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupQuotaExceededException
     *         This request would cause you to exceed the allowed number of parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A parameter group with the same name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CreateDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbClusterParameterGroupResponse createDBClusterParameterGroup(
            Consumer<CreateDbClusterParameterGroupRequest.Builder> createDbClusterParameterGroupRequest)
            throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, DocDbException {
        return createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest.builder()
                .applyMutation(createDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of a cluster.
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     *        Represents the input of <a>CreateDBClusterSnapshot</a>.
     * @return Result of the CreateDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         You already have a cluster snapshot with the given identifier.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SnapshotQuotaExceededException
     *         The request would cause you to exceed the allowed number of snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CreateDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDbClusterSnapshotResponse createDBClusterSnapshot(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, InvalidDbClusterStateException, DbClusterNotFoundException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBClusterSnapshotMessage.Builder} to create a
     *        request. Represents the input of <a>CreateDBClusterSnapshot</a>.
     * @return Result of the CreateDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         You already have a cluster snapshot with the given identifier.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SnapshotQuotaExceededException
     *         The request would cause you to exceed the allowed number of snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CreateDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDbClusterSnapshotResponse createDBClusterSnapshot(
            Consumer<CreateDbClusterSnapshotRequest.Builder> createDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, InvalidDbClusterStateException, DbClusterNotFoundException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            DocDbException {
        return createDBClusterSnapshot(CreateDbClusterSnapshotRequest.builder().applyMutation(createDbClusterSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new instance.
     * </p>
     *
     * @param createDbInstanceRequest
     *        Represents the input to <a>CreateDBInstance</a>.
     * @return Result of the CreateDBInstance operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         You already have a instance with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified instance class isn't available in the specified Availability Zone.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing security group.
     * @throws InstanceQuotaExceededException
     *         The request would cause you to exceed the allowed number of instances.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws StorageTypeNotSupportedException
     *         Storage of the specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP or Amazon EC2 security group isn't authorized for the specified security group.</p>
     *         <p>
     *         Amazon DocumentDB also might not be authorized to perform necessary actions on your behalf using IAM.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred when accessing an AWS KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CreateDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbInstanceResponse createDBInstance(CreateDbInstanceRequest createDbInstanceRequest)
            throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException,
            DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException,
            InvalidSubnetException, InvalidVpcNetworkStateException, DbClusterNotFoundException,
            StorageTypeNotSupportedException, AuthorizationNotFoundException, KmsKeyNotAccessibleException, AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbInstanceRequest#builder()}
     * </p>
     *
     * @param createDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBInstanceMessage.Builder} to create a request.
     *        Represents the input to <a>CreateDBInstance</a>.
     * @return Result of the CreateDBInstance operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         You already have a instance with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified instance class isn't available in the specified Availability Zone.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing security group.
     * @throws InstanceQuotaExceededException
     *         The request would cause you to exceed the allowed number of instances.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws StorageTypeNotSupportedException
     *         Storage of the specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP or Amazon EC2 security group isn't authorized for the specified security group.</p>
     *         <p>
     *         Amazon DocumentDB also might not be authorized to perform necessary actions on your behalf using IAM.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred when accessing an AWS KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CreateDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbInstanceResponse createDBInstance(Consumer<CreateDbInstanceRequest.Builder> createDbInstanceRequest)
            throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException,
            DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException,
            InvalidSubnetException, InvalidVpcNetworkStateException, DbClusterNotFoundException,
            StorageTypeNotSupportedException, AuthorizationNotFoundException, KmsKeyNotAccessibleException, AwsServiceException,
            SdkClientException, DocDbException {
        return createDBInstance(CreateDbInstanceRequest.builder().applyMutation(createDbInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a new subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in
     * the AWS Region.
     * </p>
     *
     * @param createDbSubnetGroupRequest
     *        Represents the input to <a>CreateDBSubnetGroup</a>.
     * @return Result of the CreateDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupAlreadyExistsException
     *         <code>DBSubnetGroupName</code> is already being used by an existing subnet group.
     * @throws DbSubnetGroupQuotaExceededException
     *         The request would cause you to exceed the allowed number of subnet groups.
     * @throws DbSubnetQuotaExceededException
     *         The request would cause you to exceed the allowed number of subnets in a subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CreateDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbSubnetGroupResponse createDBSubnetGroup(CreateDbSubnetGroupRequest createDbSubnetGroupRequest)
            throws DbSubnetGroupAlreadyExistsException, DbSubnetGroupQuotaExceededException, DbSubnetQuotaExceededException,
            DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in
     * the AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBSubnetGroupMessage.Builder} to create a
     *        request. Represents the input to <a>CreateDBSubnetGroup</a>.
     * @return Result of the CreateDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupAlreadyExistsException
     *         <code>DBSubnetGroupName</code> is already being used by an existing subnet group.
     * @throws DbSubnetGroupQuotaExceededException
     *         The request would cause you to exceed the allowed number of subnet groups.
     * @throws DbSubnetQuotaExceededException
     *         The request would cause you to exceed the allowed number of subnets in a subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.CreateDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbSubnetGroupResponse createDBSubnetGroup(
            Consumer<CreateDbSubnetGroupRequest.Builder> createDbSubnetGroupRequest) throws DbSubnetGroupAlreadyExistsException,
            DbSubnetGroupQuotaExceededException, DbSubnetQuotaExceededException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidSubnetException, AwsServiceException, SdkClientException, DocDbException {
        return createDBSubnetGroup(CreateDbSubnetGroupRequest.builder().applyMutation(createDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are
     * deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.
     * </p>
     * <p/>
     *
     * @param deleteDbClusterRequest
     *        Represents the input to <a>DeleteDBCluster</a>.
     * @return Result of the DeleteDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         You already have a cluster snapshot with the given identifier.
     * @throws SnapshotQuotaExceededException
     *         The request would cause you to exceed the allowed number of snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DeleteDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbClusterResponse deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, DbClusterSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are
     * deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbClusterRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBClusterMessage.Builder} to create a request.
     *        Represents the input to <a>DeleteDBCluster</a>.
     * @return Result of the DeleteDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         You already have a cluster snapshot with the given identifier.
     * @throws SnapshotQuotaExceededException
     *         The request would cause you to exceed the allowed number of snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DeleteDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbClusterResponse deleteDBCluster(Consumer<DeleteDbClusterRequest.Builder> deleteDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, DbClusterSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            DocDbException {
        return deleteDBCluster(DeleteDbClusterRequest.builder().applyMutation(deleteDbClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with
     * any clusters.
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     *        Represents the input to <a>DeleteDBClusterParameterGroup</a>.
     * @return Result of the DeleteDBClusterParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The parameter group is in use, or it is in a state that is not valid. If you are trying to delete the
     *         parameter group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DeleteDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDbClusterParameterGroupResponse deleteDBClusterParameterGroup(
            DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with
     * any clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBClusterParameterGroupMessage.Builder} to
     *        create a request. Represents the input to <a>DeleteDBClusterParameterGroup</a>.
     * @return Result of the DeleteDBClusterParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The parameter group is in use, or it is in a state that is not valid. If you are trying to delete the
     *         parameter group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DeleteDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDbClusterParameterGroupResponse deleteDBClusterParameterGroup(
            Consumer<DeleteDbClusterParameterGroupRequest.Builder> deleteDbClusterParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        return deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest.builder()
                .applyMutation(deleteDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     *
     * @param deleteDbClusterSnapshotRequest
     *        Represents the input to <a>DeleteDBClusterSnapshot</a>.
     * @return Result of the DeleteDBClusterSnapshot operation returned by the service.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DeleteDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDbClusterSnapshotResponse deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest)
            throws InvalidDbClusterSnapshotStateException, DbClusterSnapshotNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBClusterSnapshotMessage.Builder} to create a
     *        request. Represents the input to <a>DeleteDBClusterSnapshot</a>.
     * @return Result of the DeleteDBClusterSnapshot operation returned by the service.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DeleteDBClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDbClusterSnapshotResponse deleteDBClusterSnapshot(
            Consumer<DeleteDbClusterSnapshotRequest.Builder> deleteDbClusterSnapshotRequest)
            throws InvalidDbClusterSnapshotStateException, DbClusterSnapshotNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        return deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest.builder().applyMutation(deleteDbClusterSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a previously provisioned instance.
     * </p>
     *
     * @param deleteDbInstanceRequest
     *        Represents the input to <a>DeleteDBInstance</a>.
     * @return Result of the DeleteDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already being used by an existing snapshot.
     * @throws SnapshotQuotaExceededException
     *         The request would cause you to exceed the allowed number of snapshots.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DeleteDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbInstanceResponse deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterStateException, AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously provisioned instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbInstanceRequest#builder()}
     * </p>
     *
     * @param deleteDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBInstanceMessage.Builder} to create a request.
     *        Represents the input to <a>DeleteDBInstance</a>.
     * @return Result of the DeleteDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already being used by an existing snapshot.
     * @throws SnapshotQuotaExceededException
     *         The request would cause you to exceed the allowed number of snapshots.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DeleteDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbInstanceResponse deleteDBInstance(Consumer<DeleteDbInstanceRequest.Builder> deleteDbInstanceRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterStateException, AwsServiceException, SdkClientException,
            DocDbException {
        return deleteDBInstance(DeleteDbInstanceRequest.builder().applyMutation(deleteDbInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note>
     *
     * @param deleteDbSubnetGroupRequest
     *        Represents the input to <a>DeleteDBSubnetGroup</a>.
     * @return Result of the DeleteDBSubnetGroup operation returned by the service.
     * @throws InvalidDbSubnetGroupStateException
     *         The subnet group can't be deleted because it's in use.
     * @throws InvalidDbSubnetStateException
     *         The subnet isn't in the <i>available</i> state.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DeleteDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbSubnetGroupResponse deleteDBSubnetGroup(DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest)
            throws InvalidDbSubnetGroupStateException, InvalidDbSubnetStateException, DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBSubnetGroupMessage.Builder} to create a
     *        request. Represents the input to <a>DeleteDBSubnetGroup</a>.
     * @return Result of the DeleteDBSubnetGroup operation returned by the service.
     * @throws InvalidDbSubnetGroupStateException
     *         The subnet group can't be deleted because it's in use.
     * @throws InvalidDbSubnetStateException
     *         The subnet isn't in the <i>available</i> state.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DeleteDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbSubnetGroupResponse deleteDBSubnetGroup(
            Consumer<DeleteDbSubnetGroupRequest.Builder> deleteDbSubnetGroupRequest) throws InvalidDbSubnetGroupStateException,
            InvalidDbSubnetStateException, DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException,
            DocDbException {
        return deleteDBSubnetGroup(DeleteDbSubnetGroupRequest.builder().applyMutation(deleteDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this AWS account.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates(DescribeCertificatesRequest describeCertificatesRequest)
            throws CertificateNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCertificatesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) throws CertificateNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        return describeCertificates(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list contains only the description of the
     * specified cluster parameter group.
     * </p>
     *
     * @return Result of the DescribeDBClusterParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusterParameterGroups
     * @see #describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups() throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        return describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list contains only the description of the
     * specified cluster parameter group.
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     *        Represents the input to <a>DescribeDBClusterParameterGroups</a>.
     * @return Result of the DescribeDBClusterParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusterParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list contains only the description of the
     * specified cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterParameterGroupsMessage.Builder} to
     *        create a request. Represents the input to <a>DescribeDBClusterParameterGroups</a>.
     * @return Result of the DescribeDBClusterParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusterParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups(
            Consumer<DescribeDbClusterParameterGroupsRequest.Builder> describeDbClusterParameterGroupsRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder()
                .applyMutation(describeDbClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular cluster parameter group.
     * </p>
     *
     * @param describeDbClusterParametersRequest
     *        Represents the input to <a>DescribeDBClusterParameters</a>.
     * @return Result of the DescribeDBClusterParameters operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterParametersResponse describeDBClusterParameters(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterParametersMessage.Builder} to create
     *        a request. Represents the input to <a>DescribeDBClusterParameters</a>.
     * @return Result of the DescribeDBClusterParameters operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterParametersResponse describeDBClusterParameters(
            Consumer<DescribeDbClusterParametersRequest.Builder> describeDbClusterParametersRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return describeDBClusterParameters(DescribeDbClusterParametersRequest.builder()
                .applyMutation(describeDbClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns a list of cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When you share snapshots with other AWS accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the
     * <code>restore</code> attribute and a list of IDs for the AWS accounts that are authorized to copy or restore the
     * manual cluster snapshot. If <code>all</code> is included in the list of values for the <code>restore</code>
     * attribute, then the manual cluster snapshot is public and can be copied or restored by all AWS accounts.
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     *        Represents the input to <a>DescribeDBClusterSnapshotAttributes</a>.
     * @return Result of the DescribeDBClusterSnapshotAttributes operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterSnapshotAttributesResponse describeDBClusterSnapshotAttributes(
            DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest)
            throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When you share snapshots with other AWS accounts, <code>DescribeDBClusterSnapshotAttributes</code> returns the
     * <code>restore</code> attribute and a list of IDs for the AWS accounts that are authorized to copy or restore the
     * manual cluster snapshot. If <code>all</code> is included in the list of values for the <code>restore</code>
     * attribute, then the manual cluster snapshot is public and can be copied or restored by all AWS accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterSnapshotAttributesRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterSnapshotAttributesMessage.Builder} to
     *        create a request. Represents the input to <a>DescribeDBClusterSnapshotAttributes</a>.
     * @return Result of the DescribeDBClusterSnapshotAttributes operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterSnapshotAttributesResponse describeDBClusterSnapshotAttributes(
            Consumer<DescribeDbClusterSnapshotAttributesRequest.Builder> describeDbClusterSnapshotAttributesRequest)
            throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest.builder()
                .applyMutation(describeDbClusterSnapshotAttributesRequest).build());
    }

    /**
     * <p>
     * Returns information about cluster snapshots. This API operation supports pagination.
     * </p>
     *
     * @return Result of the DescribeDBClusterSnapshots operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusterSnapshots
     * @see #describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots() throws DbClusterSnapshotNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        return describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about cluster snapshots. This API operation supports pagination.
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     *        Represents the input to <a>DescribeDBClusterSnapshots</a>.
     * @return Result of the DescribeDBClusterSnapshots operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about cluster snapshots. This API operation supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterSnapshotsMessage.Builder} to create a
     *        request. Represents the input to <a>DescribeDBClusterSnapshots</a>.
     * @return Result of the DescribeDBClusterSnapshots operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots(
            Consumer<DescribeDbClusterSnapshotsRequest.Builder> describeDbClusterSnapshotsRequest)
            throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder()
                .applyMutation(describeDbClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For
     * certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages
     * operational technology that is shared with Amazon RDS and Amazon Neptune. Use the
     * <code>filterName=engine,Values=docdb</code> filter parameter to return only Amazon DocumentDB clusters.
     * </p>
     *
     * @return Result of the DescribeDBClusters operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusters
     * @see #describeDBClusters(DescribeDbClustersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbClustersResponse describeDBClusters() throws DbClusterNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        return describeDBClusters(DescribeDbClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For
     * certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages
     * operational technology that is shared with Amazon RDS and Amazon Neptune. Use the
     * <code>filterName=engine,Values=docdb</code> filter parameter to return only Amazon DocumentDB clusters.
     * </p>
     *
     * @param describeDbClustersRequest
     *        Represents the input to <a>DescribeDBClusters</a>.
     * @return Result of the DescribeDBClusters operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbClustersResponse describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest)
            throws DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For
     * certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages
     * operational technology that is shared with Amazon RDS and Amazon Neptune. Use the
     * <code>filterName=engine,Values=docdb</code> filter parameter to return only Amazon DocumentDB clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbClustersRequest#builder()}
     * </p>
     *
     * @param describeDbClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClustersMessage.Builder} to create a
     *        request. Represents the input to <a>DescribeDBClusters</a>.
     * @return Result of the DescribeDBClusters operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbClustersResponse describeDBClusters(Consumer<DescribeDbClustersRequest.Builder> describeDbClustersRequest)
            throws DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return describeDBClusters(DescribeDbClustersRequest.builder().applyMutation(describeDbClustersRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For
     * certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages
     * operational technology that is shared with Amazon RDS and Amazon Neptune. Use the
     * <code>filterName=engine,Values=docdb</code> filter parameter to return only Amazon DocumentDB clusters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable responses = client
     *             .describeDBClustersPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusters
     * @see #describeDBClustersPaginator(DescribeDbClustersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBClustersIterable describeDBClustersPaginator() throws DbClusterNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        return describeDBClustersPaginator(DescribeDbClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For
     * certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages
     * operational technology that is shared with Amazon RDS and Amazon Neptune. Use the
     * <code>filterName=engine,Values=docdb</code> filter parameter to return only Amazon DocumentDB clusters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable responses = client
     *             .describeDBClustersPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest)} operation.</b>
     * </p>
     *
     * @param describeDbClustersRequest
     *        Represents the input to <a>DescribeDBClusters</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBClustersIterable describeDBClustersPaginator(DescribeDbClustersRequest describeDbClustersRequest)
            throws DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB clusters. This API operation supports pagination. For
     * certain management features such as cluster and instance lifecycle management, Amazon DocumentDB leverages
     * operational technology that is shared with Amazon RDS and Amazon Neptune. Use the
     * <code>filterName=engine,Values=docdb</code> filter parameter to return only Amazon DocumentDB clusters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable responses = client
     *             .describeDBClustersPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbClustersRequest#builder()}
     * </p>
     *
     * @param describeDbClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClustersMessage.Builder} to create a
     *        request. Represents the input to <a>DescribeDBClusters</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBClustersIterable describeDBClustersPaginator(
            Consumer<DescribeDbClustersRequest.Builder> describeDbClustersRequest) throws DbClusterNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        return describeDBClustersPaginator(DescribeDbClustersRequest.builder().applyMutation(describeDbClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available engines.
     * </p>
     *
     * @return Result of the DescribeDBEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBEngineVersions
     * @see #describeDBEngineVersions(DescribeDbEngineVersionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbEngineVersionsResponse describeDBEngineVersions() throws AwsServiceException, SdkClientException,
            DocDbException {
        return describeDBEngineVersions(DescribeDbEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available engines.
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        Represents the input to <a>DescribeDBEngineVersions</a>.
     * @return Result of the DescribeDBEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbEngineVersionsResponse describeDBEngineVersions(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available engines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbEngineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBEngineVersionsMessage.Builder} to create a
     *        request. Represents the input to <a>DescribeDBEngineVersions</a>.
     * @return Result of the DescribeDBEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbEngineVersionsResponse describeDBEngineVersions(
            Consumer<DescribeDbEngineVersionsRequest.Builder> describeDbEngineVersionsRequest) throws AwsServiceException,
            SdkClientException, DocDbException {
        return describeDBEngineVersions(DescribeDbEngineVersionsRequest.builder().applyMutation(describeDbEngineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the available engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable responses = client
     *             .describeDBEngineVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBEngineVersions
     * @see #describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBEngineVersionsIterable describeDBEngineVersionsPaginator() throws AwsServiceException, SdkClientException,
            DocDbException {
        return describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable responses = client
     *             .describeDBEngineVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        Represents the input to <a>DescribeDBEngineVersions</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBEngineVersionsIterable describeDBEngineVersionsPaginator(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable responses = client
     *             .describeDBEngineVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbEngineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBEngineVersionsMessage.Builder} to create a
     *        request. Represents the input to <a>DescribeDBEngineVersions</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBEngineVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBEngineVersionsIterable describeDBEngineVersionsPaginator(
            Consumer<DescribeDbEngineVersionsRequest.Builder> describeDbEngineVersionsRequest) throws AwsServiceException,
            SdkClientException, DocDbException {
        return describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest.builder()
                .applyMutation(describeDbEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     * </p>
     *
     * @return Result of the DescribeDBInstances operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBInstances
     * @see #describeDBInstances(DescribeDbInstancesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbInstancesResponse describeDBInstances() throws DbInstanceNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        return describeDBInstances(DescribeDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     * </p>
     *
     * @param describeDbInstancesRequest
     *        Represents the input to <a>DescribeDBInstances</a>.
     * @return Result of the DescribeDBInstances operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbInstancesResponse describeDBInstances(DescribeDbInstancesRequest describeDbInstancesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeDbInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBInstancesMessage.Builder} to create a
     *        request. Represents the input to <a>DescribeDBInstances</a>.
     * @return Result of the DescribeDBInstances operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbInstancesResponse describeDBInstances(
            Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) throws DbInstanceNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        return describeDBInstances(DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable responses = client
     *             .describeDBInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBInstances
     * @see #describeDBInstancesPaginator(DescribeDbInstancesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBInstancesIterable describeDBInstancesPaginator() throws DbInstanceNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        return describeDBInstancesPaginator(DescribeDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable responses = client
     *             .describeDBInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbInstancesRequest
     *        Represents the input to <a>DescribeDBInstances</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBInstancesIterable describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable responses = client
     *             .describeDBInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeDbInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBInstancesMessage.Builder} to create a
     *        request. Represents the input to <a>DescribeDBInstances</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBInstancesIterable describeDBInstancesPaginator(
            Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) throws DbInstanceNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        return describeDBInstancesPaginator(DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>DBSubnetGroup</code> descriptions. If a <code>DBSubnetGroupName</code> is specified, the
     * list will contain only the descriptions of the specified <code>DBSubnetGroup</code>.
     * </p>
     *
     * @return Result of the DescribeDBSubnetGroups operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBSubnetGroups
     * @see #describeDBSubnetGroups(DescribeDbSubnetGroupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbSubnetGroupsResponse describeDBSubnetGroups() throws DbSubnetGroupNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        return describeDBSubnetGroups(DescribeDbSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBSubnetGroup</code> descriptions. If a <code>DBSubnetGroupName</code> is specified, the
     * list will contain only the descriptions of the specified <code>DBSubnetGroup</code>.
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        Represents the input to <a>DescribeDBSubnetGroups</a>.
     * @return Result of the DescribeDBSubnetGroups operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbSubnetGroupsResponse describeDBSubnetGroups(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest)
            throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBSubnetGroup</code> descriptions. If a <code>DBSubnetGroupName</code> is specified, the
     * list will contain only the descriptions of the specified <code>DBSubnetGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSubnetGroupsMessage.Builder} to create a
     *        request. Represents the input to <a>DescribeDBSubnetGroups</a>.
     * @return Result of the DescribeDBSubnetGroups operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbSubnetGroupsResponse describeDBSubnetGroups(
            Consumer<DescribeDbSubnetGroupsRequest.Builder> describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        return describeDBSubnetGroups(DescribeDbSubnetGroupsRequest.builder().applyMutation(describeDbSubnetGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>DBSubnetGroup</code> descriptions. If a <code>DBSubnetGroupName</code> is specified, the
     * list will contain only the descriptions of the specified <code>DBSubnetGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable responses = client
     *             .describeDBSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBSubnetGroups
     * @see #describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsIterable describeDBSubnetGroupsPaginator() throws DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        return describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBSubnetGroup</code> descriptions. If a <code>DBSubnetGroupName</code> is specified, the
     * list will contain only the descriptions of the specified <code>DBSubnetGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable responses = client
     *             .describeDBSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        Represents the input to <a>DescribeDBSubnetGroups</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsIterable describeDBSubnetGroupsPaginator(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBSubnetGroup</code> descriptions. If a <code>DBSubnetGroupName</code> is specified, the
     * list will contain only the descriptions of the specified <code>DBSubnetGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable responses = client
     *             .describeDBSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSubnetGroupsMessage.Builder} to create a
     *        request. Represents the input to <a>DescribeDBSubnetGroups</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeDBSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsIterable describeDBSubnetGroupsPaginator(
            Consumer<DescribeDbSubnetGroupsRequest.Builder> describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        return describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest.builder()
                .applyMutation(describeDbSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     *        Represents the input to <a>DescribeEngineDefaultClusterParameters</a>.
     * @return Result of the DescribeEngineDefaultClusterParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEngineDefaultClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParameters(
            DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest)
            throws AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEngineDefaultClusterParametersRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEngineDefaultClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineDefaultClusterParametersMessage.Builder}
     *        to create a request. Represents the input to <a>DescribeEngineDefaultClusterParameters</a>.
     * @return Result of the DescribeEngineDefaultClusterParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEngineDefaultClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParameters(
            Consumer<DescribeEngineDefaultClusterParametersRequest.Builder> describeEngineDefaultClusterParametersRequest)
            throws AwsServiceException, SdkClientException, DocDbException {
        return describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest.builder()
                .applyMutation(describeEngineDefaultClusterParametersRequest).build());
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     *
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEventCategories
     * @see #describeEventCategories(DescribeEventCategoriesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories() throws AwsServiceException, SdkClientException,
            DocDbException {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().build());
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        Represents the input to <a>DescribeEventCategories</a>.
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEventCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest)
            throws AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventCategoriesRequest#builder()}
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventCategoriesMessage.Builder} to create a
     *        request. Represents the input to <a>DescribeEventCategories</a>.
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEventCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories(
            Consumer<DescribeEventCategoriesRequest.Builder> describeEventCategoriesRequest) throws AwsServiceException,
            SdkClientException, DocDbException {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().applyMutation(describeEventCategoriesRequest)
                .build());
    }

    /**
     * <p>
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days.
     * You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by
     * providing the name as a parameter. By default, the events of the past hour are returned.
     * </p>
     *
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEvents
     * @see #describeEvents(DescribeEventsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents() throws AwsServiceException, SdkClientException, DocDbException {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days.
     * You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by
     * providing the name as a parameter. By default, the events of the past hour are returned.
     * </p>
     *
     * @param describeEventsRequest
     *        Represents the input to <a>DescribeEvents</a>.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days.
     * You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by
     * providing the name as a parameter. By default, the events of the past hour are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     *        Represents the input to <a>DescribeEvents</a>.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, DocDbException {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days.
     * You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by
     * providing the name as a parameter. By default, the events of the past hour are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.docdb.model.DescribeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.docdb.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEvents
     * @see #describeEventsPaginator(DescribeEventsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator() throws AwsServiceException, SdkClientException, DocDbException {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days.
     * You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by
     * providing the name as a parameter. By default, the events of the past hour are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.docdb.model.DescribeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.docdb.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     *        Represents the input to <a>DescribeEvents</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest)
            throws AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days.
     * You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by
     * providing the name as a parameter. By default, the events of the past hour are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.docdb.model.DescribeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.docdb.model.DescribeEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     *        Represents the input to <a>DescribeEvents</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, DocDbException {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable instance options for the specified engine.
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        Represents the input to <a>DescribeOrderableDBInstanceOptions</a>.
     * @return Result of the DescribeOrderableDBInstanceOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeOrderableDBInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDbInstanceOptionsResponse describeOrderableDBInstanceOptions(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of orderable instance options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableDbInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableDbInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableDBInstanceOptionsMessage.Builder} to
     *        create a request. Represents the input to <a>DescribeOrderableDBInstanceOptions</a>.
     * @return Result of the DescribeOrderableDBInstanceOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeOrderableDBInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDbInstanceOptionsResponse describeOrderableDBInstanceOptions(
            Consumer<DescribeOrderableDbInstanceOptionsRequest.Builder> describeOrderableDbInstanceOptionsRequest)
            throws AwsServiceException, SdkClientException, DocDbException {
        return describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest.builder()
                .applyMutation(describeOrderableDbInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable instance options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client.describeOrderableDBInstanceOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client
     *             .describeOrderableDBInstanceOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client.describeOrderableDBInstanceOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        Represents the input to <a>DescribeOrderableDBInstanceOptions</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeOrderableDBInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDBInstanceOptionsIterable describeOrderableDBInstanceOptionsPaginator(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of orderable instance options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client.describeOrderableDBInstanceOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client
     *             .describeOrderableDBInstanceOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client.describeOrderableDBInstanceOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableDbInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableDbInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableDBInstanceOptionsMessage.Builder} to
     *        create a request. Represents the input to <a>DescribeOrderableDBInstanceOptions</a>.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribeOrderableDBInstanceOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDBInstanceOptionsIterable describeOrderableDBInstanceOptionsPaginator(
            Consumer<DescribeOrderableDbInstanceOptionsRequest.Builder> describeOrderableDbInstanceOptionsRequest)
            throws AwsServiceException, SdkClientException, DocDbException {
        return describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest.builder()
                .applyMutation(describeOrderableDbInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, instances) that have at least one pending maintenance action.
     * </p>
     *
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribePendingMaintenanceActions
     * @see #describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, instances) that have at least one pending maintenance action.
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        Represents the input to <a>DescribePendingMaintenanceActions</a>.
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribePendingMaintenanceActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resources (for example, instances) that have at least one pending maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePendingMaintenanceActionsMessage.Builder} to
     *        create a request. Represents the input to <a>DescribePendingMaintenanceActions</a>.
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.DescribePendingMaintenanceActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Forces a failover for a cluster.
     * </p>
     * <p>
     * A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to
     * be the primary instance (the cluster writer).
     * </p>
     * <p>
     * If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one
     * exists. You can force a failover when you want to simulate a failure of a primary instance for testing.
     * </p>
     *
     * @param failoverDbClusterRequest
     *        Represents the input to <a>FailoverDBCluster</a>.
     * @return Result of the FailoverDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.FailoverDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default FailoverDbClusterResponse failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forces a failover for a cluster.
     * </p>
     * <p>
     * A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to
     * be the primary instance (the cluster writer).
     * </p>
     * <p>
     * If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one
     * exists. You can force a failover when you want to simulate a failure of a primary instance for testing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FailoverDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link FailoverDbClusterRequest#builder()}
     * </p>
     *
     * @param failoverDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link FailoverDBClusterMessage.Builder} to create a request.
     *        Represents the input to <a>FailoverDBCluster</a>.
     * @return Result of the FailoverDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.FailoverDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default FailoverDbClusterResponse failoverDBCluster(Consumer<FailoverDbClusterRequest.Builder> failoverDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, DocDbException {
        return failoverDBCluster(FailoverDbClusterRequest.builder().applyMutation(failoverDbClusterRequest).build());
    }

    /**
     * <p>
     * Lists all tags on an Amazon DocumentDB resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        Represents the input to <a>ListTagsForResource</a>.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on an Amazon DocumentDB resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceMessage.Builder} to create a
     *        request. Represents the input to <a>ListTagsForResource</a>.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws DbInstanceNotFoundException,
            DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database configuration parameters
     * by specifying these parameters and the new values in the request.
     * </p>
     *
     * @param modifyDbClusterRequest
     *        Represents the input to <a>ModifyDBCluster</a>.
     * @return Result of the ModifyDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws InvalidDbSubnetGroupStateException
     *         The subnet group can't be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing cluster parameter group.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the security group doesn't allow deletion.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws DbClusterAlreadyExistsException
     *         You already have a cluster with the given identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ModifyDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbClusterResponse modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbSubnetGroupStateException,
            InvalidSubnetException, DbClusterParameterGroupNotFoundException, InvalidDbSecurityGroupStateException,
            InvalidDbInstanceStateException, DbClusterAlreadyExistsException, AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database configuration parameters
     * by specifying these parameters and the new values in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyDbClusterRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBClusterMessage.Builder} to create a request.
     *        Represents the input to <a>ModifyDBCluster</a>.
     * @return Result of the ModifyDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws InvalidDbSubnetGroupStateException
     *         The subnet group can't be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing cluster parameter group.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the security group doesn't allow deletion.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws DbClusterAlreadyExistsException
     *         You already have a cluster with the given identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ModifyDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbClusterResponse modifyDBCluster(Consumer<ModifyDbClusterRequest.Builder> modifyDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbSubnetGroupStateException,
            InvalidSubnetException, DbClusterParameterGroupNotFoundException, InvalidDbSecurityGroupStateException,
            InvalidDbInstanceStateException, DbClusterAlreadyExistsException, AwsServiceException, SdkClientException,
            DocDbException {
        return modifyDBCluster(ModifyDbClusterRequest.builder().applyMutation(modifyDbClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot or
     * maintenance window before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you create a cluster parameter group, you should wait at least 5 minutes before creating your first cluster
     * that uses that cluster parameter group as the default parameter group. This allows Amazon DocumentDB to fully
     * complete the create action before the parameter group is used as the default for a new cluster. This step is
     * especially important for parameters that are critical when creating the default database for a cluster, such as
     * the character set for the default database defined by the <code>character_set_database</code> parameter.
     * </p>
     * </important>
     *
     * @param modifyDbClusterParameterGroupRequest
     *        Represents the input to <a>ModifyDBClusterParameterGroup</a>.
     * @return Result of the ModifyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws InvalidDbParameterGroupStateException
     *         The parameter group is in use, or it is in a state that is not valid. If you are trying to delete the
     *         parameter group, you can't delete it when the parameter group is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ModifyDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyDbClusterParameterGroupResponse modifyDBClusterParameterGroup(
            ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException,
            InvalidDbParameterGroupStateException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <note>
     * <p>
     * Changes to dynamic parameters are applied immediately. Changes to static parameters require a reboot or
     * maintenance window before the change can take effect.
     * </p>
     * </note> <important>
     * <p>
     * After you create a cluster parameter group, you should wait at least 5 minutes before creating your first cluster
     * that uses that cluster parameter group as the default parameter group. This allows Amazon DocumentDB to fully
     * complete the create action before the parameter group is used as the default for a new cluster. This step is
     * especially important for parameters that are critical when creating the default database for a cluster, such as
     * the character set for the default database defined by the <code>character_set_database</code> parameter.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBClusterParameterGroupMessage.Builder} to
     *        create a request. Represents the input to <a>ModifyDBClusterParameterGroup</a>.
     * @return Result of the ModifyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws InvalidDbParameterGroupStateException
     *         The parameter group is in use, or it is in a state that is not valid. If you are trying to delete the
     *         parameter group, you can't delete it when the parameter group is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ModifyDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyDbClusterParameterGroupResponse modifyDBClusterParameterGroup(
            Consumer<ModifyDbClusterParameterGroupRequest.Builder> modifyDbClusterParameterGroupRequest)
            throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException,
            SdkClientException, DocDbException {
        return modifyDBClusterParameterGroup(ModifyDbClusterParameterGroupRequest.builder()
                .applyMutation(modifyDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual cluster snapshot with other AWS accounts, specify <code>restore</code> as the
     * <code>AttributeName</code>, and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the AWS
     * accounts that are authorized to restore the manual cluster snapshot. Use the value <code>all</code> to make the
     * manual cluster snapshot public, which means that it can be copied or restored by all AWS accounts. Do not add the
     * <code>all</code> value for any manual DB cluster snapshots that contain private information that you don't want
     * available to all AWS accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by
     * specifying a list of authorized AWS account IDs for the <code>ValuesToAdd</code> parameter. You can't use
     * <code>all</code> as a value for that parameter in this case.
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     *        Represents the input to <a>ModifyDBClusterSnapshotAttribute</a>.
     * @return Result of the ModifyDBClusterSnapshotAttribute operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws SharedSnapshotQuotaExceededException
     *         You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyDbClusterSnapshotAttributeResponse modifyDBClusterSnapshotAttribute(
            ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest)
            throws DbClusterSnapshotNotFoundException, InvalidDbClusterSnapshotStateException,
            SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual cluster snapshot with other AWS accounts, specify <code>restore</code> as the
     * <code>AttributeName</code>, and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the AWS
     * accounts that are authorized to restore the manual cluster snapshot. Use the value <code>all</code> to make the
     * manual cluster snapshot public, which means that it can be copied or restored by all AWS accounts. Do not add the
     * <code>all</code> value for any manual DB cluster snapshots that contain private information that you don't want
     * available to all AWS accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by
     * specifying a list of authorized AWS account IDs for the <code>ValuesToAdd</code> parameter. You can't use
     * <code>all</code> as a value for that parameter in this case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterSnapshotAttributeRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyDbClusterSnapshotAttributeRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBClusterSnapshotAttributeMessage.Builder} to
     *        create a request. Represents the input to <a>ModifyDBClusterSnapshotAttribute</a>.
     * @return Result of the ModifyDBClusterSnapshotAttribute operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws SharedSnapshotQuotaExceededException
     *         You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyDbClusterSnapshotAttributeResponse modifyDBClusterSnapshotAttribute(
            Consumer<ModifyDbClusterSnapshotAttributeRequest.Builder> modifyDbClusterSnapshotAttributeRequest)
            throws DbClusterSnapshotNotFoundException, InvalidDbClusterSnapshotStateException,
            SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException, DocDbException {
        return modifyDBClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest.builder()
                .applyMutation(modifyDbClusterSnapshotAttributeRequest).build());
    }

    /**
     * <p>
     * Modifies settings for an instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     *
     * @param modifyDbInstanceRequest
     *        Represents the input to <a>ModifyDBInstance</a>.
     * @return Result of the ModifyDBInstance operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the security group doesn't allow deletion.
     * @throws DbInstanceAlreadyExistsException
     *         You already have a instance with the given identifier.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing security group.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified instance class isn't available in the specified Availability Zone.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws DbUpgradeDependencyFailureException
     *         The upgrade failed because a resource that the depends on can't be modified.
     * @throws StorageTypeNotSupportedException
     *         Storage of the specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP or Amazon EC2 security group isn't authorized for the specified security group.</p>
     *         <p>
     *         Amazon DocumentDB also might not be authorized to perform necessary actions on your behalf using IAM.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ModifyDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbInstanceResponse modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest)
            throws InvalidDbInstanceStateException, InvalidDbSecurityGroupStateException, DbInstanceAlreadyExistsException,
            DbInstanceNotFoundException, DbSecurityGroupNotFoundException, DbParameterGroupNotFoundException,
            InsufficientDbInstanceCapacityException, StorageQuotaExceededException, InvalidVpcNetworkStateException,
            DbUpgradeDependencyFailureException, StorageTypeNotSupportedException, AuthorizationNotFoundException,
            CertificateNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies settings for an instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyDbInstanceRequest#builder()}
     * </p>
     *
     * @param modifyDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBInstanceMessage.Builder} to create a request.
     *        Represents the input to <a>ModifyDBInstance</a>.
     * @return Result of the ModifyDBInstance operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the security group doesn't allow deletion.
     * @throws DbInstanceAlreadyExistsException
     *         You already have a instance with the given identifier.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing security group.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified instance class isn't available in the specified Availability Zone.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws DbUpgradeDependencyFailureException
     *         The upgrade failed because a resource that the depends on can't be modified.
     * @throws StorageTypeNotSupportedException
     *         Storage of the specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP or Amazon EC2 security group isn't authorized for the specified security group.</p>
     *         <p>
     *         Amazon DocumentDB also might not be authorized to perform necessary actions on your behalf using IAM.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ModifyDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbInstanceResponse modifyDBInstance(Consumer<ModifyDbInstanceRequest.Builder> modifyDbInstanceRequest)
            throws InvalidDbInstanceStateException, InvalidDbSecurityGroupStateException, DbInstanceAlreadyExistsException,
            DbInstanceNotFoundException, DbSecurityGroupNotFoundException, DbParameterGroupNotFoundException,
            InsufficientDbInstanceCapacityException, StorageQuotaExceededException, InvalidVpcNetworkStateException,
            DbUpgradeDependencyFailureException, StorageTypeNotSupportedException, AuthorizationNotFoundException,
            CertificateNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return modifyDBInstance(ModifyDbInstanceRequest.builder().applyMutation(modifyDbInstanceRequest).build());
    }

    /**
     * <p>
     * Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability
     * Zones in the AWS Region.
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     *        Represents the input to <a>ModifyDBSubnetGroup</a>.
     * @return Result of the ModifyDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws DbSubnetQuotaExceededException
     *         The request would cause you to exceed the allowed number of subnets in a subnet group.
     * @throws SubnetAlreadyInUseException
     *         The subnet is already in use in the Availability Zone.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ModifyDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbSubnetGroupResponse modifyDBSubnetGroup(ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest)
            throws DbSubnetGroupNotFoundException, DbSubnetQuotaExceededException, SubnetAlreadyInUseException,
            DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability
     * Zones in the AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBSubnetGroupMessage.Builder} to create a
     *        request. Represents the input to <a>ModifyDBSubnetGroup</a>.
     * @return Result of the ModifyDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws DbSubnetQuotaExceededException
     *         The request would cause you to exceed the allowed number of subnets in a subnet group.
     * @throws SubnetAlreadyInUseException
     *         The subnet is already in use in the Availability Zone.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ModifyDBSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbSubnetGroupResponse modifyDBSubnetGroup(
            Consumer<ModifyDbSubnetGroupRequest.Builder> modifyDbSubnetGroupRequest) throws DbSubnetGroupNotFoundException,
            DbSubnetQuotaExceededException, SubnetAlreadyInUseException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidSubnetException, AwsServiceException, SdkClientException, DocDbException {
        return modifyDBSubnetGroup(ModifyDbSubnetGroupRequest.builder().applyMutation(modifyDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * You might need to reboot your instance, usually for maintenance reasons. For example, if you make certain
     * changes, or if you change the cluster parameter group that is associated with the instance, you must reboot the
     * instance for the changes to take effect.
     * </p>
     * <p>
     * Rebooting an instance restarts the database engine service. Rebooting an instance results in a momentary outage,
     * during which the instance status is set to <i>rebooting</i>.
     * </p>
     *
     * @param rebootDbInstanceRequest
     *        Represents the input to <a>RebootDBInstance</a>.
     * @return Result of the RebootDBInstance operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.RebootDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RebootDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootDbInstanceResponse rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest)
            throws InvalidDbInstanceStateException, DbInstanceNotFoundException, AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You might need to reboot your instance, usually for maintenance reasons. For example, if you make certain
     * changes, or if you change the cluster parameter group that is associated with the instance, you must reboot the
     * instance for the changes to take effect.
     * </p>
     * <p>
     * Rebooting an instance restarts the database engine service. Rebooting an instance results in a momentary outage,
     * during which the instance status is set to <i>rebooting</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link RebootDbInstanceRequest#builder()}
     * </p>
     *
     * @param rebootDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link RebootDBInstanceMessage.Builder} to create a request.
     *        Represents the input to <a>RebootDBInstance</a>.
     * @return Result of the RebootDBInstance operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.RebootDBInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RebootDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootDbInstanceResponse rebootDBInstance(Consumer<RebootDbInstanceRequest.Builder> rebootDbInstanceRequest)
            throws InvalidDbInstanceStateException, DbInstanceNotFoundException, AwsServiceException, SdkClientException,
            DocDbException {
        return rebootDBInstance(RebootDbInstanceRequest.builder().applyMutation(rebootDbInstanceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from an Amazon DocumentDB resource.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        Represents the input to <a>RemoveTagsFromResource</a>.
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.RemoveTagsFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from an Amazon DocumentDB resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsFromResourceMessage.Builder} to create a
     *        request. Represents the input to <a>RemoveTagsFromResource</a>.
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing instance.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.RemoveTagsFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveTagsFromResourceResponse removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) throws DbInstanceNotFoundException,
            DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().applyMutation(removeTagsFromResourceRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the parameters of a cluster parameter group to the default value. To reset specific parameters, submit a
     * list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire cluster
     * parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
     * parameters.
     * </p>
     * <p>
     * When you reset the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance reboot.
     * </p>
     *
     * @param resetDbClusterParameterGroupRequest
     *        Represents the input to <a>ResetDBClusterParameterGroup</a>.
     * @return Result of the ResetDBClusterParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The parameter group is in use, or it is in a state that is not valid. If you are trying to delete the
     *         parameter group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ResetDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ResetDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetDbClusterParameterGroupResponse resetDBClusterParameterGroup(
            ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a cluster parameter group to the default value. To reset specific parameters, submit a
     * list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. To reset the entire cluster
     * parameter group, specify the <code>DBClusterParameterGroupName</code> and <code>ResetAllParameters</code>
     * parameters.
     * </p>
     * <p>
     * When you reset the entire group, dynamic parameters are updated immediately and static parameters are set to
     * <code>pending-reboot</code> to take effect on the next DB instance reboot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ResetDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param resetDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ResetDBClusterParameterGroupMessage.Builder} to create
     *        a request. Represents the input to <a>ResetDBClusterParameterGroup</a>.
     * @return Result of the ResetDBClusterParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The parameter group is in use, or it is in a state that is not valid. If you are trying to delete the
     *         parameter group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.ResetDBClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/ResetDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetDbClusterParameterGroupResponse resetDBClusterParameterGroup(
            Consumer<ResetDbClusterParameterGroupRequest.Builder> resetDbClusterParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, DocDbException {
        return resetDBClusterParameterGroup(ResetDbClusterParameterGroupRequest.builder()
                .applyMutation(resetDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new cluster from a snapshot or cluster snapshot.
     * </p>
     * <p>
     * If a snapshot is specified, the target cluster is created from the source DB snapshot with a default
     * configuration and default security group.
     * </p>
     * <p>
     * If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the
     * same configuration as the original source DB cluster, except that the new cluster is created with the default
     * security group.
     * </p>
     *
     * @param restoreDbClusterFromSnapshotRequest
     *        Represents the input to <a>RestoreDBClusterFromSnapshot</a>.
     * @return Result of the RestoreDBClusterFromSnapshot operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         You already have a cluster with the given identifier.
     * @throws DbClusterQuotaExceededException
     *         The cluster can't be created because you have reached the maximum allowed quota of clusters.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing snapshot.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws InsufficientDbClusterCapacityException
     *         The cluster doesn't have enough capacity for the current operation.
     * @throws InsufficientStorageClusterCapacityException
     *         There is not enough storage available for the current action. You might be able to resolve this error by
     *         updating your subnet group to use different Availability Zones that have more storage available.
     * @throws InvalidDbSnapshotStateException
     *         The state of the snapshot doesn't allow deletion.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws InvalidRestoreException
     *         You cannot restore from a virtual private cloud (VPC) backup to a non-VPC DB instance.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws KmsKeyNotAccessibleException
     *         An error occurred when accessing an AWS KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.RestoreDBClusterFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RestoreDBClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreDbClusterFromSnapshotResponse restoreDBClusterFromSnapshot(
            RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) throws DbClusterAlreadyExistsException,
            DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException,
            DbSnapshotNotFoundException, DbClusterSnapshotNotFoundException, InsufficientDbClusterCapacityException,
            InsufficientStorageClusterCapacityException, InvalidDbSnapshotStateException, InvalidDbClusterSnapshotStateException,
            InvalidVpcNetworkStateException, InvalidRestoreException, InvalidSubnetException, KmsKeyNotAccessibleException,
            AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cluster from a snapshot or cluster snapshot.
     * </p>
     * <p>
     * If a snapshot is specified, the target cluster is created from the source DB snapshot with a default
     * configuration and default security group.
     * </p>
     * <p>
     * If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the
     * same configuration as the original source DB cluster, except that the new cluster is created with the default
     * security group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreDbClusterFromSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreDbClusterFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreDbClusterFromSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link RestoreDBClusterFromSnapshotMessage.Builder} to create
     *        a request. Represents the input to <a>RestoreDBClusterFromSnapshot</a>.
     * @return Result of the RestoreDBClusterFromSnapshot operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         You already have a cluster with the given identifier.
     * @throws DbClusterQuotaExceededException
     *         The cluster can't be created because you have reached the maximum allowed quota of clusters.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing snapshot.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws InsufficientDbClusterCapacityException
     *         The cluster doesn't have enough capacity for the current operation.
     * @throws InsufficientStorageClusterCapacityException
     *         There is not enough storage available for the current action. You might be able to resolve this error by
     *         updating your subnet group to use different Availability Zones that have more storage available.
     * @throws InvalidDbSnapshotStateException
     *         The state of the snapshot doesn't allow deletion.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws InvalidRestoreException
     *         You cannot restore from a virtual private cloud (VPC) backup to a non-VPC DB instance.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws KmsKeyNotAccessibleException
     *         An error occurred when accessing an AWS KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.RestoreDBClusterFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RestoreDBClusterFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreDbClusterFromSnapshotResponse restoreDBClusterFromSnapshot(
            Consumer<RestoreDbClusterFromSnapshotRequest.Builder> restoreDbClusterFromSnapshotRequest)
            throws DbClusterAlreadyExistsException, DbClusterQuotaExceededException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, DbSnapshotNotFoundException, DbClusterSnapshotNotFoundException,
            InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException, InvalidDbSnapshotStateException,
            InvalidDbClusterSnapshotStateException, InvalidVpcNetworkStateException, InvalidRestoreException,
            InvalidSubnetException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DocDbException {
        return restoreDBClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest.builder()
                .applyMutation(restoreDbClusterFromSnapshotRequest).build());
    }

    /**
     * <p>
     * Restores a cluster to an arbitrary point in time. Users can restore to any point in time before
     * <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target cluster is
     * created from the source cluster with the same configuration as the original cluster, except that the new cluster
     * is created with the default security group.
     * </p>
     *
     * @param restoreDbClusterToPointInTimeRequest
     *        Represents the input to <a>RestoreDBClusterToPointInTime</a>.
     * @return Result of the RestoreDBClusterToPointInTime operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         You already have a cluster with the given identifier.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws DbClusterQuotaExceededException
     *         The cluster can't be created because you have reached the maximum allowed quota of clusters.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws InsufficientDbClusterCapacityException
     *         The cluster doesn't have enough capacity for the current operation.
     * @throws InsufficientStorageClusterCapacityException
     *         There is not enough storage available for the current action. You might be able to resolve this error by
     *         updating your subnet group to use different Availability Zones that have more storage available.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbSnapshotStateException
     *         The state of the snapshot doesn't allow deletion.
     * @throws InvalidRestoreException
     *         You cannot restore from a virtual private cloud (VPC) backup to a non-VPC DB instance.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred when accessing an AWS KMS key.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.RestoreDBClusterToPointInTime
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RestoreDBClusterToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreDbClusterToPointInTimeResponse restoreDBClusterToPointInTime(
            RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) throws DbClusterAlreadyExistsException,
            DbClusterNotFoundException, DbClusterQuotaExceededException, DbClusterSnapshotNotFoundException,
            DbSubnetGroupNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException,
            InvalidDbClusterSnapshotStateException, InvalidDbClusterStateException, InvalidDbSnapshotStateException,
            InvalidRestoreException, InvalidSubnetException, InvalidVpcNetworkStateException, KmsKeyNotAccessibleException,
            StorageQuotaExceededException, AwsServiceException, SdkClientException, DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a cluster to an arbitrary point in time. Users can restore to any point in time before
     * <code>LatestRestorableTime</code> for up to <code>BackupRetentionPeriod</code> days. The target cluster is
     * created from the source cluster with the same configuration as the original cluster, except that the new cluster
     * is created with the default security group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreDbClusterToPointInTimeRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreDbClusterToPointInTimeRequest#builder()}
     * </p>
     *
     * @param restoreDbClusterToPointInTimeRequest
     *        A {@link Consumer} that will call methods on {@link RestoreDBClusterToPointInTimeMessage.Builder} to
     *        create a request. Represents the input to <a>RestoreDBClusterToPointInTime</a>.
     * @return Result of the RestoreDBClusterToPointInTime operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         You already have a cluster with the given identifier.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws DbClusterQuotaExceededException
     *         The cluster can't be created because you have reached the maximum allowed quota of clusters.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing cluster snapshot.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing subnet group.
     * @throws InsufficientDbClusterCapacityException
     *         The cluster doesn't have enough capacity for the current operation.
     * @throws InsufficientStorageClusterCapacityException
     *         There is not enough storage available for the current action. You might be able to resolve this error by
     *         updating your subnet group to use different Availability Zones that have more storage available.
     * @throws InvalidDbClusterSnapshotStateException
     *         The provided value isn't a valid cluster snapshot state.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbSnapshotStateException
     *         The state of the snapshot doesn't allow deletion.
     * @throws InvalidRestoreException
     *         You cannot restore from a virtual private cloud (VPC) backup to a non-VPC DB instance.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or multiple subnets were requested that are not all in a common
     *         virtual private cloud (VPC).
     * @throws InvalidVpcNetworkStateException
     *         The subnet group doesn't cover all Availability Zones after it is created because of changes that were
     *         made.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred when accessing an AWS KMS key.
     * @throws StorageQuotaExceededException
     *         The request would cause you to exceed the allowed amount of storage available across all instances.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.RestoreDBClusterToPointInTime
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/RestoreDBClusterToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreDbClusterToPointInTimeResponse restoreDBClusterToPointInTime(
            Consumer<RestoreDbClusterToPointInTimeRequest.Builder> restoreDbClusterToPointInTimeRequest)
            throws DbClusterAlreadyExistsException, DbClusterNotFoundException, DbClusterQuotaExceededException,
            DbClusterSnapshotNotFoundException, DbSubnetGroupNotFoundException, InsufficientDbClusterCapacityException,
            InsufficientStorageClusterCapacityException, InvalidDbClusterSnapshotStateException, InvalidDbClusterStateException,
            InvalidDbSnapshotStateException, InvalidRestoreException, InvalidSubnetException, InvalidVpcNetworkStateException,
            KmsKeyNotAccessibleException, StorageQuotaExceededException, AwsServiceException, SdkClientException, DocDbException {
        return restoreDBClusterToPointInTime(RestoreDbClusterToPointInTimeRequest.builder()
                .applyMutation(restoreDbClusterToPointInTimeRequest).build());
    }

    /**
     * <p>
     * Restarts the stopped cluster that is specified by <code>DBClusterIdentifier</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster</a>.
     * </p>
     *
     * @param startDbClusterRequest
     * @return Result of the StartDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.StartDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/StartDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default StartDbClusterResponse startDBCluster(StartDbClusterRequest startDbClusterRequest) throws DbClusterNotFoundException,
            InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts the stopped cluster that is specified by <code>DBClusterIdentifier</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDbClusterRequest.Builder} avoiding the need to
     * create one manually via {@link StartDbClusterRequest#builder()}
     * </p>
     *
     * @param startDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link StartDBClusterMessage.Builder} to create a request.
     * @return Result of the StartDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.StartDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/StartDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default StartDbClusterResponse startDBCluster(Consumer<StartDbClusterRequest.Builder> startDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, DocDbException {
        return startDBCluster(StartDbClusterRequest.builder().applyMutation(startDbClusterRequest).build());
    }

    /**
     * <p>
     * Stops the running cluster that is specified by <code>DBClusterIdentifier</code>. The cluster must be in the
     * <i>available</i> state. For more information, see <a
     * href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster</a>.
     * </p>
     *
     * @param stopDbClusterRequest
     * @return Result of the StopDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.StopDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/StopDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDbClusterResponse stopDBCluster(StopDbClusterRequest stopDbClusterRequest) throws DbClusterNotFoundException,
            InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            DocDbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the running cluster that is specified by <code>DBClusterIdentifier</code>. The cluster must be in the
     * <i>available</i> state. For more information, see <a
     * href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDbClusterRequest.Builder} avoiding the need to
     * create one manually via {@link StopDbClusterRequest#builder()}
     * </p>
     *
     * @param stopDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link StopDBClusterMessage.Builder} to create a request.
     * @return Result of the StopDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing cluster.
     * @throws InvalidDbClusterStateException
     *         The cluster isn't in a valid state.
     * @throws InvalidDbInstanceStateException
     *         The specified instance isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DocDbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DocDbClient.StopDBCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/StopDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDbClusterResponse stopDBCluster(Consumer<StopDbClusterRequest.Builder> stopDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, DocDbException {
        return stopDBCluster(StopDbClusterRequest.builder().applyMutation(stopDbClusterRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("rds");
    }
}
