/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.docdb.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.docdb.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.docdb.model.CertificateNotFoundException;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.docdb.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.docdb.model.DeleteDBClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDBSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.docdb.model.DescribeEventsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeEventsResponse;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.docdb.model.DocDbException;
import software.amazon.awssdk.services.docdb.model.DocDbRequest;
import software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.docdb.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.docdb.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.docdb.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.docdb.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.docdb.model.InvalidRestoreException;
import software.amazon.awssdk.services.docdb.model.InvalidSubnetException;
import software.amazon.awssdk.services.docdb.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.docdb.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.docdb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.docdb.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.StartDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.StartDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.StopDbClusterRequest;
import software.amazon.awssdk.services.docdb.model.StopDbClusterResponse;
import software.amazon.awssdk.services.docdb.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.docdb.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.docdb.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsIterable;
import software.amazon.awssdk.services.docdb.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CopyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CopyDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.CreateDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DeleteDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeCertificatesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbClustersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeDbSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEngineDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribeOrderableDbInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.FailoverDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbClusterSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ModifyDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RebootDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.ResetDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RestoreDbClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.RestoreDbClusterToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.StartDbClusterRequestMarshaller;
import software.amazon.awssdk.services.docdb.transform.StopDbClusterRequestMarshaller;

@SdkInternalApi
final class DefaultDocDbClient
implements DocDbClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDocDbClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "rds";
    }

    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsToResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToResourceRequest).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplyPendingMaintenanceActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ApplyPendingMaintenanceActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyPendingMaintenanceAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)applyPendingMaintenanceActionRequest).withMarshaller((Marshaller)new ApplyPendingMaintenanceActionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CopyDbClusterParameterGroupResponse copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException, DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CopyDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyDbClusterParameterGroupRequest).withMarshaller((Marshaller)new CopyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CopyDbClusterSnapshotResponse copyDBClusterSnapshot(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) throws DbClusterSnapshotAlreadyExistsException, DbClusterSnapshotNotFoundException, InvalidDbClusterStateException, InvalidDbClusterSnapshotStateException, SnapshotQuotaExceededException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CopyDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyDbClusterSnapshotRequest).withMarshaller((Marshaller)new CopyDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbClusterResponse createDBCluster(CreateDbClusterRequest createDbClusterRequest) throws DbClusterAlreadyExistsException, InsufficientStorageClusterCapacityException, DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbClusterStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException, InvalidDbInstanceStateException, DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException, DbClusterNotFoundException, DbInstanceNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterRequest).withMarshaller((Marshaller)new CreateDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbClusterParameterGroupResponse createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterParameterGroupRequest).withMarshaller((Marshaller)new CreateDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbClusterSnapshotResponse createDBClusterSnapshot(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) throws DbClusterSnapshotAlreadyExistsException, InvalidDbClusterStateException, DbClusterNotFoundException, SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterSnapshotRequest).withMarshaller((Marshaller)new CreateDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbInstanceResponse createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException, DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException, InvalidSubnetException, InvalidVpcNetworkStateException, DbClusterNotFoundException, StorageTypeNotSupportedException, AuthorizationNotFoundException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbInstanceRequest).withMarshaller((Marshaller)new CreateDbInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbSubnetGroupResponse createDBSubnetGroup(CreateDbSubnetGroupRequest createDbSubnetGroupRequest) throws DbSubnetGroupAlreadyExistsException, DbSubnetGroupQuotaExceededException, DbSubnetQuotaExceededException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbSubnetGroupRequest).withMarshaller((Marshaller)new CreateDbSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDbClusterResponse deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, DbClusterSnapshotAlreadyExistsException, SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterRequest).withMarshaller((Marshaller)new DeleteDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDBClusterParameterGroupResponse deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDBClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDBClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterParameterGroupRequest).withMarshaller((Marshaller)new DeleteDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDbClusterSnapshotResponse deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) throws InvalidDbClusterSnapshotStateException, DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterSnapshotRequest).withMarshaller((Marshaller)new DeleteDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDbInstanceResponse deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) throws DbInstanceNotFoundException, InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException, SnapshotQuotaExceededException, InvalidDbClusterStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbInstanceRequest).withMarshaller((Marshaller)new DeleteDbInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDBSubnetGroupResponse deleteDBSubnetGroup(DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) throws InvalidDbSubnetGroupStateException, InvalidDbSubnetStateException, DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDBSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDBSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbSubnetGroupRequest).withMarshaller((Marshaller)new DeleteDbSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeCertificatesResponse describeCertificates(DescribeCertificatesRequest describeCertificatesRequest) throws CertificateNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeCertificatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCertificatesRequest).withMarshaller((Marshaller)new DescribeCertificatesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParameterGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbClusterParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameterGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterParameterGroupsRequest).withMarshaller((Marshaller)new DescribeDbClusterParameterGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbClusterParametersResponse describeDBClusterParameters(DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbClusterParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterParametersRequest).withMarshaller((Marshaller)new DescribeDbClusterParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbClusterSnapshotAttributesResponse describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbClusterSnapshotAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshotAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterSnapshotAttributesRequest).withMarshaller((Marshaller)new DescribeDbClusterSnapshotAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbClusterSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterSnapshotsRequest).withMarshaller((Marshaller)new DescribeDbClusterSnapshotsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbClustersResponse describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) throws DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClustersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClustersRequest).withMarshaller((Marshaller)new DescribeDbClustersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDBClustersIterable describeDBClustersPaginator(DescribeDbClustersRequest describeDbClustersRequest) throws DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBClustersIterable(this, this.applyPaginatorUserAgent(describeDbClustersRequest));
    }

    @Override
    public DescribeDbEngineVersionsResponse describeDBEngineVersions(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbEngineVersionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbEngineVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBEngineVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbEngineVersionsRequest).withMarshaller((Marshaller)new DescribeDbEngineVersionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDBEngineVersionsIterable describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBEngineVersionsIterable(this, this.applyPaginatorUserAgent(describeDbEngineVersionsRequest));
    }

    @Override
    public DescribeDbInstancesResponse describeDBInstances(DescribeDbInstancesRequest describeDbInstancesRequest) throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbInstancesRequest).withMarshaller((Marshaller)new DescribeDbInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDBInstancesIterable describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest) throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBInstancesIterable(this, this.applyPaginatorUserAgent(describeDbInstancesRequest));
    }

    @Override
    public DescribeDbSubnetGroupsResponse describeDBSubnetGroups(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbSubnetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBSubnetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbSubnetGroupsRequest).withMarshaller((Marshaller)new DescribeDbSubnetGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDBSubnetGroupsIterable describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        return new DescribeDBSubnetGroupsIterable(this, this.applyPaginatorUserAgent(describeDbSubnetGroupsRequest));
    }

    @Override
    public DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) throws AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultClusterParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEngineDefaultClusterParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultClusterParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEngineDefaultClusterParametersRequest).withMarshaller((Marshaller)new DescribeEngineDefaultClusterParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) throws AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventCategoriesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEventCategoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventCategoriesRequest).withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        return new DescribeEventsIterable(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public DescribeOrderableDbInstanceOptionsResponse describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeOrderableDbInstanceOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeOrderableDbInstanceOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableDBInstanceOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrderableDbInstanceOptionsRequest).withMarshaller((Marshaller)new DescribeOrderableDbInstanceOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeOrderableDBInstanceOptionsIterable describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException, SdkClientException, DocDbException {
        return new DescribeOrderableDBInstanceOptionsIterable(this, this.applyPaginatorUserAgent(describeOrderableDbInstanceOptionsRequest));
    }

    @Override
    public DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePendingMaintenanceActionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribePendingMaintenanceActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingMaintenanceActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePendingMaintenanceActionsRequest).withMarshaller((Marshaller)new DescribePendingMaintenanceActionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public FailoverDbClusterResponse failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(FailoverDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (FailoverDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("FailoverDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)failoverDbClusterRequest).withMarshaller((Marshaller)new FailoverDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbClusterResponse modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException, DbClusterParameterGroupNotFoundException, InvalidDbSecurityGroupStateException, InvalidDbInstanceStateException, DbClusterAlreadyExistsException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterRequest).withMarshaller((Marshaller)new ModifyDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbClusterParameterGroupResponse modifyDBClusterParameterGroup(ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterParameterGroupRequest).withMarshaller((Marshaller)new ModifyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbClusterSnapshotAttributeResponse modifyDBClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) throws DbClusterSnapshotNotFoundException, InvalidDbClusterSnapshotStateException, SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterSnapshotAttributeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbClusterSnapshotAttributeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterSnapshotAttribute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterSnapshotAttributeRequest).withMarshaller((Marshaller)new ModifyDbClusterSnapshotAttributeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbInstanceResponse modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest) throws InvalidDbInstanceStateException, InvalidDbSecurityGroupStateException, DbInstanceAlreadyExistsException, DbInstanceNotFoundException, DbSecurityGroupNotFoundException, DbParameterGroupNotFoundException, InsufficientDbInstanceCapacityException, StorageQuotaExceededException, InvalidVpcNetworkStateException, DbUpgradeDependencyFailureException, StorageTypeNotSupportedException, AuthorizationNotFoundException, CertificateNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbInstanceRequest).withMarshaller((Marshaller)new ModifyDbInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbSubnetGroupResponse modifyDBSubnetGroup(ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest) throws DbSubnetGroupNotFoundException, DbSubnetQuotaExceededException, SubnetAlreadyInUseException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbSubnetGroupRequest).withMarshaller((Marshaller)new ModifyDbSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RebootDbInstanceResponse rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest) throws InvalidDbInstanceStateException, DbInstanceNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RebootDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootDbInstanceRequest).withMarshaller((Marshaller)new RebootDbInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsFromResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromResourceRequest).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ResetDbClusterParameterGroupResponse resetDBClusterParameterGroup(ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ResetDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetDbClusterParameterGroupRequest).withMarshaller((Marshaller)new ResetDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RestoreDbClusterFromSnapshotResponse restoreDBClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) throws DbClusterAlreadyExistsException, DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, DbSnapshotNotFoundException, DbClusterSnapshotNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException, InvalidDbSnapshotStateException, InvalidDbClusterSnapshotStateException, InvalidVpcNetworkStateException, InvalidRestoreException, InvalidSubnetException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterFromSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RestoreDbClusterFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterFromSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreDbClusterFromSnapshotRequest).withMarshaller((Marshaller)new RestoreDbClusterFromSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RestoreDbClusterToPointInTimeResponse restoreDBClusterToPointInTime(RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) throws DbClusterAlreadyExistsException, DbClusterNotFoundException, DbClusterQuotaExceededException, DbClusterSnapshotNotFoundException, DbSubnetGroupNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException, InvalidDbClusterSnapshotStateException, InvalidDbClusterStateException, InvalidDbSnapshotStateException, InvalidRestoreException, InvalidSubnetException, InvalidVpcNetworkStateException, KmsKeyNotAccessibleException, StorageQuotaExceededException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterToPointInTimeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RestoreDbClusterToPointInTimeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterToPointInTime").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreDbClusterToPointInTimeRequest).withMarshaller((Marshaller)new RestoreDbClusterToPointInTimeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartDbClusterResponse startDBCluster(StartDbClusterRequest startDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StartDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (StartDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDbClusterRequest).withMarshaller((Marshaller)new StartDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StopDbClusterResponse stopDBCluster(StopDbClusterRequest stopDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, DocDbException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StopDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (StopDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopDbClusterRequest).withMarshaller((Marshaller)new StopDbClusterRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupNotFound").exceptionBuilderSupplier(DbParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InstanceQuotaExceeded").exceptionBuilderSupplier(InstanceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterNotFoundFault").exceptionBuilderSupplier(DbClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceeded").exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterQuotaExceededFault").exceptionBuilderSupplier(DbClusterQuotaExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetStateFault").exceptionBuilderSupplier(InvalidDbSubnetStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestoreFault").exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBClusterCapacityFault").exceptionBuilderSupplier(InsufficientDbClusterCapacityException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceNotFound").exceptionBuilderSupplier(DbInstanceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SharedSnapshotQuotaExceeded").exceptionBuilderSupplier(SharedSnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupDoesNotCoverEnoughAZs").exceptionBuilderSupplier(DbSubnetGroupDoesNotCoverEnoughAZsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotAlreadyExists").exceptionBuilderSupplier(DbSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotAlreadyExistsFault").exceptionBuilderSupplier(DbClusterSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterStateFault").exceptionBuilderSupplier(InvalidDbClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupQuotaExceeded").exceptionBuilderSupplier(DbSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupStateFault").exceptionBuilderSupplier(InvalidDbSubnetGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterParameterGroupNotFound").exceptionBuilderSupplier(DbClusterParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetQuotaExceededFault").exceptionBuilderSupplier(DbSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupNotFoundFault").exceptionBuilderSupplier(DbSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBUpgradeDependencyFailure").exceptionBuilderSupplier(DbUpgradeDependencyFailureException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSecurityGroupState").exceptionBuilderSupplier(InvalidDbSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterSnapshotStateFault").exceptionBuilderSupplier(InvalidDbClusterSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSecurityGroupNotFound").exceptionBuilderSupplier(DbSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBInstanceCapacity").exceptionBuilderSupplier(InsufficientDbInstanceCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupAlreadyExists").exceptionBuilderSupplier(DbParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotNotFound").exceptionBuilderSupplier(DbSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupQuotaExceeded").exceptionBuilderSupplier(DbParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageTypeNotSupported").exceptionBuilderSupplier(StorageTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientStorageClusterCapacity").exceptionBuilderSupplier(InsufficientStorageClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceAlreadyExists").exceptionBuilderSupplier(DbInstanceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupAlreadyExists").exceptionBuilderSupplier(DbSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotNotFoundFault").exceptionBuilderSupplier(DbClusterSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterAlreadyExistsFault").exceptionBuilderSupplier(DbClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBInstanceState").exceptionBuilderSupplier(InvalidDbInstanceStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSnapshotState").exceptionBuilderSupplier(InvalidDbSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageQuotaExceeded").exceptionBuilderSupplier(StorageQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBParameterGroupState").exceptionBuilderSupplier(InvalidDbParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DocDbException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends DocDbRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.88").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DocDbRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

