/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbInstanceResponse extends DocDbResponse implements
        ToCopyableBuilder<ModifyDbInstanceResponse.Builder, ModifyDbInstanceResponse> {
    private static final SdkField<DBInstance> DB_INSTANCE_FIELD = SdkField.<DBInstance> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyDbInstanceResponse::dbInstance)).setter(setter(Builder::dbInstance))
            .constructor(DBInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_FIELD));

    private final DBInstance dbInstance;

    private ModifyDbInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.dbInstance = builder.dbInstance;
    }

    /**
     * Returns the value of the DBInstance property for this object.
     * 
     * @return The value of the DBInstance property for this object.
     */
    public DBInstance dbInstance() {
        return dbInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstance());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbInstanceResponse)) {
            return false;
        }
        ModifyDbInstanceResponse other = (ModifyDbInstanceResponse) obj;
        return Objects.equals(dbInstance(), other.dbInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyDbInstanceResponse").add("DBInstance", dbInstance()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstance":
            return Optional.ofNullable(clazz.cast(dbInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbInstanceResponse, T> g) {
        return obj -> g.apply((ModifyDbInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DocDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbInstanceResponse> {
        /**
         * Sets the value of the DBInstance property for this object.
         *
         * @param dbInstance
         *        The new value for the DBInstance property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstance(DBInstance dbInstance);

        /**
         * Sets the value of the DBInstance property for this object.
         *
         * This is a convenience that creates an instance of the {@link DBInstance.Builder} avoiding the need to create
         * one manually via {@link DBInstance#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBInstance.Builder#build()} is called immediately and its result
         * is passed to {@link #dbInstance(DBInstance)}.
         * 
         * @param dbInstance
         *        a consumer that will call methods on {@link DBInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbInstance(DBInstance)
         */
        default Builder dbInstance(Consumer<DBInstance.Builder> dbInstance) {
            return dbInstance(DBInstance.builder().applyMutation(dbInstance).build());
        }
    }

    static final class BuilderImpl extends DocDbResponse.BuilderImpl implements Builder {
        private DBInstance dbInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbInstanceResponse model) {
            super(model);
            dbInstance(model.dbInstance);
        }

        public final DBInstance.Builder getDbInstance() {
            return dbInstance != null ? dbInstance.toBuilder() : null;
        }

        @Override
        public final Builder dbInstance(DBInstance dbInstance) {
            this.dbInstance = dbInstance;
            return this;
        }

        public final void setDbInstance(DBInstance.BuilderImpl dbInstance) {
            this.dbInstance = dbInstance != null ? dbInstance.build() : null;
        }

        @Override
        public ModifyDbInstanceResponse build() {
            return new ModifyDbInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
