/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a DB engine version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBEngineVersion implements SdkPojo, Serializable, ToCopyableBuilder<DBEngineVersion.Builder, DBEngineVersion> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBEngineVersion::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBEngineVersion::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBEngineVersion::dbParameterGroupFamily)).setter(setter(Builder::dbParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build())
            .build();

    private static final SdkField<String> DB_ENGINE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBEngineVersion::dbEngineDescription)).setter(setter(Builder::dbEngineDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineDescription").build())
            .build();

    private static final SdkField<String> DB_ENGINE_VERSION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DBEngineVersion::dbEngineVersionDescription))
            .setter(setter(Builder::dbEngineVersionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersionDescription").build())
            .build();

    private static final SdkField<List<UpgradeTarget>> VALID_UPGRADE_TARGET_FIELD = SdkField
            .<List<UpgradeTarget>> builder(MarshallingType.LIST)
            .getter(getter(DBEngineVersion::validUpgradeTarget))
            .setter(setter(Builder::validUpgradeTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUpgradeTarget").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UpgradeTarget")
                            .memberFieldInfo(
                                    SdkField.<UpgradeTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpgradeTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UpgradeTarget").build()).build()).build()).build();

    private static final SdkField<List<String>> EXPORTABLE_LOG_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DBEngineVersion::exportableLogTypes))
            .setter(setter(Builder::exportableLogTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportableLogTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DBEngineVersion::supportsLogExportsToCloudwatchLogs))
            .setter(setter(Builder::supportsLogExportsToCloudwatchLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLogExportsToCloudwatchLogs")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, DB_PARAMETER_GROUP_FAMILY_FIELD, DB_ENGINE_DESCRIPTION_FIELD,
            DB_ENGINE_VERSION_DESCRIPTION_FIELD, VALID_UPGRADE_TARGET_FIELD, EXPORTABLE_LOG_TYPES_FIELD,
            SUPPORTS_LOG_EXPORTS_TO_CLOUDWATCH_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engine;

    private final String engineVersion;

    private final String dbParameterGroupFamily;

    private final String dbEngineDescription;

    private final String dbEngineVersionDescription;

    private final List<UpgradeTarget> validUpgradeTarget;

    private final List<String> exportableLogTypes;

    private final Boolean supportsLogExportsToCloudwatchLogs;

    private DBEngineVersion(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.dbEngineDescription = builder.dbEngineDescription;
        this.dbEngineVersionDescription = builder.dbEngineVersionDescription;
        this.validUpgradeTarget = builder.validUpgradeTarget;
        this.exportableLogTypes = builder.exportableLogTypes;
        this.supportsLogExportsToCloudwatchLogs = builder.supportsLogExportsToCloudwatchLogs;
    }

    /**
     * <p>
     * The name of the database engine.
     * </p>
     * 
     * @return The name of the database engine.
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the database engine.
     * </p>
     * 
     * @return The version number of the database engine.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of the DB parameter group family for the database engine.
     * </p>
     * 
     * @return The name of the DB parameter group family for the database engine.
     */
    public String dbParameterGroupFamily() {
        return dbParameterGroupFamily;
    }

    /**
     * <p>
     * The description of the database engine.
     * </p>
     * 
     * @return The description of the database engine.
     */
    public String dbEngineDescription() {
        return dbEngineDescription;
    }

    /**
     * <p>
     * The description of the database engine version.
     * </p>
     * 
     * @return The description of the database engine version.
     */
    public String dbEngineVersionDescription() {
        return dbEngineVersionDescription;
    }

    /**
     * Returns true if the ValidUpgradeTarget property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasValidUpgradeTarget() {
        return validUpgradeTarget != null && !(validUpgradeTarget instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of engine versions that this database engine version can be upgraded to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValidUpgradeTarget()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of engine versions that this database engine version can be upgraded to.
     */
    public List<UpgradeTarget> validUpgradeTarget() {
        return validUpgradeTarget;
    }

    /**
     * Returns true if the ExportableLogTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasExportableLogTypes() {
        return exportableLogTypes != null && !(exportableLogTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of logs that the database engine has available for export to Amazon CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExportableLogTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The types of logs that the database engine has available for export to Amazon CloudWatch Logs.
     */
    public List<String> exportableLogTypes() {
        return exportableLogTypes;
    }

    /**
     * <p>
     * A value that indicates whether the engine version supports exporting the log types specified by
     * <code>ExportableLogTypes</code> to CloudWatch Logs.
     * </p>
     * 
     * @return A value that indicates whether the engine version supports exporting the log types specified by
     *         <code>ExportableLogTypes</code> to CloudWatch Logs.
     */
    public Boolean supportsLogExportsToCloudwatchLogs() {
        return supportsLogExportsToCloudwatchLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(dbEngineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(dbEngineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(validUpgradeTarget());
        hashCode = 31 * hashCode + Objects.hashCode(exportableLogTypes());
        hashCode = 31 * hashCode + Objects.hashCode(supportsLogExportsToCloudwatchLogs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBEngineVersion)) {
            return false;
        }
        DBEngineVersion other = (DBEngineVersion) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(dbParameterGroupFamily(), other.dbParameterGroupFamily())
                && Objects.equals(dbEngineDescription(), other.dbEngineDescription())
                && Objects.equals(dbEngineVersionDescription(), other.dbEngineVersionDescription())
                && Objects.equals(validUpgradeTarget(), other.validUpgradeTarget())
                && Objects.equals(exportableLogTypes(), other.exportableLogTypes())
                && Objects.equals(supportsLogExportsToCloudwatchLogs(), other.supportsLogExportsToCloudwatchLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DBEngineVersion").add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("DBParameterGroupFamily", dbParameterGroupFamily()).add("DBEngineDescription", dbEngineDescription())
                .add("DBEngineVersionDescription", dbEngineVersionDescription()).add("ValidUpgradeTarget", validUpgradeTarget())
                .add("ExportableLogTypes", exportableLogTypes())
                .add("SupportsLogExportsToCloudwatchLogs", supportsLogExportsToCloudwatchLogs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "DBParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(dbParameterGroupFamily()));
        case "DBEngineDescription":
            return Optional.ofNullable(clazz.cast(dbEngineDescription()));
        case "DBEngineVersionDescription":
            return Optional.ofNullable(clazz.cast(dbEngineVersionDescription()));
        case "ValidUpgradeTarget":
            return Optional.ofNullable(clazz.cast(validUpgradeTarget()));
        case "ExportableLogTypes":
            return Optional.ofNullable(clazz.cast(exportableLogTypes()));
        case "SupportsLogExportsToCloudwatchLogs":
            return Optional.ofNullable(clazz.cast(supportsLogExportsToCloudwatchLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBEngineVersion, T> g) {
        return obj -> g.apply((DBEngineVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBEngineVersion> {
        /**
         * <p>
         * The name of the database engine.
         * </p>
         * 
         * @param engine
         *        The name of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the database engine.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of the DB parameter group family for the database engine.
         * </p>
         * 
         * @param dbParameterGroupFamily
         *        The name of the DB parameter group family for the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupFamily(String dbParameterGroupFamily);

        /**
         * <p>
         * The description of the database engine.
         * </p>
         * 
         * @param dbEngineDescription
         *        The description of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbEngineDescription(String dbEngineDescription);

        /**
         * <p>
         * The description of the database engine version.
         * </p>
         * 
         * @param dbEngineVersionDescription
         *        The description of the database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbEngineVersionDescription(String dbEngineVersionDescription);

        /**
         * <p>
         * A list of engine versions that this database engine version can be upgraded to.
         * </p>
         * 
         * @param validUpgradeTarget
         *        A list of engine versions that this database engine version can be upgraded to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget);

        /**
         * <p>
         * A list of engine versions that this database engine version can be upgraded to.
         * </p>
         * 
         * @param validUpgradeTarget
         *        A list of engine versions that this database engine version can be upgraded to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUpgradeTarget(UpgradeTarget... validUpgradeTarget);

        /**
         * <p>
         * A list of engine versions that this database engine version can be upgraded to.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpgradeTarget>.Builder} avoiding the need
         * to create one manually via {@link List<UpgradeTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpgradeTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #validUpgradeTarget(List<UpgradeTarget>)}.
         * 
         * @param validUpgradeTarget
         *        a consumer that will call methods on {@link List<UpgradeTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validUpgradeTarget(List<UpgradeTarget>)
         */
        Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder>... validUpgradeTarget);

        /**
         * <p>
         * The types of logs that the database engine has available for export to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param exportableLogTypes
         *        The types of logs that the database engine has available for export to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportableLogTypes(Collection<String> exportableLogTypes);

        /**
         * <p>
         * The types of logs that the database engine has available for export to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param exportableLogTypes
         *        The types of logs that the database engine has available for export to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportableLogTypes(String... exportableLogTypes);

        /**
         * <p>
         * A value that indicates whether the engine version supports exporting the log types specified by
         * <code>ExportableLogTypes</code> to CloudWatch Logs.
         * </p>
         * 
         * @param supportsLogExportsToCloudwatchLogs
         *        A value that indicates whether the engine version supports exporting the log types specified by
         *        <code>ExportableLogTypes</code> to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs);
    }

    static final class BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String dbParameterGroupFamily;

        private String dbEngineDescription;

        private String dbEngineVersionDescription;

        private List<UpgradeTarget> validUpgradeTarget = DefaultSdkAutoConstructList.getInstance();

        private List<String> exportableLogTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean supportsLogExportsToCloudwatchLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(DBEngineVersion model) {
            engine(model.engine);
            engineVersion(model.engineVersion);
            dbParameterGroupFamily(model.dbParameterGroupFamily);
            dbEngineDescription(model.dbEngineDescription);
            dbEngineVersionDescription(model.dbEngineVersionDescription);
            validUpgradeTarget(model.validUpgradeTarget);
            exportableLogTypes(model.exportableLogTypes);
            supportsLogExportsToCloudwatchLogs(model.supportsLogExportsToCloudwatchLogs);
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDbParameterGroupFamily() {
            return dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final String getDbEngineDescription() {
            return dbEngineDescription;
        }

        @Override
        public final Builder dbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
            return this;
        }

        public final void setDbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
        }

        public final String getDbEngineVersionDescription() {
            return dbEngineVersionDescription;
        }

        @Override
        public final Builder dbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
            return this;
        }

        public final void setDbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
        }

        public final Collection<UpgradeTarget.Builder> getValidUpgradeTarget() {
            return validUpgradeTarget != null ? validUpgradeTarget.stream().map(UpgradeTarget::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copy(validUpgradeTarget);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(UpgradeTarget... validUpgradeTarget) {
            validUpgradeTarget(Arrays.asList(validUpgradeTarget));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder>... validUpgradeTarget) {
            validUpgradeTarget(Stream.of(validUpgradeTarget).map(c -> UpgradeTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setValidUpgradeTarget(Collection<UpgradeTarget.BuilderImpl> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copyFromBuilder(validUpgradeTarget);
        }

        public final Collection<String> getExportableLogTypes() {
            return exportableLogTypes;
        }

        @Override
        public final Builder exportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportableLogTypes(String... exportableLogTypes) {
            exportableLogTypes(Arrays.asList(exportableLogTypes));
            return this;
        }

        public final void setExportableLogTypes(Collection<String> exportableLogTypes) {
            this.exportableLogTypes = LogTypeListCopier.copy(exportableLogTypes);
        }

        public final Boolean getSupportsLogExportsToCloudwatchLogs() {
            return supportsLogExportsToCloudwatchLogs;
        }

        @Override
        public final Builder supportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
            return this;
        }

        public final void setSupportsLogExportsToCloudwatchLogs(Boolean supportsLogExportsToCloudwatchLogs) {
            this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs;
        }

        @Override
        public DBEngineVersion build() {
            return new DBEngineVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
