/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directoryservicedata.DirectoryServiceDataClient;
import software.amazon.awssdk.services.directoryservicedata.internal.UserAgentUtils;
import software.amazon.awssdk.services.directoryservicedata.model.GroupSummary;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberResponse;

public class ListGroupsForMemberIterable
implements SdkIterable<ListGroupsForMemberResponse> {
    private final DirectoryServiceDataClient client;
    private final ListGroupsForMemberRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupsForMemberIterable(DirectoryServiceDataClient client, ListGroupsForMemberRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGroupsForMemberResponseFetcher();
    }

    public Iterator<ListGroupsForMemberResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupSummary> groups() {
        Function<ListGroupsForMemberResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGroupsForMemberResponseFetcher
    implements SyncPageFetcher<ListGroupsForMemberResponse> {
        private ListGroupsForMemberResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsForMemberResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupsForMemberResponse nextPage(ListGroupsForMemberResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsForMemberIterable.this.client.listGroupsForMember(ListGroupsForMemberIterable.this.firstRequest);
            }
            return ListGroupsForMemberIterable.this.client.listGroupsForMember((ListGroupsForMemberRequest)((Object)ListGroupsForMemberIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

