/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directoryservicedata.model.DirectoryServiceDataResponse;
import software.amazon.awssdk.services.directoryservicedata.model.UserSummary;
import software.amazon.awssdk.services.directoryservicedata.model.UserSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUsersResponse
extends DirectoryServiceDataResponse
implements ToCopyableBuilder<Builder, ListUsersResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(ListUsersResponse.getter(ListUsersResponse::directoryId)).setter(ListUsersResponse.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUsersResponse.getter(ListUsersResponse::nextToken)).setter(ListUsersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Realm").getter(ListUsersResponse.getter(ListUsersResponse::realm)).setter(ListUsersResponse.setter(Builder::realm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()}).build();
    private static final SdkField<List<UserSummary>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Users").getter(ListUsersResponse.getter(ListUsersResponse::users)).setter(ListUsersResponse.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, NEXT_TOKEN_FIELD, REALM_FIELD, USERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUsersResponse.memberNameToFieldInitializer();
    private final String directoryId;
    private final String nextToken;
    private final String realm;
    private final List<UserSummary> users;

    private ListUsersResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.nextToken = builder.nextToken;
        this.realm = builder.realm;
        this.users = builder.users;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String realm() {
        return this.realm;
    }

    public final boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public final List<UserSummary> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.realm());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResponse)) {
            return false;
        }
        ListUsersResponse other = (ListUsersResponse)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.realm(), other.realm()) && this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users());
    }

    public final String toString() {
        return ToString.builder((String)"ListUsersResponse").add("DirectoryId", (Object)this.directoryId()).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Realm", (Object)this.realm()).add("Users", this.hasUsers() ? this.users() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Realm": {
                return Optional.ofNullable(clazz.cast(this.realm()));
            }
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Realm", REALM_FIELD);
        map.put("Users", USERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUsersResponse, T> g) {
        return obj -> g.apply((ListUsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryServiceDataResponse.BuilderImpl
    implements Builder {
        private String directoryId;
        private String nextToken;
        private String realm;
        private List<UserSummary> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersResponse model) {
            super(model);
            this.directoryId(model.directoryId);
            this.nextToken(model.nextToken);
            this.realm(model.realm);
            this.users(model.users);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRealm() {
            return this.realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final List<UserSummary.Builder> getUsers() {
            List<UserSummary.Builder> result = UserSummaryListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<UserSummary.BuilderImpl> users) {
            this.users = UserSummaryListCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<UserSummary> users) {
            this.users = UserSummaryListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserSummary ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserSummary.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (UserSummary)((UserSummary.Builder)UserSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUsersResponse build() {
            return new ListUsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryServiceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUsersResponse> {
        public Builder directoryId(String var1);

        public Builder nextToken(String var1);

        public Builder realm(String var1);

        public Builder users(Collection<UserSummary> var1);

        public Builder users(UserSummary ... var1);

        public Builder users(Consumer<UserSummary.Builder> ... var1);
    }
}

