/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directoryservicedata.DirectoryServiceDataAsyncClient;
import software.amazon.awssdk.services.directoryservicedata.internal.UserAgentUtils;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.directoryservicedata.model.Member;

public class ListGroupMembersPublisher
implements SdkPublisher<ListGroupMembersResponse> {
    private final DirectoryServiceDataAsyncClient client;
    private final ListGroupMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupMembersPublisher(DirectoryServiceDataAsyncClient client, ListGroupMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupMembersPublisher(DirectoryServiceDataAsyncClient client, ListGroupMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Member> members() {
        Function<ListGroupMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupMembersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGroupMembersResponseFetcher
    implements AsyncPageFetcher<ListGroupMembersResponse> {
        private ListGroupMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupMembersResponse> nextPage(ListGroupMembersResponse previousPage) {
            if (previousPage == null) {
                return ListGroupMembersPublisher.this.client.listGroupMembers(ListGroupMembersPublisher.this.firstRequest);
            }
            return ListGroupMembersPublisher.this.client.listGroupMembers((ListGroupMembersRequest)((Object)ListGroupMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

