/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directoryservicedata.DirectoryServiceDataAsyncClient;
import software.amazon.awssdk.services.directoryservicedata.internal.UserAgentUtils;
import software.amazon.awssdk.services.directoryservicedata.model.GroupSummary;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsResponse;

public class ListGroupsPublisher
implements SdkPublisher<ListGroupsResponse> {
    private final DirectoryServiceDataAsyncClient client;
    private final ListGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupsPublisher(DirectoryServiceDataAsyncClient client, ListGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupsPublisher(DirectoryServiceDataAsyncClient client, ListGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupSummary> groups() {
        Function<ListGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGroupsResponseFetcher
    implements AsyncPageFetcher<ListGroupsResponse> {
        private ListGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupsResponse> nextPage(ListGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsPublisher.this.client.listGroups(ListGroupsPublisher.this.firstRequest);
            }
            return ListGroupsPublisher.this.client.listGroups((ListGroupsRequest)((Object)ListGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

