/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.directoryservicedata.model.AttributeValue;
import software.amazon.awssdk.services.directoryservicedata.model.AttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, User> {
    private static final SdkField<String> DISTINGUISHED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistinguishedName").getter(User.getter(User::distinguishedName)).setter(User.setter(Builder::distinguishedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistinguishedName").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(User.getter(User::emailAddress)).setter(User.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(User.getter(User::enabled)).setter(User.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GivenName").getter(User.getter(User::givenName)).setter(User.setter(Builder::givenName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> OTHER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OtherAttributes").getter(User.getter(User::otherAttributes)).setter(User.setter(Builder::otherAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMAccountName").getter(User.getter(User::samAccountName)).setter(User.setter(Builder::samAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()}).build();
    private static final SdkField<String> SID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SID").getter(User.getter(User::sid)).setter(User.setter(Builder::sid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SID").build()}).build();
    private static final SdkField<String> SURNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Surname").getter(User.getter(User::surname)).setter(User.setter(Builder::surname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()}).build();
    private static final SdkField<String> USER_PRINCIPAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPrincipalName").getter(User.getter(User::userPrincipalName)).setter(User.setter(Builder::userPrincipalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPrincipalName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTINGUISHED_NAME_FIELD, EMAIL_ADDRESS_FIELD, ENABLED_FIELD, GIVEN_NAME_FIELD, OTHER_ATTRIBUTES_FIELD, SAM_ACCOUNT_NAME_FIELD, SID_FIELD, SURNAME_FIELD, USER_PRINCIPAL_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DistinguishedName", DISTINGUISHED_NAME_FIELD);
            this.put("EmailAddress", EMAIL_ADDRESS_FIELD);
            this.put("Enabled", ENABLED_FIELD);
            this.put("GivenName", GIVEN_NAME_FIELD);
            this.put("OtherAttributes", OTHER_ATTRIBUTES_FIELD);
            this.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
            this.put("SID", SID_FIELD);
            this.put("Surname", SURNAME_FIELD);
            this.put("UserPrincipalName", USER_PRINCIPAL_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String distinguishedName;
    private final String emailAddress;
    private final Boolean enabled;
    private final String givenName;
    private final Map<String, AttributeValue> otherAttributes;
    private final String samAccountName;
    private final String sid;
    private final String surname;
    private final String userPrincipalName;

    private User(BuilderImpl builder) {
        this.distinguishedName = builder.distinguishedName;
        this.emailAddress = builder.emailAddress;
        this.enabled = builder.enabled;
        this.givenName = builder.givenName;
        this.otherAttributes = builder.otherAttributes;
        this.samAccountName = builder.samAccountName;
        this.sid = builder.sid;
        this.surname = builder.surname;
        this.userPrincipalName = builder.userPrincipalName;
    }

    public final String distinguishedName() {
        return this.distinguishedName;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String givenName() {
        return this.givenName;
    }

    public final boolean hasOtherAttributes() {
        return this.otherAttributes != null && !(this.otherAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> otherAttributes() {
        return this.otherAttributes;
    }

    public final String samAccountName() {
        return this.samAccountName;
    }

    public final String sid() {
        return this.sid;
    }

    public final String surname() {
        return this.surname;
    }

    public final String userPrincipalName() {
        return this.userPrincipalName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.givenName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOtherAttributes() ? this.otherAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.samAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sid());
        hashCode = 31 * hashCode + Objects.hashCode(this.surname());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPrincipalName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.distinguishedName(), other.distinguishedName()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.givenName(), other.givenName()) && this.hasOtherAttributes() == other.hasOtherAttributes() && Objects.equals(this.otherAttributes(), other.otherAttributes()) && Objects.equals(this.samAccountName(), other.samAccountName()) && Objects.equals(this.sid(), other.sid()) && Objects.equals(this.surname(), other.surname()) && Objects.equals(this.userPrincipalName(), other.userPrincipalName());
    }

    public final String toString() {
        return ToString.builder((String)"User").add("DistinguishedName", (Object)(this.distinguishedName() == null ? null : "*** Sensitive Data Redacted ***")).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Enabled", (Object)this.enabled()).add("GivenName", (Object)(this.givenName() == null ? null : "*** Sensitive Data Redacted ***")).add("OtherAttributes", this.hasOtherAttributes() ? this.otherAttributes() : null).add("SAMAccountName", (Object)this.samAccountName()).add("SID", (Object)this.sid()).add("Surname", (Object)(this.surname() == null ? null : "*** Sensitive Data Redacted ***")).add("UserPrincipalName", (Object)(this.userPrincipalName() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistinguishedName": {
                return Optional.ofNullable(clazz.cast(this.distinguishedName()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "GivenName": {
                return Optional.ofNullable(clazz.cast(this.givenName()));
            }
            case "OtherAttributes": {
                return Optional.ofNullable(clazz.cast(this.otherAttributes()));
            }
            case "SAMAccountName": {
                return Optional.ofNullable(clazz.cast(this.samAccountName()));
            }
            case "SID": {
                return Optional.ofNullable(clazz.cast(this.sid()));
            }
            case "Surname": {
                return Optional.ofNullable(clazz.cast(this.surname()));
            }
            case "UserPrincipalName": {
                return Optional.ofNullable(clazz.cast(this.userPrincipalName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String distinguishedName;
        private String emailAddress;
        private Boolean enabled;
        private String givenName;
        private Map<String, AttributeValue> otherAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String samAccountName;
        private String sid;
        private String surname;
        private String userPrincipalName;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.distinguishedName(model.distinguishedName);
            this.emailAddress(model.emailAddress);
            this.enabled(model.enabled);
            this.givenName(model.givenName);
            this.otherAttributes(model.otherAttributes);
            this.samAccountName(model.samAccountName);
            this.sid(model.sid);
            this.surname(model.surname);
            this.userPrincipalName(model.userPrincipalName);
        }

        public final String getDistinguishedName() {
            return this.distinguishedName;
        }

        public final void setDistinguishedName(String distinguishedName) {
            this.distinguishedName = distinguishedName;
        }

        @Override
        public final Builder distinguishedName(String distinguishedName) {
            this.distinguishedName = distinguishedName;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getGivenName() {
            return this.givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getOtherAttributes() {
            Map<String, AttributeValue.Builder> result = AttributesCopier.copyToBuilder(this.otherAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOtherAttributes(Map<String, AttributeValue.BuilderImpl> otherAttributes) {
            this.otherAttributes = AttributesCopier.copyFromBuilder(otherAttributes);
        }

        @Override
        public final Builder otherAttributes(Map<String, AttributeValue> otherAttributes) {
            this.otherAttributes = AttributesCopier.copy(otherAttributes);
            return this;
        }

        public final String getSamAccountName() {
            return this.samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        public final String getSid() {
            return this.sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public final String getSurname() {
            return this.surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final String getUserPrincipalName() {
            return this.userPrincipalName;
        }

        public final void setUserPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
        }

        @Override
        public final Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            return this;
        }

        public User build() {
            return new User(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, User> {
        public Builder distinguishedName(String var1);

        public Builder emailAddress(String var1);

        public Builder enabled(Boolean var1);

        public Builder givenName(String var1);

        public Builder otherAttributes(Map<String, AttributeValue> var1);

        public Builder samAccountName(String var1);

        public Builder sid(String var1);

        public Builder surname(String var1);

        public Builder userPrincipalName(String var1);
    }
}

