/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.directoryservicedata.model.StringSetAttributeValueCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeValue> {
    private static final SdkField<Boolean> BOOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BOOL").getter(AttributeValue.getter(AttributeValue::bool)).setter(AttributeValue.setter(Builder::bool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BOOL").build()}).build();
    private static final SdkField<Long> N_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("N").getter(AttributeValue.getter(AttributeValue::n)).setter(AttributeValue.setter(Builder::n)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("N").build()}).build();
    private static final SdkField<String> S_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S").getter(AttributeValue.getter(AttributeValue::s)).setter(AttributeValue.setter(Builder::s)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()}).build();
    private static final SdkField<List<String>> SS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SS").getter(AttributeValue.getter(AttributeValue::ss)).setter(AttributeValue.setter(Builder::ss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SS").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOL_FIELD, N_FIELD, S_FIELD, SS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean bool;
    private final Long n;
    private final String s;
    private final List<String> ss;
    private final Type type;

    private AttributeValue(BuilderImpl builder) {
        this.bool = builder.bool;
        this.n = builder.n;
        this.s = builder.s;
        this.ss = builder.ss;
        this.type = builder.type;
    }

    public final Boolean bool() {
        return this.bool;
    }

    public final Long n() {
        return this.n;
    }

    public final String s() {
        return this.s;
    }

    public final boolean hasSs() {
        return this.ss != null && !(this.ss instanceof SdkAutoConstructList);
    }

    public final List<String> ss() {
        return this.ss;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bool());
        hashCode = 31 * hashCode + Objects.hashCode(this.n());
        hashCode = 31 * hashCode + Objects.hashCode(this.s());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSs() ? this.ss() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue)obj;
        return Objects.equals(this.bool(), other.bool()) && Objects.equals(this.n(), other.n()) && Objects.equals(this.s(), other.s()) && this.hasSs() == other.hasSs() && Objects.equals(this.ss(), other.ss());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeValue").add("BOOL", (Object)(this.bool() == null ? null : "*** Sensitive Data Redacted ***")).add("N", (Object)(this.n() == null ? null : "*** Sensitive Data Redacted ***")).add("S", (Object)(this.s() == null ? null : "*** Sensitive Data Redacted ***")).add("SS", (Object)(this.ss() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BOOL": {
                return Optional.ofNullable(clazz.cast(this.bool()));
            }
            case "N": {
                return Optional.ofNullable(clazz.cast(this.n()));
            }
            case "S": {
                return Optional.ofNullable(clazz.cast(this.s()));
            }
            case "SS": {
                return Optional.ofNullable(clazz.cast(this.ss()));
            }
        }
        return Optional.empty();
    }

    public static AttributeValue fromBool(Boolean bool) {
        return (AttributeValue)AttributeValue.builder().bool(bool).build();
    }

    public static AttributeValue fromN(Long n) {
        return (AttributeValue)AttributeValue.builder().n(n).build();
    }

    public static AttributeValue fromS(String s) {
        return (AttributeValue)AttributeValue.builder().s(s).build();
    }

    public static AttributeValue fromSs(List<String> ss) {
        return (AttributeValue)AttributeValue.builder().ss(ss).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeValue, T> g) {
        return obj -> g.apply((AttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BOOL,
        N,
        S,
        SS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Boolean bool;
        private Long n;
        private String s;
        private List<String> ss = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            this.bool(model.bool);
            this.n(model.n);
            this.s(model.s);
            this.ss(model.ss);
        }

        public final Boolean getBool() {
            return this.bool;
        }

        public final void setBool(Boolean bool) {
            Boolean oldValue = this.bool;
            this.bool = bool;
            this.handleUnionValueChange(Type.BOOL, oldValue, this.bool);
        }

        @Override
        public final Builder bool(Boolean bool) {
            Boolean oldValue = this.bool;
            this.bool = bool;
            this.handleUnionValueChange(Type.BOOL, oldValue, this.bool);
            return this;
        }

        public final Long getN() {
            return this.n;
        }

        public final void setN(Long n) {
            Long oldValue = this.n;
            this.n = n;
            this.handleUnionValueChange(Type.N, oldValue, this.n);
        }

        @Override
        public final Builder n(Long n) {
            Long oldValue = this.n;
            this.n = n;
            this.handleUnionValueChange(Type.N, oldValue, this.n);
            return this;
        }

        public final String getS() {
            return this.s;
        }

        public final void setS(String s) {
            String oldValue = this.s;
            this.s = s;
            this.handleUnionValueChange(Type.S, oldValue, this.s);
        }

        @Override
        public final Builder s(String s) {
            String oldValue = this.s;
            this.s = s;
            this.handleUnionValueChange(Type.S, oldValue, this.s);
            return this;
        }

        public final Collection<String> getSs() {
            if (this.ss instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ss;
        }

        public final void setSs(Collection<String> ss) {
            List<String> oldValue = this.ss;
            this.ss = StringSetAttributeValueCopier.copy(ss);
            this.handleUnionValueChange(Type.SS, oldValue, this.ss);
        }

        @Override
        public final Builder ss(Collection<String> ss) {
            List<String> oldValue = this.ss;
            this.ss = StringSetAttributeValueCopier.copy(ss);
            this.handleUnionValueChange(Type.SS, oldValue, this.ss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ss(String ... ss) {
            this.ss(Arrays.asList(ss));
            return this;
        }

        public AttributeValue build() {
            return new AttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeValue> {
        public Builder bool(Boolean var1);

        public Builder n(Long var1);

        public Builder s(String var1);

        public Builder ss(Collection<String> var1);

        public Builder ss(String ... var1);
    }
}

