/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * OS version that the directory needs to be updated to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OSUpdateSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<OSUpdateSettings.Builder, OSUpdateSettings> {
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OSVersion").getter(getter(OSUpdateSettings::osVersionAsString)).setter(setter(Builder::osVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OSVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OS_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String osVersion;

    private OSUpdateSettings(BuilderImpl builder) {
        this.osVersion = builder.osVersion;
    }

    /**
     * <p>
     * OS version that the directory needs to be updated to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osVersion} will
     * return {@link OSVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osVersionAsString}.
     * </p>
     * 
     * @return OS version that the directory needs to be updated to.
     * @see OSVersion
     */
    public final OSVersion osVersion() {
        return OSVersion.fromValue(osVersion);
    }

    /**
     * <p>
     * OS version that the directory needs to be updated to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osVersion} will
     * return {@link OSVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osVersionAsString}.
     * </p>
     * 
     * @return OS version that the directory needs to be updated to.
     * @see OSVersion
     */
    public final String osVersionAsString() {
        return osVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(osVersionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OSUpdateSettings)) {
            return false;
        }
        OSUpdateSettings other = (OSUpdateSettings) obj;
        return Objects.equals(osVersionAsString(), other.osVersionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OSUpdateSettings").add("OSVersion", osVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OSVersion":
            return Optional.ofNullable(clazz.cast(osVersionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OSUpdateSettings, T> g) {
        return obj -> g.apply((OSUpdateSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OSUpdateSettings> {
        /**
         * <p>
         * OS version that the directory needs to be updated to.
         * </p>
         * 
         * @param osVersion
         *        OS version that the directory needs to be updated to.
         * @see OSVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OSVersion
         */
        Builder osVersion(String osVersion);

        /**
         * <p>
         * OS version that the directory needs to be updated to.
         * </p>
         * 
         * @param osVersion
         *        OS version that the directory needs to be updated to.
         * @see OSVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OSVersion
         */
        Builder osVersion(OSVersion osVersion);
    }

    static final class BuilderImpl implements Builder {
        private String osVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(OSUpdateSettings model) {
            osVersion(model.osVersion);
        }

        public final String getOsVersion() {
            return osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        @Override
        public final Builder osVersion(OSVersion osVersion) {
            this.osVersion(osVersion == null ? null : osVersion.toString());
            return this;
        }

        @Override
        public OSUpdateSettings build() {
            return new OSUpdateSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
