/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse;

public class DescribeDomainControllersPublisher
implements SdkPublisher<DescribeDomainControllersResponse> {
    private final DirectoryAsyncClient client;
    private final DescribeDomainControllersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDomainControllersPublisher(DirectoryAsyncClient client, DescribeDomainControllersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDomainControllersPublisher(DirectoryAsyncClient client, DescribeDomainControllersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDomainControllersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDomainControllersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeDomainControllersResponseFetcher
    implements AsyncPageFetcher<DescribeDomainControllersResponse> {
        private DescribeDomainControllersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDomainControllersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDomainControllersResponse> nextPage(DescribeDomainControllersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDomainControllersPublisher.this.client.describeDomainControllers(DescribeDomainControllersPublisher.this.firstRequest);
            }
            return DescribeDomainControllersPublisher.this.client.describeDomainControllers((DescribeDomainControllersRequest)((Object)DescribeDomainControllersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

