/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse;
import software.amazon.awssdk.services.directory.model.SchemaExtensionInfo;

public class ListSchemaExtensionsPublisher
implements SdkPublisher<ListSchemaExtensionsResponse> {
    private final DirectoryAsyncClient client;
    private final ListSchemaExtensionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSchemaExtensionsPublisher(DirectoryAsyncClient client, ListSchemaExtensionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSchemaExtensionsPublisher(DirectoryAsyncClient client, ListSchemaExtensionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSchemaExtensionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSchemaExtensionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SchemaExtensionInfo> schemaExtensionsInfo() {
        Function<ListSchemaExtensionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemaExtensionsInfo() != null) {
                return response.schemaExtensionsInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSchemaExtensionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSchemaExtensionsResponseFetcher
    implements AsyncPageFetcher<ListSchemaExtensionsResponse> {
        private ListSchemaExtensionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSchemaExtensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSchemaExtensionsResponse> nextPage(ListSchemaExtensionsResponse previousPage) {
            if (previousPage == null) {
                return ListSchemaExtensionsPublisher.this.client.listSchemaExtensions(ListSchemaExtensionsPublisher.this.firstRequest);
            }
            return ListSchemaExtensionsPublisher.this.client.listSchemaExtensions((ListSchemaExtensionsRequest)((Object)ListSchemaExtensionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

