/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse;
import software.amazon.awssdk.services.directory.model.SchemaExtensionInfo;

public class ListSchemaExtensionsIterable
implements SdkIterable<ListSchemaExtensionsResponse> {
    private final DirectoryClient client;
    private final ListSchemaExtensionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSchemaExtensionsIterable(DirectoryClient client, ListSchemaExtensionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSchemaExtensionsResponseFetcher();
    }

    public Iterator<ListSchemaExtensionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SchemaExtensionInfo> schemaExtensionsInfo() {
        Function<ListSchemaExtensionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemaExtensionsInfo() != null) {
                return response.schemaExtensionsInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSchemaExtensionsResponseFetcher
    implements SyncPageFetcher<ListSchemaExtensionsResponse> {
        private ListSchemaExtensionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSchemaExtensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSchemaExtensionsResponse nextPage(ListSchemaExtensionsResponse previousPage) {
            if (previousPage == null) {
                return ListSchemaExtensionsIterable.this.client.listSchemaExtensions(ListSchemaExtensionsIterable.this.firstRequest);
            }
            return ListSchemaExtensionsIterable.this.client.listSchemaExtensions((ListSchemaExtensionsRequest)((Object)ListSchemaExtensionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

