/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.SelectiveAuth;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrustRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, UpdateTrustRequest> {
    private static final SdkField<String> TRUST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustId").getter(UpdateTrustRequest.getter(UpdateTrustRequest::trustId)).setter(UpdateTrustRequest.setter(Builder::trustId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustId").build()}).build();
    private static final SdkField<String> SELECTIVE_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectiveAuth").getter(UpdateTrustRequest.getter(UpdateTrustRequest::selectiveAuthAsString)).setter(UpdateTrustRequest.setter(Builder::selectiveAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectiveAuth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_ID_FIELD, SELECTIVE_AUTH_FIELD));
    private final String trustId;
    private final String selectiveAuth;

    private UpdateTrustRequest(BuilderImpl builder) {
        super(builder);
        this.trustId = builder.trustId;
        this.selectiveAuth = builder.selectiveAuth;
    }

    public final String trustId() {
        return this.trustId;
    }

    public final SelectiveAuth selectiveAuth() {
        return SelectiveAuth.fromValue(this.selectiveAuth);
    }

    public final String selectiveAuthAsString() {
        return this.selectiveAuth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectiveAuthAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrustRequest)) {
            return false;
        }
        UpdateTrustRequest other = (UpdateTrustRequest)((Object)obj);
        return Objects.equals(this.trustId(), other.trustId()) && Objects.equals(this.selectiveAuthAsString(), other.selectiveAuthAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTrustRequest").add("TrustId", (Object)this.trustId()).add("SelectiveAuth", (Object)this.selectiveAuthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustId": {
                return Optional.ofNullable(clazz.cast(this.trustId()));
            }
            case "SelectiveAuth": {
                return Optional.ofNullable(clazz.cast(this.selectiveAuthAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrustRequest, T> g) {
        return obj -> g.apply((UpdateTrustRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String trustId;
        private String selectiveAuth;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrustRequest model) {
            super(model);
            this.trustId(model.trustId);
            this.selectiveAuth(model.selectiveAuth);
        }

        public final String getTrustId() {
            return this.trustId;
        }

        @Override
        public final Builder trustId(String trustId) {
            this.trustId = trustId;
            return this;
        }

        public final void setTrustId(String trustId) {
            this.trustId = trustId;
        }

        public final String getSelectiveAuth() {
            return this.selectiveAuth;
        }

        @Override
        public final Builder selectiveAuth(String selectiveAuth) {
            this.selectiveAuth = selectiveAuth;
            return this;
        }

        @Override
        public final Builder selectiveAuth(SelectiveAuth selectiveAuth) {
            this.selectiveAuth(selectiveAuth == null ? null : selectiveAuth.toString());
            return this;
        }

        public final void setSelectiveAuth(String selectiveAuth) {
            this.selectiveAuth = selectiveAuth;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrustRequest build() {
            return new UpdateTrustRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTrustRequest> {
        public Builder trustId(String var1);

        public Builder selectiveAuth(String var1);

        public Builder selectiveAuth(SelectiveAuth var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

