/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.LDAPSStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LDAPSSettingInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LDAPSSettingInfo> {
    private static final SdkField<String> LDAPS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LDAPSStatus").getter(LDAPSSettingInfo.getter(LDAPSSettingInfo::ldapsStatusAsString)).setter(LDAPSSettingInfo.setter(Builder::ldapsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LDAPSStatus").build()}).build();
    private static final SdkField<String> LDAPS_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LDAPSStatusReason").getter(LDAPSSettingInfo.getter(LDAPSSettingInfo::ldapsStatusReason)).setter(LDAPSSettingInfo.setter(Builder::ldapsStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LDAPSStatusReason").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedDateTime").getter(LDAPSSettingInfo.getter(LDAPSSettingInfo::lastUpdatedDateTime)).setter(LDAPSSettingInfo.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LDAPS_STATUS_FIELD, LDAPS_STATUS_REASON_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ldapsStatus;
    private final String ldapsStatusReason;
    private final Instant lastUpdatedDateTime;

    private LDAPSSettingInfo(BuilderImpl builder) {
        this.ldapsStatus = builder.ldapsStatus;
        this.ldapsStatusReason = builder.ldapsStatusReason;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final LDAPSStatus ldapsStatus() {
        return LDAPSStatus.fromValue(this.ldapsStatus);
    }

    public final String ldapsStatusAsString() {
        return this.ldapsStatus;
    }

    public final String ldapsStatusReason() {
        return this.ldapsStatusReason;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ldapsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ldapsStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LDAPSSettingInfo)) {
            return false;
        }
        LDAPSSettingInfo other = (LDAPSSettingInfo)obj;
        return Objects.equals(this.ldapsStatusAsString(), other.ldapsStatusAsString()) && Objects.equals(this.ldapsStatusReason(), other.ldapsStatusReason()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"LDAPSSettingInfo").add("LDAPSStatus", (Object)this.ldapsStatusAsString()).add("LDAPSStatusReason", (Object)this.ldapsStatusReason()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LDAPSStatus": {
                return Optional.ofNullable(clazz.cast(this.ldapsStatusAsString()));
            }
            case "LDAPSStatusReason": {
                return Optional.ofNullable(clazz.cast(this.ldapsStatusReason()));
            }
            case "LastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LDAPSSettingInfo, T> g) {
        return obj -> g.apply((LDAPSSettingInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ldapsStatus;
        private String ldapsStatusReason;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LDAPSSettingInfo model) {
            this.ldapsStatus(model.ldapsStatus);
            this.ldapsStatusReason(model.ldapsStatusReason);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getLdapsStatus() {
            return this.ldapsStatus;
        }

        @Override
        public final Builder ldapsStatus(String ldapsStatus) {
            this.ldapsStatus = ldapsStatus;
            return this;
        }

        @Override
        public final Builder ldapsStatus(LDAPSStatus ldapsStatus) {
            this.ldapsStatus(ldapsStatus == null ? null : ldapsStatus.toString());
            return this;
        }

        public final void setLdapsStatus(String ldapsStatus) {
            this.ldapsStatus = ldapsStatus;
        }

        public final String getLdapsStatusReason() {
            return this.ldapsStatusReason;
        }

        @Override
        public final Builder ldapsStatusReason(String ldapsStatusReason) {
            this.ldapsStatusReason = ldapsStatusReason;
            return this;
        }

        public final void setLdapsStatusReason(String ldapsStatusReason) {
            this.ldapsStatusReason = ldapsStatusReason;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public LDAPSSettingInfo build() {
            return new LDAPSSettingInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LDAPSSettingInfo> {
        public Builder ldapsStatus(String var1);

        public Builder ldapsStatus(LDAPSStatus var1);

        public Builder ldapsStatusReason(String var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

