/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains general information about the LDAPS settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LDAPSSettingInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<LDAPSSettingInfo.Builder, LDAPSSettingInfo> {
    private static final SdkField<String> LDAPS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LDAPSSettingInfo::ldapsStatusAsString)).setter(setter(Builder::ldapsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LDAPSStatus").build()).build();

    private static final SdkField<String> LDAPS_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LDAPSSettingInfo::ldapsStatusReason)).setter(setter(Builder::ldapsStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LDAPSStatusReason").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LDAPSSettingInfo::lastUpdatedDateTime)).setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LDAPS_STATUS_FIELD,
            LDAPS_STATUS_REASON_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ldapsStatus;

    private final String ldapsStatusReason;

    private final Instant lastUpdatedDateTime;

    private LDAPSSettingInfo(BuilderImpl builder) {
        this.ldapsStatus = builder.ldapsStatus;
        this.ldapsStatusReason = builder.ldapsStatusReason;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The state of the LDAPS settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ldapsStatus} will
     * return {@link LDAPSStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ldapsStatusAsString}.
     * </p>
     * 
     * @return The state of the LDAPS settings.
     * @see LDAPSStatus
     */
    public LDAPSStatus ldapsStatus() {
        return LDAPSStatus.fromValue(ldapsStatus);
    }

    /**
     * <p>
     * The state of the LDAPS settings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ldapsStatus} will
     * return {@link LDAPSStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ldapsStatusAsString}.
     * </p>
     * 
     * @return The state of the LDAPS settings.
     * @see LDAPSStatus
     */
    public String ldapsStatusAsString() {
        return ldapsStatus;
    }

    /**
     * <p>
     * Describes a state change for LDAPS.
     * </p>
     * 
     * @return Describes a state change for LDAPS.
     */
    public String ldapsStatusReason() {
        return ldapsStatusReason;
    }

    /**
     * <p>
     * The date and time when the LDAPS settings were last updated.
     * </p>
     * 
     * @return The date and time when the LDAPS settings were last updated.
     */
    public Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ldapsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ldapsStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LDAPSSettingInfo)) {
            return false;
        }
        LDAPSSettingInfo other = (LDAPSSettingInfo) obj;
        return Objects.equals(ldapsStatusAsString(), other.ldapsStatusAsString())
                && Objects.equals(ldapsStatusReason(), other.ldapsStatusReason())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LDAPSSettingInfo").add("LDAPSStatus", ldapsStatusAsString())
                .add("LDAPSStatusReason", ldapsStatusReason()).add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LDAPSStatus":
            return Optional.ofNullable(clazz.cast(ldapsStatusAsString()));
        case "LDAPSStatusReason":
            return Optional.ofNullable(clazz.cast(ldapsStatusReason()));
        case "LastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LDAPSSettingInfo, T> g) {
        return obj -> g.apply((LDAPSSettingInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LDAPSSettingInfo> {
        /**
         * <p>
         * The state of the LDAPS settings.
         * </p>
         * 
         * @param ldapsStatus
         *        The state of the LDAPS settings.
         * @see LDAPSStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LDAPSStatus
         */
        Builder ldapsStatus(String ldapsStatus);

        /**
         * <p>
         * The state of the LDAPS settings.
         * </p>
         * 
         * @param ldapsStatus
         *        The state of the LDAPS settings.
         * @see LDAPSStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LDAPSStatus
         */
        Builder ldapsStatus(LDAPSStatus ldapsStatus);

        /**
         * <p>
         * Describes a state change for LDAPS.
         * </p>
         * 
         * @param ldapsStatusReason
         *        Describes a state change for LDAPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ldapsStatusReason(String ldapsStatusReason);

        /**
         * <p>
         * The date and time when the LDAPS settings were last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time when the LDAPS settings were last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String ldapsStatus;

        private String ldapsStatusReason;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LDAPSSettingInfo model) {
            ldapsStatus(model.ldapsStatus);
            ldapsStatusReason(model.ldapsStatusReason);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getLdapsStatusAsString() {
            return ldapsStatus;
        }

        @Override
        public final Builder ldapsStatus(String ldapsStatus) {
            this.ldapsStatus = ldapsStatus;
            return this;
        }

        @Override
        public final Builder ldapsStatus(LDAPSStatus ldapsStatus) {
            this.ldapsStatus(ldapsStatus == null ? null : ldapsStatus.toString());
            return this;
        }

        public final void setLdapsStatus(String ldapsStatus) {
            this.ldapsStatus = ldapsStatus;
        }

        public final String getLdapsStatusReason() {
            return ldapsStatusReason;
        }

        @Override
        public final Builder ldapsStatusReason(String ldapsStatusReason) {
            this.ldapsStatusReason = ldapsStatusReason;
            return this;
        }

        public final void setLdapsStatusReason(String ldapsStatusReason) {
            this.ldapsStatusReason = ldapsStatusReason;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public LDAPSSettingInfo build() {
            return new LDAPSSettingInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
