/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the domain controllers for a specified directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainController implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainController.Builder, DomainController> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainController::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> DOMAIN_CONTROLLER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainController::domainControllerId)).setter(setter(Builder::domainControllerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControllerId").build())
            .build();

    private static final SdkField<String> DNS_IP_ADDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainController::dnsIpAddr)).setter(setter(Builder::dnsIpAddr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIpAddr").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainController::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainController::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainController::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainController::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainController::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DomainController::launchTime)).setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()).build();

    private static final SdkField<Instant> STATUS_LAST_UPDATED_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).getter(getter(DomainController::statusLastUpdatedDateTime))
            .setter(setter(Builder::statusLastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusLastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            DOMAIN_CONTROLLER_ID_FIELD, DNS_IP_ADDR_FIELD, VPC_ID_FIELD, SUBNET_ID_FIELD, AVAILABILITY_ZONE_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD, LAUNCH_TIME_FIELD, STATUS_LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String directoryId;

    private final String domainControllerId;

    private final String dnsIpAddr;

    private final String vpcId;

    private final String subnetId;

    private final String availabilityZone;

    private final String status;

    private final String statusReason;

    private final Instant launchTime;

    private final Instant statusLastUpdatedDateTime;

    private DomainController(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.domainControllerId = builder.domainControllerId;
        this.dnsIpAddr = builder.dnsIpAddr;
        this.vpcId = builder.vpcId;
        this.subnetId = builder.subnetId;
        this.availabilityZone = builder.availabilityZone;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.launchTime = builder.launchTime;
        this.statusLastUpdatedDateTime = builder.statusLastUpdatedDateTime;
    }

    /**
     * <p>
     * Identifier of the directory where the domain controller resides.
     * </p>
     * 
     * @return Identifier of the directory where the domain controller resides.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * Identifies a specific domain controller in the directory.
     * </p>
     * 
     * @return Identifies a specific domain controller in the directory.
     */
    public String domainControllerId() {
        return domainControllerId;
    }

    /**
     * <p>
     * The IP address of the domain controller.
     * </p>
     * 
     * @return The IP address of the domain controller.
     */
    public String dnsIpAddr() {
        return dnsIpAddr;
    }

    /**
     * <p>
     * The identifier of the VPC that contains the domain controller.
     * </p>
     * 
     * @return The identifier of the VPC that contains the domain controller.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Identifier of the subnet in the VPC that contains the domain controller.
     * </p>
     * 
     * @return Identifier of the subnet in the VPC that contains the domain controller.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The Availability Zone where the domain controller is located.
     * </p>
     * 
     * @return The Availability Zone where the domain controller is located.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The status of the domain controller.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainControllerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the domain controller.
     * @see DomainControllerStatus
     */
    public DomainControllerStatus status() {
        return DomainControllerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the domain controller.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainControllerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the domain controller.
     * @see DomainControllerStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the domain controller state.
     * </p>
     * 
     * @return A description of the domain controller state.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Specifies when the domain controller was created.
     * </p>
     * 
     * @return Specifies when the domain controller was created.
     */
    public Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * The date and time that the status was last updated.
     * </p>
     * 
     * @return The date and time that the status was last updated.
     */
    public Instant statusLastUpdatedDateTime() {
        return statusLastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(domainControllerId());
        hashCode = 31 * hashCode + Objects.hashCode(dnsIpAddr());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusLastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainController)) {
            return false;
        }
        DomainController other = (DomainController) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(domainControllerId(), other.domainControllerId())
                && Objects.equals(dnsIpAddr(), other.dnsIpAddr()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(launchTime(), other.launchTime())
                && Objects.equals(statusLastUpdatedDateTime(), other.statusLastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DomainController").add("DirectoryId", directoryId())
                .add("DomainControllerId", domainControllerId()).add("DnsIpAddr", dnsIpAddr()).add("VpcId", vpcId())
                .add("SubnetId", subnetId()).add("AvailabilityZone", availabilityZone()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("LaunchTime", launchTime())
                .add("StatusLastUpdatedDateTime", statusLastUpdatedDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "DomainControllerId":
            return Optional.ofNullable(clazz.cast(domainControllerId()));
        case "DnsIpAddr":
            return Optional.ofNullable(clazz.cast(dnsIpAddr()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "LaunchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "StatusLastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(statusLastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainController, T> g) {
        return obj -> g.apply((DomainController) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainController> {
        /**
         * <p>
         * Identifier of the directory where the domain controller resides.
         * </p>
         * 
         * @param directoryId
         *        Identifier of the directory where the domain controller resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * Identifies a specific domain controller in the directory.
         * </p>
         * 
         * @param domainControllerId
         *        Identifies a specific domain controller in the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainControllerId(String domainControllerId);

        /**
         * <p>
         * The IP address of the domain controller.
         * </p>
         * 
         * @param dnsIpAddr
         *        The IP address of the domain controller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIpAddr(String dnsIpAddr);

        /**
         * <p>
         * The identifier of the VPC that contains the domain controller.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC that contains the domain controller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Identifier of the subnet in the VPC that contains the domain controller.
         * </p>
         * 
         * @param subnetId
         *        Identifier of the subnet in the VPC that contains the domain controller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The Availability Zone where the domain controller is located.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the domain controller is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The status of the domain controller.
         * </p>
         * 
         * @param status
         *        The status of the domain controller.
         * @see DomainControllerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainControllerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the domain controller.
         * </p>
         * 
         * @param status
         *        The status of the domain controller.
         * @see DomainControllerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainControllerStatus
         */
        Builder status(DomainControllerStatus status);

        /**
         * <p>
         * A description of the domain controller state.
         * </p>
         * 
         * @param statusReason
         *        A description of the domain controller state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Specifies when the domain controller was created.
         * </p>
         * 
         * @param launchTime
         *        Specifies when the domain controller was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * The date and time that the status was last updated.
         * </p>
         * 
         * @param statusLastUpdatedDateTime
         *        The date and time that the status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusLastUpdatedDateTime(Instant statusLastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String directoryId;

        private String domainControllerId;

        private String dnsIpAddr;

        private String vpcId;

        private String subnetId;

        private String availabilityZone;

        private String status;

        private String statusReason;

        private Instant launchTime;

        private Instant statusLastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainController model) {
            directoryId(model.directoryId);
            domainControllerId(model.domainControllerId);
            dnsIpAddr(model.dnsIpAddr);
            vpcId(model.vpcId);
            subnetId(model.subnetId);
            availabilityZone(model.availabilityZone);
            status(model.status);
            statusReason(model.statusReason);
            launchTime(model.launchTime);
            statusLastUpdatedDateTime(model.statusLastUpdatedDateTime);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getDomainControllerId() {
            return domainControllerId;
        }

        @Override
        public final Builder domainControllerId(String domainControllerId) {
            this.domainControllerId = domainControllerId;
            return this;
        }

        public final void setDomainControllerId(String domainControllerId) {
            this.domainControllerId = domainControllerId;
        }

        public final String getDnsIpAddr() {
            return dnsIpAddr;
        }

        @Override
        public final Builder dnsIpAddr(String dnsIpAddr) {
            this.dnsIpAddr = dnsIpAddr;
            return this;
        }

        public final void setDnsIpAddr(String dnsIpAddr) {
            this.dnsIpAddr = dnsIpAddr;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainControllerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        public final Instant getStatusLastUpdatedDateTime() {
            return statusLastUpdatedDateTime;
        }

        @Override
        public final Builder statusLastUpdatedDateTime(Instant statusLastUpdatedDateTime) {
            this.statusLastUpdatedDateTime = statusLastUpdatedDateTime;
            return this;
        }

        public final void setStatusLastUpdatedDateTime(Instant statusLastUpdatedDateTime) {
            this.statusLastUpdatedDateTime = statusLastUpdatedDateTime;
        }

        @Override
        public DomainController build() {
            return new DomainController(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
