/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InterconnectState {
    REQUESTED("requested"),
    PENDING("pending"),
    AVAILABLE("available"),
    DOWN("down"),
    DELETING("deleting"),
    DELETED("deleted"),
    UNKNOWN("unknown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InterconnectState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InterconnectState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InterconnectState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InterconnectState> knownValues() {
        return Stream.of(InterconnectState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

