/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptDirectConnectGatewayAssociationProposalRequest extends DirectConnectRequest
        implements
        ToCopyableBuilder<AcceptDirectConnectGatewayAssociationProposalRequest.Builder, AcceptDirectConnectGatewayAssociationProposalRequest> {
    private static final SdkField<String> DIRECT_CONNECT_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("directConnectGatewayId")
            .getter(getter(AcceptDirectConnectGatewayAssociationProposalRequest::directConnectGatewayId))
            .setter(setter(Builder::directConnectGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayId").build())
            .build();

    private static final SdkField<String> PROPOSAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("proposalId").getter(getter(AcceptDirectConnectGatewayAssociationProposalRequest::proposalId))
            .setter(setter(Builder::proposalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposalId").build()).build();

    private static final SdkField<String> ASSOCIATED_GATEWAY_OWNER_ACCOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("associatedGatewayOwnerAccount")
            .getter(getter(AcceptDirectConnectGatewayAssociationProposalRequest::associatedGatewayOwnerAccount))
            .setter(setter(Builder::associatedGatewayOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedGatewayOwnerAccount")
                    .build()).build();

    private static final SdkField<List<RouteFilterPrefix>> OVERRIDE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .memberName("overrideAllowedPrefixesToDirectConnectGateway")
            .getter(getter(AcceptDirectConnectGatewayAssociationProposalRequest::overrideAllowedPrefixesToDirectConnectGateway))
            .setter(setter(Builder::overrideAllowedPrefixesToDirectConnectGateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("overrideAllowedPrefixesToDirectConnectGateway").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DIRECT_CONNECT_GATEWAY_ID_FIELD, PROPOSAL_ID_FIELD, ASSOCIATED_GATEWAY_OWNER_ACCOUNT_FIELD,
            OVERRIDE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directConnectGatewayId;

    private final String proposalId;

    private final String associatedGatewayOwnerAccount;

    private final List<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway;

    private AcceptDirectConnectGatewayAssociationProposalRequest(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayId = builder.directConnectGatewayId;
        this.proposalId = builder.proposalId;
        this.associatedGatewayOwnerAccount = builder.associatedGatewayOwnerAccount;
        this.overrideAllowedPrefixesToDirectConnectGateway = builder.overrideAllowedPrefixesToDirectConnectGateway;
    }

    /**
     * <p>
     * The ID of the Direct Connect gateway.
     * </p>
     * 
     * @return The ID of the Direct Connect gateway.
     */
    public final String directConnectGatewayId() {
        return directConnectGatewayId;
    }

    /**
     * <p>
     * The ID of the request proposal.
     * </p>
     * 
     * @return The ID of the request proposal.
     */
    public final String proposalId() {
        return proposalId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the virtual private gateway or transit gateway.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the virtual private gateway or transit gateway.
     */
    public final String associatedGatewayOwnerAccount() {
        return associatedGatewayOwnerAccount;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * OverrideAllowedPrefixesToDirectConnectGateway property. This DOES NOT check that the value is non-empty (for
     * which, you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never
     * return a null collection or map, but you may need to differentiate between the service returning nothing (or
     * null) and the service returning an empty collection or map. For requests, this returns true if a value for the
     * property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOverrideAllowedPrefixesToDirectConnectGateway() {
        return overrideAllowedPrefixesToDirectConnectGateway != null
                && !(overrideAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.
     * </p>
     * <p>
     * For information about how to set the prefixes, see <a href=
     * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
     * >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasOverrideAllowedPrefixesToDirectConnectGateway} method.
     * </p>
     * 
     * @return Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
     *         <p>
     *         For information about how to set the prefixes, see <a href=
     *         "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
     *         >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
     */
    public final List<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway() {
        return overrideAllowedPrefixesToDirectConnectGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(proposalId());
        hashCode = 31 * hashCode + Objects.hashCode(associatedGatewayOwnerAccount());
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasOverrideAllowedPrefixesToDirectConnectGateway() ? overrideAllowedPrefixesToDirectConnectGateway()
                                : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptDirectConnectGatewayAssociationProposalRequest)) {
            return false;
        }
        AcceptDirectConnectGatewayAssociationProposalRequest other = (AcceptDirectConnectGatewayAssociationProposalRequest) obj;
        return Objects.equals(directConnectGatewayId(), other.directConnectGatewayId())
                && Objects.equals(proposalId(), other.proposalId())
                && Objects.equals(associatedGatewayOwnerAccount(), other.associatedGatewayOwnerAccount())
                && hasOverrideAllowedPrefixesToDirectConnectGateway() == other.hasOverrideAllowedPrefixesToDirectConnectGateway()
                && Objects.equals(overrideAllowedPrefixesToDirectConnectGateway(),
                        other.overrideAllowedPrefixesToDirectConnectGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AcceptDirectConnectGatewayAssociationProposalRequest")
                .add("DirectConnectGatewayId", directConnectGatewayId())
                .add("ProposalId", proposalId())
                .add("AssociatedGatewayOwnerAccount", associatedGatewayOwnerAccount())
                .add("OverrideAllowedPrefixesToDirectConnectGateway",
                        hasOverrideAllowedPrefixesToDirectConnectGateway() ? overrideAllowedPrefixesToDirectConnectGateway()
                                : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayId":
            return Optional.ofNullable(clazz.cast(directConnectGatewayId()));
        case "proposalId":
            return Optional.ofNullable(clazz.cast(proposalId()));
        case "associatedGatewayOwnerAccount":
            return Optional.ofNullable(clazz.cast(associatedGatewayOwnerAccount()));
        case "overrideAllowedPrefixesToDirectConnectGateway":
            return Optional.ofNullable(clazz.cast(overrideAllowedPrefixesToDirectConnectGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("directConnectGatewayId", DIRECT_CONNECT_GATEWAY_ID_FIELD);
        map.put("proposalId", PROPOSAL_ID_FIELD);
        map.put("associatedGatewayOwnerAccount", ASSOCIATED_GATEWAY_OWNER_ACCOUNT_FIELD);
        map.put("overrideAllowedPrefixesToDirectConnectGateway", OVERRIDE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceptDirectConnectGatewayAssociationProposalRequest, T> g) {
        return obj -> g.apply((AcceptDirectConnectGatewayAssociationProposalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptDirectConnectGatewayAssociationProposalRequest> {
        /**
         * <p>
         * The ID of the Direct Connect gateway.
         * </p>
         * 
         * @param directConnectGatewayId
         *        The ID of the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayId(String directConnectGatewayId);

        /**
         * <p>
         * The ID of the request proposal.
         * </p>
         * 
         * @param proposalId
         *        The ID of the request proposal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposalId(String proposalId);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the virtual private gateway or transit gateway.
         * </p>
         * 
         * @param associatedGatewayOwnerAccount
         *        The ID of the Amazon Web Services account that owns the virtual private gateway or transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedGatewayOwnerAccount(String associatedGatewayOwnerAccount);

        /**
         * <p>
         * Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.
         * </p>
         * <p>
         * For information about how to set the prefixes, see <a href=
         * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         * >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
         * </p>
         * 
         * @param overrideAllowedPrefixesToDirectConnectGateway
         *        Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
         *        <p>
         *        For information about how to set the prefixes, see <a href=
         *        "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         *        >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.
         * </p>
         * <p>
         * For information about how to set the prefixes, see <a href=
         * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         * >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
         * </p>
         * 
         * @param overrideAllowedPrefixesToDirectConnectGateway
         *        Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.</p>
         *        <p>
         *        For information about how to set the prefixes, see <a href=
         *        "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         *        >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix... overrideAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * Overrides the Amazon VPC prefixes advertised to the Direct Connect gateway.
         * </p>
         * <p>
         * For information about how to set the prefixes, see <a href=
         * "https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes"
         * >Allowed Prefixes</a> in the <i>Direct Connect User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #overrideAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)}.
         * 
         * @param overrideAllowedPrefixesToDirectConnectGateway
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.RouteFilterPrefix.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideAllowedPrefixesToDirectConnectGateway(java.util.Collection<RouteFilterPrefix>)
         */
        Builder overrideAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... overrideAllowedPrefixesToDirectConnectGateway);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String directConnectGatewayId;

        private String proposalId;

        private String associatedGatewayOwnerAccount;

        private List<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptDirectConnectGatewayAssociationProposalRequest model) {
            super(model);
            directConnectGatewayId(model.directConnectGatewayId);
            proposalId(model.proposalId);
            associatedGatewayOwnerAccount(model.associatedGatewayOwnerAccount);
            overrideAllowedPrefixesToDirectConnectGateway(model.overrideAllowedPrefixesToDirectConnectGateway);
        }

        public final String getDirectConnectGatewayId() {
            return directConnectGatewayId;
        }

        public final void setDirectConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
        }

        @Override
        public final Builder directConnectGatewayId(String directConnectGatewayId) {
            this.directConnectGatewayId = directConnectGatewayId;
            return this;
        }

        public final String getProposalId() {
            return proposalId;
        }

        public final void setProposalId(String proposalId) {
            this.proposalId = proposalId;
        }

        @Override
        public final Builder proposalId(String proposalId) {
            this.proposalId = proposalId;
            return this;
        }

        public final String getAssociatedGatewayOwnerAccount() {
            return associatedGatewayOwnerAccount;
        }

        public final void setAssociatedGatewayOwnerAccount(String associatedGatewayOwnerAccount) {
            this.associatedGatewayOwnerAccount = associatedGatewayOwnerAccount;
        }

        @Override
        public final Builder associatedGatewayOwnerAccount(String associatedGatewayOwnerAccount) {
            this.associatedGatewayOwnerAccount = associatedGatewayOwnerAccount;
            return this;
        }

        public final List<RouteFilterPrefix.Builder> getOverrideAllowedPrefixesToDirectConnectGateway() {
            List<RouteFilterPrefix.Builder> result = RouteFilterPrefixListCopier
                    .copyToBuilder(this.overrideAllowedPrefixesToDirectConnectGateway);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrideAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix.BuilderImpl> overrideAllowedPrefixesToDirectConnectGateway) {
            this.overrideAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copyFromBuilder(overrideAllowedPrefixesToDirectConnectGateway);
        }

        @Override
        public final Builder overrideAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> overrideAllowedPrefixesToDirectConnectGateway) {
            this.overrideAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copy(overrideAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrideAllowedPrefixesToDirectConnectGateway(
                RouteFilterPrefix... overrideAllowedPrefixesToDirectConnectGateway) {
            overrideAllowedPrefixesToDirectConnectGateway(Arrays.asList(overrideAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrideAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... overrideAllowedPrefixesToDirectConnectGateway) {
            overrideAllowedPrefixesToDirectConnectGateway(Stream.of(overrideAllowedPrefixesToDirectConnectGateway)
                    .map(c -> RouteFilterPrefix.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptDirectConnectGatewayAssociationProposalRequest build() {
            return new AcceptDirectConnectGatewayAssociationProposalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
