/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.Tag;
import software.amazon.awssdk.services.directconnect.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocateHostedConnectionRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, AllocateHostedConnectionRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(AllocateHostedConnectionRequest.getter(AllocateHostedConnectionRequest::connectionId)).setter(AllocateHostedConnectionRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(AllocateHostedConnectionRequest.getter(AllocateHostedConnectionRequest::ownerAccount)).setter(AllocateHostedConnectionRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bandwidth").getter(AllocateHostedConnectionRequest.getter(AllocateHostedConnectionRequest::bandwidth)).setter(AllocateHostedConnectionRequest.setter(Builder::bandwidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidth").build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionName").getter(AllocateHostedConnectionRequest.getter(AllocateHostedConnectionRequest::connectionName)).setter(AllocateHostedConnectionRequest.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionName").build()}).build();
    private static final SdkField<Integer> VLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("vlan").getter(AllocateHostedConnectionRequest.getter(AllocateHostedConnectionRequest::vlan)).setter(AllocateHostedConnectionRequest.setter(Builder::vlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vlan").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(AllocateHostedConnectionRequest.getter(AllocateHostedConnectionRequest::tags)).setter(AllocateHostedConnectionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, OWNER_ACCOUNT_FIELD, BANDWIDTH_FIELD, CONNECTION_NAME_FIELD, VLAN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AllocateHostedConnectionRequest.memberNameToFieldInitializer();
    private final String connectionId;
    private final String ownerAccount;
    private final String bandwidth;
    private final String connectionName;
    private final Integer vlan;
    private final List<Tag> tags;

    private AllocateHostedConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.ownerAccount = builder.ownerAccount;
        this.bandwidth = builder.bandwidth;
        this.connectionName = builder.connectionName;
        this.vlan = builder.vlan;
        this.tags = builder.tags;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String bandwidth() {
        return this.bandwidth;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final Integer vlan() {
        return this.vlan;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostedConnectionRequest)) {
            return false;
        }
        AllocateHostedConnectionRequest other = (AllocateHostedConnectionRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.vlan(), other.vlan()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AllocateHostedConnectionRequest").add("ConnectionId", (Object)this.connectionId()).add("OwnerAccount", (Object)this.ownerAccount()).add("Bandwidth", (Object)this.bandwidth()).add("ConnectionName", (Object)this.connectionName()).add("Vlan", (Object)this.vlan()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "connectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "vlan": {
                return Optional.ofNullable(clazz.cast(this.vlan()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("ownerAccount", OWNER_ACCOUNT_FIELD);
        map.put("bandwidth", BANDWIDTH_FIELD);
        map.put("connectionName", CONNECTION_NAME_FIELD);
        map.put("vlan", VLAN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AllocateHostedConnectionRequest, T> g) {
        return obj -> g.apply((AllocateHostedConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private String ownerAccount;
        private String bandwidth;
        private String connectionName;
        private Integer vlan;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostedConnectionRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.ownerAccount(model.ownerAccount);
            this.bandwidth(model.bandwidth);
            this.connectionName(model.connectionName);
            this.vlan(model.vlan);
            this.tags(model.tags);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final Integer getVlan() {
            return this.vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocateHostedConnectionRequest build() {
            return new AllocateHostedConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AllocateHostedConnectionRequest> {
        public Builder connectionId(String var1);

        public Builder ownerAccount(String var1);

        public Builder bandwidth(String var1);

        public Builder connectionName(String var1);

        public Builder vlan(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

